package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation a Kafka Connect build to add additional connectors
   */
  public class BuildBuilder extends io.strimzi.api.kafka.model.connect.build.BuildFluentImpl<io.strimzi.api.kafka.model.connect.build.BuildBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.connect.build.Build,io.strimzi.api.kafka.model.connect.build.BuildBuilder> {

    io.strimzi.api.kafka.model.connect.build.BuildFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public BuildBuilder() {
        this(true);
    }

    public BuildBuilder(java.lang.Boolean validationEnabled) {
        this(new Build(), validationEnabled);
    }

    public BuildBuilder(io.strimzi.api.kafka.model.connect.build.BuildFluent<?> fluent) {
        this(fluent, true);
    }

    public BuildBuilder(io.strimzi.api.kafka.model.connect.build.BuildFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Build(), validationEnabled);
    }

    public BuildBuilder(io.strimzi.api.kafka.model.connect.build.BuildFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.Build instance) {
        this(fluent, instance, true);
    }

    public BuildBuilder(io.strimzi.api.kafka.model.connect.build.BuildFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.Build instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withOutput(instance.getOutput());
        
        fluent.withPlugins(instance.getPlugins());
        
        fluent.withResources(instance.getResources());
        
        this.validationEnabled = validationEnabled; 
    }

    public BuildBuilder(io.strimzi.api.kafka.model.connect.build.Build instance) {
        this(instance,true);
    }

    public BuildBuilder(io.strimzi.api.kafka.model.connect.build.Build instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withOutput(instance.getOutput());
        
        this.withPlugins(instance.getPlugins());
        
        this.withResources(instance.getResources());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.connect.build.Build build() {
        Build buildable = new Build();
        buildable.setOutput(fluent.getOutput());
        buildable.setPlugins(fluent.getPlugins());
        buildable.setResources(fluent.getResources());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuildBuilder that = (BuildBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
