package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

  
  /**
   * Representation a Kafka Connect build to add additional connectors
   */
  public class BuildFluentImpl<A extends io.strimzi.api.kafka.model.connect.build.BuildFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.connect.build.BuildFluent<A> {

    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Output,?> output;
    private java.util.List<io.strimzi.api.kafka.model.connect.build.PluginBuilder> plugins;
    private io.fabric8.kubernetes.api.model.ResourceRequirements resources;

    public BuildFluentImpl() {
    }

    public BuildFluentImpl(io.strimzi.api.kafka.model.connect.build.Build instance) {
        this.withOutput(instance.getOutput());
        
        this.withPlugins(instance.getPlugins());
        
        this.withResources(instance.getResources());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildOutput instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.connect.build.Output getOutput() {
        return this.output!=null?this.output.build():null;
    }

    public io.strimzi.api.kafka.model.connect.build.Output buildOutput() {
        return this.output!=null?this.output.build():null;
    }

    public A withOutput(io.strimzi.api.kafka.model.connect.build.Output output) {
        if (output instanceof io.strimzi.api.kafka.model.connect.build.ImageStreamOutput){ this.output= new io.strimzi.api.kafka.model.connect.build.ImageStreamOutputBuilder((io.strimzi.api.kafka.model.connect.build.ImageStreamOutput)output); _visitables.get("output").add(this.output);}
        if (output instanceof io.strimzi.api.kafka.model.connect.build.DockerOutput){ this.output= new io.strimzi.api.kafka.model.connect.build.DockerOutputBuilder((io.strimzi.api.kafka.model.connect.build.DockerOutput)output); _visitables.get("output").add(this.output);}
        return (A) this;
    }

    public java.lang.Boolean hasOutput() {
        return this.output != null;
    }

    public A withImageStreamOutput(io.strimzi.api.kafka.model.connect.build.ImageStreamOutput imageStreamOutput) {
        _visitables.get("output").remove(this.output);
        if (imageStreamOutput!=null){ this.output= new io.strimzi.api.kafka.model.connect.build.ImageStreamOutputBuilder(imageStreamOutput); _visitables.get("output").add(this.output);} return (A) this;
    }

    public io.strimzi.api.kafka.model.connect.build.BuildFluent.ImageStreamOutputNested<A> withNewImageStreamOutput() {
        return new io.strimzi.api.kafka.model.connect.build.BuildFluentImpl.ImageStreamOutputNestedImpl();
    }

    public io.strimzi.api.kafka.model.connect.build.BuildFluent.ImageStreamOutputNested<A> withNewImageStreamOutputLike(io.strimzi.api.kafka.model.connect.build.ImageStreamOutput item) {
        return new io.strimzi.api.kafka.model.connect.build.BuildFluentImpl.ImageStreamOutputNestedImpl(item);
    }

    public A withDockerOutput(io.strimzi.api.kafka.model.connect.build.DockerOutput dockerOutput) {
        _visitables.get("output").remove(this.output);
        if (dockerOutput!=null){ this.output= new io.strimzi.api.kafka.model.connect.build.DockerOutputBuilder(dockerOutput); _visitables.get("output").add(this.output);} return (A) this;
    }

    public io.strimzi.api.kafka.model.connect.build.BuildFluent.DockerOutputNested<A> withNewDockerOutput() {
        return new io.strimzi.api.kafka.model.connect.build.BuildFluentImpl.DockerOutputNestedImpl();
    }

    public io.strimzi.api.kafka.model.connect.build.BuildFluent.DockerOutputNested<A> withNewDockerOutputLike(io.strimzi.api.kafka.model.connect.build.DockerOutput item) {
        return new io.strimzi.api.kafka.model.connect.build.BuildFluentImpl.DockerOutputNestedImpl(item);
    }

    public A addToPlugins(int index,io.strimzi.api.kafka.model.connect.build.Plugin item) {
        if (this.plugins == null) {this.plugins = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.build.PluginBuilder>();}
        io.strimzi.api.kafka.model.connect.build.PluginBuilder builder = new io.strimzi.api.kafka.model.connect.build.PluginBuilder(item);_visitables.get("plugins").add(index >= 0 ? index : _visitables.get("plugins").size(), builder);this.plugins.add(index >= 0 ? index : plugins.size(), builder); return (A)this;
    }

    public A setToPlugins(int index,io.strimzi.api.kafka.model.connect.build.Plugin item) {
        if (this.plugins == null) {this.plugins = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.build.PluginBuilder>();}
        io.strimzi.api.kafka.model.connect.build.PluginBuilder builder = new io.strimzi.api.kafka.model.connect.build.PluginBuilder(item);
        if (index < 0 || index >= _visitables.get("plugins").size()) { _visitables.get("plugins").add(builder); } else { _visitables.get("plugins").set(index, builder);}
        if (index < 0 || index >= plugins.size()) { plugins.add(builder); } else { plugins.set(index, builder);}
         return (A)this;
    }

    public A addToPlugins(io.strimzi.api.kafka.model.connect.build.Plugin... items) {
        if (this.plugins == null) {this.plugins = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.build.PluginBuilder>();}
        for (io.strimzi.api.kafka.model.connect.build.Plugin item : items) {io.strimzi.api.kafka.model.connect.build.PluginBuilder builder = new io.strimzi.api.kafka.model.connect.build.PluginBuilder(item);_visitables.get("plugins").add(builder);this.plugins.add(builder);} return (A)this;
    }

    public A addAllToPlugins(java.util.Collection<io.strimzi.api.kafka.model.connect.build.Plugin> items) {
        if (this.plugins == null) {this.plugins = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.build.PluginBuilder>();}
        for (io.strimzi.api.kafka.model.connect.build.Plugin item : items) {io.strimzi.api.kafka.model.connect.build.PluginBuilder builder = new io.strimzi.api.kafka.model.connect.build.PluginBuilder(item);_visitables.get("plugins").add(builder);this.plugins.add(builder);} return (A)this;
    }

    public A removeFromPlugins(io.strimzi.api.kafka.model.connect.build.Plugin... items) {
        for (io.strimzi.api.kafka.model.connect.build.Plugin item : items) {io.strimzi.api.kafka.model.connect.build.PluginBuilder builder = new io.strimzi.api.kafka.model.connect.build.PluginBuilder(item);_visitables.get("plugins").remove(builder);if (this.plugins != null) {this.plugins.remove(builder);}} return (A)this;
    }

    public A removeAllFromPlugins(java.util.Collection<io.strimzi.api.kafka.model.connect.build.Plugin> items) {
        for (io.strimzi.api.kafka.model.connect.build.Plugin item : items) {io.strimzi.api.kafka.model.connect.build.PluginBuilder builder = new io.strimzi.api.kafka.model.connect.build.PluginBuilder(item);_visitables.get("plugins").remove(builder);if (this.plugins != null) {this.plugins.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPlugins(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.build.PluginBuilder> predicate) {
        if (plugins == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.connect.build.PluginBuilder> each = plugins.iterator();
        final List visitables = _visitables.get("plugins");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.connect.build.PluginBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPlugins instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.connect.build.Plugin> getPlugins() {
        return build(plugins);
    }

    public java.util.List<io.strimzi.api.kafka.model.connect.build.Plugin> buildPlugins() {
        return build(plugins);
    }

    public io.strimzi.api.kafka.model.connect.build.Plugin buildPlugin(int index) {
        return this.plugins.get(index).build();
    }

    public io.strimzi.api.kafka.model.connect.build.Plugin buildFirstPlugin() {
        return this.plugins.get(0).build();
    }

    public io.strimzi.api.kafka.model.connect.build.Plugin buildLastPlugin() {
        return this.plugins.get(plugins.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.connect.build.Plugin buildMatchingPlugin(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.build.PluginBuilder> predicate) {
        for (io.strimzi.api.kafka.model.connect.build.PluginBuilder item: plugins) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingPlugin(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.build.PluginBuilder> predicate) {
        for (io.strimzi.api.kafka.model.connect.build.PluginBuilder item: plugins) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPlugins(java.util.List<io.strimzi.api.kafka.model.connect.build.Plugin> plugins) {
        if (this.plugins != null) { _visitables.get("plugins").removeAll(this.plugins);}
        if (plugins != null) {this.plugins = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.build.PluginBuilder>(); for (io.strimzi.api.kafka.model.connect.build.Plugin item : plugins){this.addToPlugins(item);}} else { this.plugins = null;} return (A) this;
    }

    public A withPlugins(io.strimzi.api.kafka.model.connect.build.Plugin... plugins) {
        if (this.plugins != null) {this.plugins.clear();}
        if (plugins != null) {for (io.strimzi.api.kafka.model.connect.build.Plugin item :plugins){ this.addToPlugins(item);}} return (A) this;
    }

    public java.lang.Boolean hasPlugins() {
        return plugins != null && !plugins.isEmpty();
    }

    public io.strimzi.api.kafka.model.connect.build.BuildFluent.PluginsNested<A> addNewPlugin() {
        return new io.strimzi.api.kafka.model.connect.build.BuildFluentImpl.PluginsNestedImpl();
    }

    public io.strimzi.api.kafka.model.connect.build.BuildFluent.PluginsNested<A> addNewPluginLike(io.strimzi.api.kafka.model.connect.build.Plugin item) {
        return new io.strimzi.api.kafka.model.connect.build.BuildFluentImpl.PluginsNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.connect.build.BuildFluent.PluginsNested<A> setNewPluginLike(int index,io.strimzi.api.kafka.model.connect.build.Plugin item) {
        return new io.strimzi.api.kafka.model.connect.build.BuildFluentImpl.PluginsNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.connect.build.BuildFluent.PluginsNested<A> editPlugin(int index) {
        if (plugins.size() <= index) throw new RuntimeException("Can't edit plugins. Index exceeds size.");
        return setNewPluginLike(index, buildPlugin(index));
    }

    public io.strimzi.api.kafka.model.connect.build.BuildFluent.PluginsNested<A> editFirstPlugin() {
        if (plugins.size() == 0) throw new RuntimeException("Can't edit first plugins. The list is empty.");
        return setNewPluginLike(0, buildPlugin(0));
    }

    public io.strimzi.api.kafka.model.connect.build.BuildFluent.PluginsNested<A> editLastPlugin() {
        int index = plugins.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last plugins. The list is empty.");
        return setNewPluginLike(index, buildPlugin(index));
    }

    public io.strimzi.api.kafka.model.connect.build.BuildFluent.PluginsNested<A> editMatchingPlugin(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.build.PluginBuilder> predicate) {
        int index = -1;
        for (int i=0;i<plugins.size();i++) { 
        if (predicate.test(plugins.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching plugins. No match found.");
        return setNewPluginLike(index, buildPlugin(index));
    }

    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
        this.resources=resources; return (A) this;
    }

    public java.lang.Boolean hasResources() {
        return this.resources != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BuildFluentImpl that = (BuildFluentImpl) o;
        if (output != null ? !output.equals(that.output) :that.output != null) return false;
        if (plugins != null ? !plugins.equals(that.plugins) :that.plugins != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(output,  plugins,  resources,  super.hashCode());
    }

      
  /**
   * Represents Docker output from the build
   */
  public class ImageStreamOutputNestedImpl<N> extends io.strimzi.api.kafka.model.connect.build.ImageStreamOutputFluentImpl<io.strimzi.api.kafka.model.connect.build.BuildFluent.ImageStreamOutputNested<N>> implements io.strimzi.api.kafka.model.connect.build.BuildFluent.ImageStreamOutputNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.connect.build.ImageStreamOutputBuilder builder;

            ImageStreamOutputNestedImpl(io.strimzi.api.kafka.model.connect.build.ImageStreamOutput item) {
                this.builder = new io.strimzi.api.kafka.model.connect.build.ImageStreamOutputBuilder(this, item);
                        
            }

            ImageStreamOutputNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.connect.build.ImageStreamOutputBuilder(this);
                        
            }

            public N and() {
                return (N) BuildFluentImpl.this.withOutput(builder.build());
            }

            public N endImageStreamOutput() {
                return and();
            }
    }


      
  /**
   * Represents Docker output from the build
   */
  public class DockerOutputNestedImpl<N> extends io.strimzi.api.kafka.model.connect.build.DockerOutputFluentImpl<io.strimzi.api.kafka.model.connect.build.BuildFluent.DockerOutputNested<N>> implements io.strimzi.api.kafka.model.connect.build.BuildFluent.DockerOutputNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.connect.build.DockerOutputBuilder builder;

            DockerOutputNestedImpl(io.strimzi.api.kafka.model.connect.build.DockerOutput item) {
                this.builder = new io.strimzi.api.kafka.model.connect.build.DockerOutputBuilder(this, item);
                        
            }

            DockerOutputNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.connect.build.DockerOutputBuilder(this);
                        
            }

            public N and() {
                return (N) BuildFluentImpl.this.withOutput(builder.build());
            }

            public N endDockerOutput() {
                return and();
            }
    }


      
  /**
   * Representation a connector within a Kafka Connect build
   */
  public class PluginsNestedImpl<N> extends io.strimzi.api.kafka.model.connect.build.PluginFluentImpl<io.strimzi.api.kafka.model.connect.build.BuildFluent.PluginsNested<N>> implements io.strimzi.api.kafka.model.connect.build.BuildFluent.PluginsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.connect.build.PluginBuilder builder;
        private final int index;

            PluginsNestedImpl(int index,io.strimzi.api.kafka.model.connect.build.Plugin item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.connect.build.PluginBuilder(this, item);
                        
            }

            PluginsNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.connect.build.PluginBuilder(this);
                        
            }

            public N and() {
                return (N) BuildFluentImpl.this.setToPlugins(index,builder.build());
            }

            public N endPlugin() {
                return and();
            }
    }


}
