package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents Docker output from the build
   */
  public class DockerOutputBuilder extends io.strimzi.api.kafka.model.connect.build.DockerOutputFluentImpl<io.strimzi.api.kafka.model.connect.build.DockerOutputBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.connect.build.DockerOutput,io.strimzi.api.kafka.model.connect.build.DockerOutputBuilder> {

    io.strimzi.api.kafka.model.connect.build.DockerOutputFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public DockerOutputBuilder() {
        this(true);
    }

    public DockerOutputBuilder(java.lang.Boolean validationEnabled) {
        this(new DockerOutput(), validationEnabled);
    }

    public DockerOutputBuilder(io.strimzi.api.kafka.model.connect.build.DockerOutputFluent<?> fluent) {
        this(fluent, true);
    }

    public DockerOutputBuilder(io.strimzi.api.kafka.model.connect.build.DockerOutputFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new DockerOutput(), validationEnabled);
    }

    public DockerOutputBuilder(io.strimzi.api.kafka.model.connect.build.DockerOutputFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.DockerOutput instance) {
        this(fluent, instance, true);
    }

    public DockerOutputBuilder(io.strimzi.api.kafka.model.connect.build.DockerOutputFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.DockerOutput instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withImage(instance.getImage());
        
        fluent.withPushSecret(instance.getPushSecret());
        
        fluent.withAdditionalKanikoOptions(instance.getAdditionalKanikoOptions());
        
        this.validationEnabled = validationEnabled; 
    }

    public DockerOutputBuilder(io.strimzi.api.kafka.model.connect.build.DockerOutput instance) {
        this(instance,true);
    }

    public DockerOutputBuilder(io.strimzi.api.kafka.model.connect.build.DockerOutput instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withImage(instance.getImage());
        
        this.withPushSecret(instance.getPushSecret());
        
        this.withAdditionalKanikoOptions(instance.getAdditionalKanikoOptions());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.connect.build.DockerOutput build() {
        DockerOutput buildable = new DockerOutput();
        buildable.setImage(fluent.getImage());
        buildable.setPushSecret(fluent.getPushSecret());
        buildable.setAdditionalKanikoOptions(fluent.getAdditionalKanikoOptions());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DockerOutputBuilder that = (DockerOutputBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
