package io.strimzi.api.kafka.model.connect.build;

import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

  
  /**
   * Artifact which can be just downloaded from an URL
   */
  public class DownloadableArtifactFluentImpl<A extends io.strimzi.api.kafka.model.connect.build.DownloadableArtifactFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.connect.build.DownloadableArtifactFluent<A> {

    private java.lang.String url;
    private java.lang.String sha512sum;
    private java.lang.Boolean insecure;

    public DownloadableArtifactFluentImpl() {
    }

    public DownloadableArtifactFluentImpl(io.strimzi.api.kafka.model.connect.build.DownloadableArtifact instance) {
        this.withUrl(instance.getUrl());
        
        this.withSha512sum(instance.getSha512sum());
        
        this.withInsecure(instance.getInsecure());
    }

    public java.lang.String getUrl() {
        return this.url;
    }

    public A withUrl(java.lang.String url) {
        this.url=url; return (A) this;
    }

    public java.lang.Boolean hasUrl() {
        return this.url != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUrl instead.
     */
        public A withNewUrl(java.lang.String original) {
        return (A)withUrl(new String(original));
    }

    public java.lang.String getSha512sum() {
        return this.sha512sum;
    }

    public A withSha512sum(java.lang.String sha512sum) {
        this.sha512sum=sha512sum; return (A) this;
    }

    public java.lang.Boolean hasSha512sum() {
        return this.sha512sum != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withSha512sum instead.
     */
        public A withNewSha512sum(java.lang.String original) {
        return (A)withSha512sum(new String(original));
    }

    public java.lang.Boolean getInsecure() {
        return this.insecure;
    }

    public A withInsecure(java.lang.Boolean insecure) {
        this.insecure=insecure; return (A) this;
    }

    public java.lang.Boolean hasInsecure() {
        return this.insecure != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DownloadableArtifactFluentImpl that = (DownloadableArtifactFluentImpl) o;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        if (sha512sum != null ? !sha512sum.equals(that.sha512sum) :that.sha512sum != null) return false;
        if (insecure != null ? !insecure.equals(that.insecure) :that.insecure != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(url,  sha512sum,  insecure,  super.hashCode());
    }

}
