package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents Docker output from the build
   */
  public class ImageStreamOutputBuilder extends io.strimzi.api.kafka.model.connect.build.ImageStreamOutputFluentImpl<io.strimzi.api.kafka.model.connect.build.ImageStreamOutputBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.connect.build.ImageStreamOutput,io.strimzi.api.kafka.model.connect.build.ImageStreamOutputBuilder> {

    io.strimzi.api.kafka.model.connect.build.ImageStreamOutputFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ImageStreamOutputBuilder() {
        this(true);
    }

    public ImageStreamOutputBuilder(java.lang.Boolean validationEnabled) {
        this(new ImageStreamOutput(), validationEnabled);
    }

    public ImageStreamOutputBuilder(io.strimzi.api.kafka.model.connect.build.ImageStreamOutputFluent<?> fluent) {
        this(fluent, true);
    }

    public ImageStreamOutputBuilder(io.strimzi.api.kafka.model.connect.build.ImageStreamOutputFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ImageStreamOutput(), validationEnabled);
    }

    public ImageStreamOutputBuilder(io.strimzi.api.kafka.model.connect.build.ImageStreamOutputFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.ImageStreamOutput instance) {
        this(fluent, instance, true);
    }

    public ImageStreamOutputBuilder(io.strimzi.api.kafka.model.connect.build.ImageStreamOutputFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.ImageStreamOutput instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withImage(instance.getImage());
        
        this.validationEnabled = validationEnabled; 
    }

    public ImageStreamOutputBuilder(io.strimzi.api.kafka.model.connect.build.ImageStreamOutput instance) {
        this(instance,true);
    }

    public ImageStreamOutputBuilder(io.strimzi.api.kafka.model.connect.build.ImageStreamOutput instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withImage(instance.getImage());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.connect.build.ImageStreamOutput build() {
        ImageStreamOutput buildable = new ImageStreamOutput();
        buildable.setImage(fluent.getImage());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImageStreamOutputBuilder that = (ImageStreamOutputBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
