package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * JAR artifact represents an artifact which is simply downloaded
   */
  public class JarArtifactBuilder extends io.strimzi.api.kafka.model.connect.build.JarArtifactFluentImpl<io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.connect.build.JarArtifact,io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder> {

    io.strimzi.api.kafka.model.connect.build.JarArtifactFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public JarArtifactBuilder() {
        this(true);
    }

    public JarArtifactBuilder(java.lang.Boolean validationEnabled) {
        this(new JarArtifact(), validationEnabled);
    }

    public JarArtifactBuilder(io.strimzi.api.kafka.model.connect.build.JarArtifactFluent<?> fluent) {
        this(fluent, true);
    }

    public JarArtifactBuilder(io.strimzi.api.kafka.model.connect.build.JarArtifactFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new JarArtifact(), validationEnabled);
    }

    public JarArtifactBuilder(io.strimzi.api.kafka.model.connect.build.JarArtifactFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.JarArtifact instance) {
        this(fluent, instance, true);
    }

    public JarArtifactBuilder(io.strimzi.api.kafka.model.connect.build.JarArtifactFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.JarArtifact instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withUrl(instance.getUrl());
        
        fluent.withSha512sum(instance.getSha512sum());
        
        fluent.withInsecure(instance.getInsecure());
        
        this.validationEnabled = validationEnabled; 
    }

    public JarArtifactBuilder(io.strimzi.api.kafka.model.connect.build.JarArtifact instance) {
        this(instance,true);
    }

    public JarArtifactBuilder(io.strimzi.api.kafka.model.connect.build.JarArtifact instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withUrl(instance.getUrl());
        
        this.withSha512sum(instance.getSha512sum());
        
        this.withInsecure(instance.getInsecure());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.connect.build.JarArtifact build() {
        JarArtifact buildable = new JarArtifact();
        buildable.setUrl(fluent.getUrl());
        buildable.setSha512sum(fluent.getSha512sum());
        buildable.setInsecure(fluent.getInsecure());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JarArtifactBuilder that = (JarArtifactBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
