package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Maven artifact represents an artifact which is downloaded from Maven repository
   */
  public class MavenArtifactBuilder extends io.strimzi.api.kafka.model.connect.build.MavenArtifactFluentImpl<io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.connect.build.MavenArtifact,io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder> {

    io.strimzi.api.kafka.model.connect.build.MavenArtifactFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public MavenArtifactBuilder() {
        this(true);
    }

    public MavenArtifactBuilder(java.lang.Boolean validationEnabled) {
        this(new MavenArtifact(), validationEnabled);
    }

    public MavenArtifactBuilder(io.strimzi.api.kafka.model.connect.build.MavenArtifactFluent<?> fluent) {
        this(fluent, true);
    }

    public MavenArtifactBuilder(io.strimzi.api.kafka.model.connect.build.MavenArtifactFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new MavenArtifact(), validationEnabled);
    }

    public MavenArtifactBuilder(io.strimzi.api.kafka.model.connect.build.MavenArtifactFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.MavenArtifact instance) {
        this(fluent, instance, true);
    }

    public MavenArtifactBuilder(io.strimzi.api.kafka.model.connect.build.MavenArtifactFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.MavenArtifact instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withGroup(instance.getGroup());
        
        fluent.withArtifact(instance.getArtifact());
        
        fluent.withVersion(instance.getVersion());
        
        fluent.withRepository(instance.getRepository());
        
        this.validationEnabled = validationEnabled; 
    }

    public MavenArtifactBuilder(io.strimzi.api.kafka.model.connect.build.MavenArtifact instance) {
        this(instance,true);
    }

    public MavenArtifactBuilder(io.strimzi.api.kafka.model.connect.build.MavenArtifact instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withGroup(instance.getGroup());
        
        this.withArtifact(instance.getArtifact());
        
        this.withVersion(instance.getVersion());
        
        this.withRepository(instance.getRepository());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.connect.build.MavenArtifact build() {
        MavenArtifact buildable = new MavenArtifact();
        buildable.setGroup(fluent.getGroup());
        buildable.setArtifact(fluent.getArtifact());
        buildable.setVersion(fluent.getVersion());
        buildable.setRepository(fluent.getRepository());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MavenArtifactBuilder that = (MavenArtifactBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
