package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Other artifact represents an artifact of assorted types. Users can specify a name of the file under which it will be
   * stored in the container image.
   */
  public class OtherArtifactBuilder extends io.strimzi.api.kafka.model.connect.build.OtherArtifactFluentImpl<io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.connect.build.OtherArtifact,io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder> {

    io.strimzi.api.kafka.model.connect.build.OtherArtifactFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public OtherArtifactBuilder() {
        this(true);
    }

    public OtherArtifactBuilder(java.lang.Boolean validationEnabled) {
        this(new OtherArtifact(), validationEnabled);
    }

    public OtherArtifactBuilder(io.strimzi.api.kafka.model.connect.build.OtherArtifactFluent<?> fluent) {
        this(fluent, true);
    }

    public OtherArtifactBuilder(io.strimzi.api.kafka.model.connect.build.OtherArtifactFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new OtherArtifact(), validationEnabled);
    }

    public OtherArtifactBuilder(io.strimzi.api.kafka.model.connect.build.OtherArtifactFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.OtherArtifact instance) {
        this(fluent, instance, true);
    }

    public OtherArtifactBuilder(io.strimzi.api.kafka.model.connect.build.OtherArtifactFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.OtherArtifact instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFileName(instance.getFileName());
        
        fluent.withUrl(instance.getUrl());
        
        fluent.withSha512sum(instance.getSha512sum());
        
        fluent.withInsecure(instance.getInsecure());
        
        this.validationEnabled = validationEnabled; 
    }

    public OtherArtifactBuilder(io.strimzi.api.kafka.model.connect.build.OtherArtifact instance) {
        this(instance,true);
    }

    public OtherArtifactBuilder(io.strimzi.api.kafka.model.connect.build.OtherArtifact instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withFileName(instance.getFileName());
        
        this.withUrl(instance.getUrl());
        
        this.withSha512sum(instance.getSha512sum());
        
        this.withInsecure(instance.getInsecure());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.connect.build.OtherArtifact build() {
        OtherArtifact buildable = new OtherArtifact();
        buildable.setUrl(fluent.getUrl());
        buildable.setSha512sum(fluent.getSha512sum());
        buildable.setInsecure(fluent.getInsecure());
        buildable.setFileName(fluent.getFileName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OtherArtifactBuilder that = (OtherArtifactBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
