package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation a connector within a Kafka Connect build
   */
  public class PluginBuilder extends io.strimzi.api.kafka.model.connect.build.PluginFluentImpl<io.strimzi.api.kafka.model.connect.build.PluginBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.connect.build.Plugin,io.strimzi.api.kafka.model.connect.build.PluginBuilder> {

    io.strimzi.api.kafka.model.connect.build.PluginFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PluginBuilder() {
        this(true);
    }

    public PluginBuilder(java.lang.Boolean validationEnabled) {
        this(new Plugin(), validationEnabled);
    }

    public PluginBuilder(io.strimzi.api.kafka.model.connect.build.PluginFluent<?> fluent) {
        this(fluent, true);
    }

    public PluginBuilder(io.strimzi.api.kafka.model.connect.build.PluginFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Plugin(), validationEnabled);
    }

    public PluginBuilder(io.strimzi.api.kafka.model.connect.build.PluginFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.Plugin instance) {
        this(fluent, instance, true);
    }

    public PluginBuilder(io.strimzi.api.kafka.model.connect.build.PluginFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.Plugin instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName());
        
        fluent.withArtifacts(instance.getArtifacts());
        
        this.validationEnabled = validationEnabled; 
    }

    public PluginBuilder(io.strimzi.api.kafka.model.connect.build.Plugin instance) {
        this(instance,true);
    }

    public PluginBuilder(io.strimzi.api.kafka.model.connect.build.Plugin instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName());
        
        this.withArtifacts(instance.getArtifacts());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.connect.build.Plugin build() {
        Plugin buildable = new Plugin();
        buildable.setName(fluent.getName());
        buildable.setArtifacts(fluent.getArtifacts());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PluginBuilder that = (PluginBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
