package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

  
  /**
   * Representation a connector within a Kafka Connect build
   */
  public interface PluginFluent<A extends io.strimzi.api.kafka.model.connect.build.PluginFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.String getName();
    public A withName(java.lang.String name);
    public java.lang.Boolean hasName();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String original);
    public A addToArtifacts(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder);
    public A addToArtifacts(int index,io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder);
    public A addToArtifacts(int index,io.strimzi.api.kafka.model.connect.build.Artifact item);
    public A setToArtifacts(int index,io.strimzi.api.kafka.model.connect.build.Artifact item);
    public A addToArtifacts(io.strimzi.api.kafka.model.connect.build.Artifact... items);
    public A addAllToArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.Artifact> items);
    public A removeFromArtifacts(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder);
    public A removeFromArtifacts(io.strimzi.api.kafka.model.connect.build.Artifact... items);
    public A removeAllFromArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.Artifact> items);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildArtifacts instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.connect.build.Artifact> getArtifacts();
    public java.util.List<io.strimzi.api.kafka.model.connect.build.Artifact> buildArtifacts();
    public io.strimzi.api.kafka.model.connect.build.Artifact buildArtifact(int index);
    public io.strimzi.api.kafka.model.connect.build.Artifact buildFirstArtifact();
    public io.strimzi.api.kafka.model.connect.build.Artifact buildLastArtifact();
    public io.strimzi.api.kafka.model.connect.build.Artifact buildMatchingArtifact(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> predicate);
    public java.lang.Boolean hasMatchingArtifact(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> predicate);
    public A withArtifacts(java.util.List<io.strimzi.api.kafka.model.connect.build.Artifact> artifacts);
    public A withArtifacts(io.strimzi.api.kafka.model.connect.build.Artifact... artifacts);
    public java.lang.Boolean hasArtifacts();
    public A addToMavenArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.MavenArtifact item);
    public A setToMavenArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.MavenArtifact item);
    public A addToMavenArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.MavenArtifact... items);
    public A addAllToMavenArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.MavenArtifact> items);
    public A removeFromMavenArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.MavenArtifact... items);
    public A removeAllFromMavenArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.MavenArtifact> items);
    public A removeMatchingFromMavenArtifactArtifacts(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> predicate);
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.MavenArtifactArtifactsNested<A> setNewMavenArtifactArtifactLike(int index,io.strimzi.api.kafka.model.connect.build.MavenArtifact item);
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.MavenArtifactArtifactsNested<A> addNewMavenArtifactArtifact();
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.MavenArtifactArtifactsNested<A> addNewMavenArtifactArtifactLike(io.strimzi.api.kafka.model.connect.build.MavenArtifact item);
    public A addToZipArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.ZipArtifact item);
    public A setToZipArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.ZipArtifact item);
    public A addToZipArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.ZipArtifact... items);
    public A addAllToZipArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.ZipArtifact> items);
    public A removeFromZipArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.ZipArtifact... items);
    public A removeAllFromZipArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.ZipArtifact> items);
    public A removeMatchingFromZipArtifactArtifacts(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> predicate);
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.ZipArtifactArtifactsNested<A> setNewZipArtifactArtifactLike(int index,io.strimzi.api.kafka.model.connect.build.ZipArtifact item);
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.ZipArtifactArtifactsNested<A> addNewZipArtifactArtifact();
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.ZipArtifactArtifactsNested<A> addNewZipArtifactArtifactLike(io.strimzi.api.kafka.model.connect.build.ZipArtifact item);
    public A addToOtherArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.OtherArtifact item);
    public A setToOtherArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.OtherArtifact item);
    public A addToOtherArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.OtherArtifact... items);
    public A addAllToOtherArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.OtherArtifact> items);
    public A removeFromOtherArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.OtherArtifact... items);
    public A removeAllFromOtherArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.OtherArtifact> items);
    public A removeMatchingFromOtherArtifactArtifacts(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> predicate);
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.OtherArtifactArtifactsNested<A> setNewOtherArtifactArtifactLike(int index,io.strimzi.api.kafka.model.connect.build.OtherArtifact item);
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.OtherArtifactArtifactsNested<A> addNewOtherArtifactArtifact();
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.OtherArtifactArtifactsNested<A> addNewOtherArtifactArtifactLike(io.strimzi.api.kafka.model.connect.build.OtherArtifact item);
    public A addToJarArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.JarArtifact item);
    public A setToJarArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.JarArtifact item);
    public A addToJarArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.JarArtifact... items);
    public A addAllToJarArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.JarArtifact> items);
    public A removeFromJarArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.JarArtifact... items);
    public A removeAllFromJarArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.JarArtifact> items);
    public A removeMatchingFromJarArtifactArtifacts(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> predicate);
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.JarArtifactArtifactsNested<A> setNewJarArtifactArtifactLike(int index,io.strimzi.api.kafka.model.connect.build.JarArtifact item);
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.JarArtifactArtifactsNested<A> addNewJarArtifactArtifact();
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.JarArtifactArtifactsNested<A> addNewJarArtifactArtifactLike(io.strimzi.api.kafka.model.connect.build.JarArtifact item);
    public A addToTgzArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.TgzArtifact item);
    public A setToTgzArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.TgzArtifact item);
    public A addToTgzArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.TgzArtifact... items);
    public A addAllToTgzArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.TgzArtifact> items);
    public A removeFromTgzArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.TgzArtifact... items);
    public A removeAllFromTgzArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.TgzArtifact> items);
    public A removeMatchingFromTgzArtifactArtifacts(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> predicate);
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.TgzArtifactArtifactsNested<A> setNewTgzArtifactArtifactLike(int index,io.strimzi.api.kafka.model.connect.build.TgzArtifact item);
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.TgzArtifactArtifactsNested<A> addNewTgzArtifactArtifact();
    public io.strimzi.api.kafka.model.connect.build.PluginFluent.TgzArtifactArtifactsNested<A> addNewTgzArtifactArtifactLike(io.strimzi.api.kafka.model.connect.build.TgzArtifact item);
      
  /**
   * Maven artifact represents an artifact which is downloaded from Maven repository
   */
  public interface MavenArtifactArtifactsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.connect.build.MavenArtifactFluent<io.strimzi.api.kafka.model.connect.build.PluginFluent.MavenArtifactArtifactsNested<N>> {

            public N and();
            public N endMavenArtifactArtifact();    }


      
  /**
   * ZIP artifact represents an artifact which is downloaded and unpacked using `unzip`
   */
  public interface ZipArtifactArtifactsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.connect.build.ZipArtifactFluent<io.strimzi.api.kafka.model.connect.build.PluginFluent.ZipArtifactArtifactsNested<N>> {

            public N and();
            public N endZipArtifactArtifact();    }


      
  /**
   * Other artifact represents an artifact of assorted types. Users can specify a name of the file under which it will be
   * stored in the container image.
   */
  public interface OtherArtifactArtifactsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.connect.build.OtherArtifactFluent<io.strimzi.api.kafka.model.connect.build.PluginFluent.OtherArtifactArtifactsNested<N>> {

            public N and();
            public N endOtherArtifactArtifact();    }


      
  /**
   * JAR artifact represents an artifact which is simply downloaded
   */
  public interface JarArtifactArtifactsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.connect.build.JarArtifactFluent<io.strimzi.api.kafka.model.connect.build.PluginFluent.JarArtifactArtifactsNested<N>> {

            public N and();
            public N endJarArtifactArtifact();    }


      
  /**
   * TGZ artifact represents an artifact which is downloaded and unpacked using TAR (with GZIP decompression)
   */
  public interface TgzArtifactArtifactsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.connect.build.TgzArtifactFluent<io.strimzi.api.kafka.model.connect.build.PluginFluent.TgzArtifactArtifactsNested<N>> {

            public N and();
            public N endTgzArtifactArtifact();    }


}
