package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

  
  /**
   * Representation a connector within a Kafka Connect build
   */
  public class PluginFluentImpl<A extends io.strimzi.api.kafka.model.connect.build.PluginFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.connect.build.PluginFluent<A> {

    private java.lang.String name;
    private java.util.List<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> artifacts;

    public PluginFluentImpl() {
    }

    public PluginFluentImpl(io.strimzi.api.kafka.model.connect.build.Plugin instance) {
        this.withName(instance.getName());
        
        this.withArtifacts(instance.getArtifacts());
    }

    public java.lang.String getName() {
        return this.name;
    }

    public A withName(java.lang.String name) {
        this.name=name; return (A) this;
    }

    public java.lang.Boolean hasName() {
        return this.name != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String original) {
        return (A)withName(new String(original));
    }

    public A addToArtifacts(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        _visitables.get("artifacts").add(builder);this.artifacts.add(builder); return (A)this;
    }

    public A addToArtifacts(int index,io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        _visitables.get("artifacts").add(index, builder);this.artifacts.add(index, builder); return (A)this;
    }

    public A addToArtifacts(int index,io.strimzi.api.kafka.model.connect.build.Artifact item) {
        if (item instanceof io.strimzi.api.kafka.model.connect.build.MavenArtifact){addToMavenArtifactArtifacts(index, (io.strimzi.api.kafka.model.connect.build.MavenArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.ZipArtifact){addToZipArtifactArtifacts(index, (io.strimzi.api.kafka.model.connect.build.ZipArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.OtherArtifact){addToOtherArtifactArtifacts(index, (io.strimzi.api.kafka.model.connect.build.OtherArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.JarArtifact){addToJarArtifactArtifacts(index, (io.strimzi.api.kafka.model.connect.build.JarArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.TgzArtifact){addToTgzArtifactArtifacts(index, (io.strimzi.api.kafka.model.connect.build.TgzArtifact)item);}
        
        return (A)this;
    }

    public A setToArtifacts(int index,io.strimzi.api.kafka.model.connect.build.Artifact item) {
        if (item instanceof io.strimzi.api.kafka.model.connect.build.MavenArtifact){setToMavenArtifactArtifacts(index, (io.strimzi.api.kafka.model.connect.build.MavenArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.ZipArtifact){setToZipArtifactArtifacts(index, (io.strimzi.api.kafka.model.connect.build.ZipArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.OtherArtifact){setToOtherArtifactArtifacts(index, (io.strimzi.api.kafka.model.connect.build.OtherArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.JarArtifact){setToJarArtifactArtifacts(index, (io.strimzi.api.kafka.model.connect.build.JarArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.TgzArtifact){setToTgzArtifactArtifacts(index, (io.strimzi.api.kafka.model.connect.build.TgzArtifact)item);}
        
        return (A)this;
    }

    public A addToArtifacts(io.strimzi.api.kafka.model.connect.build.Artifact... items) {
         if (items != null && items.length > 0 && this.artifacts== null) {this.artifacts = new ArrayList<VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        for (io.strimzi.api.kafka.model.connect.build.Artifact item : items) { 
        if (item instanceof io.strimzi.api.kafka.model.connect.build.MavenArtifact){addToMavenArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.MavenArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.ZipArtifact){addToZipArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.ZipArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.OtherArtifact){addToOtherArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.OtherArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.JarArtifact){addToJarArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.JarArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.TgzArtifact){addToTgzArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.TgzArtifact)item);}
        
        else {  VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder = builderOf(item); _visitables.get("artifacts").add(builder);this.artifacts.add(builder); }
        } return (A)this;
    }

    public A addAllToArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.Artifact> items) {
         if (items != null && items.size() > 0 && this.artifacts== null) {this.artifacts = new ArrayList<VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        for (io.strimzi.api.kafka.model.connect.build.Artifact item : items) { 
        if (item instanceof io.strimzi.api.kafka.model.connect.build.MavenArtifact){addToMavenArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.MavenArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.ZipArtifact){addToZipArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.ZipArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.OtherArtifact){addToOtherArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.OtherArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.JarArtifact){addToJarArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.JarArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.TgzArtifact){addToTgzArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.TgzArtifact)item);}
        
        else {  VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder = builderOf(item); _visitables.get("artifacts").add(builder);this.artifacts.add(builder); }
        } return (A)this;
    }

    public A removeFromArtifacts(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        _visitables.get("artifacts").remove(builder);this.artifacts.remove(builder); return (A)this;
    }

    public A removeFromArtifacts(io.strimzi.api.kafka.model.connect.build.Artifact... items) {
        for (io.strimzi.api.kafka.model.connect.build.Artifact item : items) {if (item instanceof io.strimzi.api.kafka.model.connect.build.MavenArtifact){removeFromMavenArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.MavenArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.ZipArtifact){removeFromZipArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.ZipArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.OtherArtifact){removeFromOtherArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.OtherArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.JarArtifact){removeFromJarArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.JarArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.TgzArtifact){removeFromTgzArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.TgzArtifact)item);}
        
        else {  VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder = builderOf(item); _visitables.get("artifacts").remove(builder);this.artifacts.remove(builder); }
        } return (A)this;
    }

    public A removeAllFromArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.Artifact> items) {
        for (io.strimzi.api.kafka.model.connect.build.Artifact item : items) {if (item instanceof io.strimzi.api.kafka.model.connect.build.MavenArtifact){removeFromMavenArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.MavenArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.ZipArtifact){removeFromZipArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.ZipArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.OtherArtifact){removeFromOtherArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.OtherArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.JarArtifact){removeFromJarArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.JarArtifact)item);}
         else if (item instanceof io.strimzi.api.kafka.model.connect.build.TgzArtifact){removeFromTgzArtifactArtifacts((io.strimzi.api.kafka.model.connect.build.TgzArtifact)item);}
        
        else {  VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder = builderOf(item); _visitables.get("artifacts").remove(builder);this.artifacts.remove(builder); }
        } return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildArtifacts instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.connect.build.Artifact> getArtifacts() {
        return build(artifacts);
    }

    public java.util.List<io.strimzi.api.kafka.model.connect.build.Artifact> buildArtifacts() {
        return build(artifacts);
    }

    public io.strimzi.api.kafka.model.connect.build.Artifact buildArtifact(int index) {
        return this.artifacts.get(index).build();
    }

    public io.strimzi.api.kafka.model.connect.build.Artifact buildFirstArtifact() {
        return this.artifacts.get(0).build();
    }

    public io.strimzi.api.kafka.model.connect.build.Artifact buildLastArtifact() {
        return this.artifacts.get(artifacts.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.connect.build.Artifact buildMatchingArtifact(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> predicate) {
        for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> item: artifacts) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingArtifact(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> predicate) {
        for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> item: artifacts) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withArtifacts(java.util.List<io.strimzi.api.kafka.model.connect.build.Artifact> artifacts) {
        if (this.artifacts != null) { _visitables.get("artifacts").removeAll(this.artifacts);}
        if (artifacts != null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>(); for (io.strimzi.api.kafka.model.connect.build.Artifact item : artifacts){this.addToArtifacts(item);}} else { this.artifacts = null;} return (A) this;
    }

    public A withArtifacts(io.strimzi.api.kafka.model.connect.build.Artifact... artifacts) {
        if (this.artifacts != null) {this.artifacts.clear();}
        if (artifacts != null) {for (io.strimzi.api.kafka.model.connect.build.Artifact item :artifacts){ this.addToArtifacts(item);}} return (A) this;
    }

    public java.lang.Boolean hasArtifacts() {
        return artifacts != null && !artifacts.isEmpty();
    }

    public A addToMavenArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.MavenArtifact item) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder(item);_visitables.get("artifacts").add(index >= 0 ? index : _visitables.get("artifacts").size(), builder);this.artifacts.add(index >= 0 ? index : artifacts.size(), builder); return (A)this;
    }

    public A setToMavenArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.MavenArtifact item) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder(item);
        if (index < 0 || index >= _visitables.get("artifacts").size()) { _visitables.get("artifacts").add(builder); } else { _visitables.get("artifacts").set(index, builder);}
        if (index < 0 || index >= artifacts.size()) { artifacts.add(builder); } else { artifacts.set(index, builder);}
         return (A)this;
    }

    public A addToMavenArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.MavenArtifact... items) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        for (io.strimzi.api.kafka.model.connect.build.MavenArtifact item : items) {io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A addAllToMavenArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.MavenArtifact> items) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        for (io.strimzi.api.kafka.model.connect.build.MavenArtifact item : items) {io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A removeFromMavenArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.MavenArtifact... items) {
        for (io.strimzi.api.kafka.model.connect.build.MavenArtifact item : items) {io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeAllFromMavenArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.MavenArtifact> items) {
        for (io.strimzi.api.kafka.model.connect.build.MavenArtifact item : items) {io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromMavenArtifactArtifacts(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> predicate) {
        if (artifacts == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> each = artifacts.iterator();
        final List visitables = _visitables.get("artifacts");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.MavenArtifactArtifactsNested<A> addNewMavenArtifactArtifact() {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.MavenArtifactArtifactsNestedImpl();
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.MavenArtifactArtifactsNested<A> addNewMavenArtifactArtifactLike(io.strimzi.api.kafka.model.connect.build.MavenArtifact item) {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.MavenArtifactArtifactsNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.MavenArtifactArtifactsNested<A> setNewMavenArtifactArtifactLike(int index,io.strimzi.api.kafka.model.connect.build.MavenArtifact item) {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.MavenArtifactArtifactsNestedImpl(index, item);
    }

    public A addToZipArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.ZipArtifact item) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder(item);_visitables.get("artifacts").add(index >= 0 ? index : _visitables.get("artifacts").size(), builder);this.artifacts.add(index >= 0 ? index : artifacts.size(), builder); return (A)this;
    }

    public A setToZipArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.ZipArtifact item) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder(item);
        if (index < 0 || index >= _visitables.get("artifacts").size()) { _visitables.get("artifacts").add(builder); } else { _visitables.get("artifacts").set(index, builder);}
        if (index < 0 || index >= artifacts.size()) { artifacts.add(builder); } else { artifacts.set(index, builder);}
         return (A)this;
    }

    public A addToZipArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.ZipArtifact... items) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        for (io.strimzi.api.kafka.model.connect.build.ZipArtifact item : items) {io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A addAllToZipArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.ZipArtifact> items) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        for (io.strimzi.api.kafka.model.connect.build.ZipArtifact item : items) {io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A removeFromZipArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.ZipArtifact... items) {
        for (io.strimzi.api.kafka.model.connect.build.ZipArtifact item : items) {io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeAllFromZipArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.ZipArtifact> items) {
        for (io.strimzi.api.kafka.model.connect.build.ZipArtifact item : items) {io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromZipArtifactArtifacts(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> predicate) {
        if (artifacts == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> each = artifacts.iterator();
        final List visitables = _visitables.get("artifacts");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.ZipArtifactArtifactsNested<A> addNewZipArtifactArtifact() {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.ZipArtifactArtifactsNestedImpl();
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.ZipArtifactArtifactsNested<A> addNewZipArtifactArtifactLike(io.strimzi.api.kafka.model.connect.build.ZipArtifact item) {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.ZipArtifactArtifactsNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.ZipArtifactArtifactsNested<A> setNewZipArtifactArtifactLike(int index,io.strimzi.api.kafka.model.connect.build.ZipArtifact item) {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.ZipArtifactArtifactsNestedImpl(index, item);
    }

    public A addToOtherArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.OtherArtifact item) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder(item);_visitables.get("artifacts").add(index >= 0 ? index : _visitables.get("artifacts").size(), builder);this.artifacts.add(index >= 0 ? index : artifacts.size(), builder); return (A)this;
    }

    public A setToOtherArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.OtherArtifact item) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder(item);
        if (index < 0 || index >= _visitables.get("artifacts").size()) { _visitables.get("artifacts").add(builder); } else { _visitables.get("artifacts").set(index, builder);}
        if (index < 0 || index >= artifacts.size()) { artifacts.add(builder); } else { artifacts.set(index, builder);}
         return (A)this;
    }

    public A addToOtherArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.OtherArtifact... items) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        for (io.strimzi.api.kafka.model.connect.build.OtherArtifact item : items) {io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A addAllToOtherArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.OtherArtifact> items) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        for (io.strimzi.api.kafka.model.connect.build.OtherArtifact item : items) {io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A removeFromOtherArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.OtherArtifact... items) {
        for (io.strimzi.api.kafka.model.connect.build.OtherArtifact item : items) {io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeAllFromOtherArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.OtherArtifact> items) {
        for (io.strimzi.api.kafka.model.connect.build.OtherArtifact item : items) {io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOtherArtifactArtifacts(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> predicate) {
        if (artifacts == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> each = artifacts.iterator();
        final List visitables = _visitables.get("artifacts");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.OtherArtifactArtifactsNested<A> addNewOtherArtifactArtifact() {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.OtherArtifactArtifactsNestedImpl();
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.OtherArtifactArtifactsNested<A> addNewOtherArtifactArtifactLike(io.strimzi.api.kafka.model.connect.build.OtherArtifact item) {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.OtherArtifactArtifactsNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.OtherArtifactArtifactsNested<A> setNewOtherArtifactArtifactLike(int index,io.strimzi.api.kafka.model.connect.build.OtherArtifact item) {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.OtherArtifactArtifactsNestedImpl(index, item);
    }

    public A addToJarArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.JarArtifact item) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder(item);_visitables.get("artifacts").add(index >= 0 ? index : _visitables.get("artifacts").size(), builder);this.artifacts.add(index >= 0 ? index : artifacts.size(), builder); return (A)this;
    }

    public A setToJarArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.JarArtifact item) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder(item);
        if (index < 0 || index >= _visitables.get("artifacts").size()) { _visitables.get("artifacts").add(builder); } else { _visitables.get("artifacts").set(index, builder);}
        if (index < 0 || index >= artifacts.size()) { artifacts.add(builder); } else { artifacts.set(index, builder);}
         return (A)this;
    }

    public A addToJarArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.JarArtifact... items) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        for (io.strimzi.api.kafka.model.connect.build.JarArtifact item : items) {io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A addAllToJarArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.JarArtifact> items) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        for (io.strimzi.api.kafka.model.connect.build.JarArtifact item : items) {io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A removeFromJarArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.JarArtifact... items) {
        for (io.strimzi.api.kafka.model.connect.build.JarArtifact item : items) {io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeAllFromJarArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.JarArtifact> items) {
        for (io.strimzi.api.kafka.model.connect.build.JarArtifact item : items) {io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromJarArtifactArtifacts(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> predicate) {
        if (artifacts == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> each = artifacts.iterator();
        final List visitables = _visitables.get("artifacts");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.JarArtifactArtifactsNested<A> addNewJarArtifactArtifact() {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.JarArtifactArtifactsNestedImpl();
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.JarArtifactArtifactsNested<A> addNewJarArtifactArtifactLike(io.strimzi.api.kafka.model.connect.build.JarArtifact item) {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.JarArtifactArtifactsNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.JarArtifactArtifactsNested<A> setNewJarArtifactArtifactLike(int index,io.strimzi.api.kafka.model.connect.build.JarArtifact item) {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.JarArtifactArtifactsNestedImpl(index, item);
    }

    public A addToTgzArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.TgzArtifact item) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder(item);_visitables.get("artifacts").add(index >= 0 ? index : _visitables.get("artifacts").size(), builder);this.artifacts.add(index >= 0 ? index : artifacts.size(), builder); return (A)this;
    }

    public A setToTgzArtifactArtifacts(int index,io.strimzi.api.kafka.model.connect.build.TgzArtifact item) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder(item);
        if (index < 0 || index >= _visitables.get("artifacts").size()) { _visitables.get("artifacts").add(builder); } else { _visitables.get("artifacts").set(index, builder);}
        if (index < 0 || index >= artifacts.size()) { artifacts.add(builder); } else { artifacts.set(index, builder);}
         return (A)this;
    }

    public A addToTgzArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.TgzArtifact... items) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        for (io.strimzi.api.kafka.model.connect.build.TgzArtifact item : items) {io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A addAllToTgzArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.TgzArtifact> items) {
        if (this.artifacts == null) {this.artifacts = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>>();}
        for (io.strimzi.api.kafka.model.connect.build.TgzArtifact item : items) {io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A removeFromTgzArtifactArtifacts(io.strimzi.api.kafka.model.connect.build.TgzArtifact... items) {
        for (io.strimzi.api.kafka.model.connect.build.TgzArtifact item : items) {io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeAllFromTgzArtifactArtifacts(java.util.Collection<io.strimzi.api.kafka.model.connect.build.TgzArtifact> items) {
        for (io.strimzi.api.kafka.model.connect.build.TgzArtifact item : items) {io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder builder = new io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTgzArtifactArtifacts(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> predicate) {
        if (artifacts == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?>> each = artifacts.iterator();
        final List visitables = _visitables.get("artifacts");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.connect.build.Artifact,?> builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.TgzArtifactArtifactsNested<A> addNewTgzArtifactArtifact() {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.TgzArtifactArtifactsNestedImpl();
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.TgzArtifactArtifactsNested<A> addNewTgzArtifactArtifactLike(io.strimzi.api.kafka.model.connect.build.TgzArtifact item) {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.TgzArtifactArtifactsNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.connect.build.PluginFluent.TgzArtifactArtifactsNested<A> setNewTgzArtifactArtifactLike(int index,io.strimzi.api.kafka.model.connect.build.TgzArtifact item) {
        return new io.strimzi.api.kafka.model.connect.build.PluginFluentImpl.TgzArtifactArtifactsNestedImpl(index, item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PluginFluentImpl that = (PluginFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (artifacts != null ? !artifacts.equals(that.artifacts) :that.artifacts != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  artifacts,  super.hashCode());
    }

      
  /**
   * Maven artifact represents an artifact which is downloaded from Maven repository
   */
  public class MavenArtifactArtifactsNestedImpl<N> extends io.strimzi.api.kafka.model.connect.build.MavenArtifactFluentImpl<io.strimzi.api.kafka.model.connect.build.PluginFluent.MavenArtifactArtifactsNested<N>> implements io.strimzi.api.kafka.model.connect.build.PluginFluent.MavenArtifactArtifactsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder builder;
        private final int index;

            MavenArtifactArtifactsNestedImpl(int index,io.strimzi.api.kafka.model.connect.build.MavenArtifact item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder(this, item);
                        
            }

            MavenArtifactArtifactsNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.connect.build.MavenArtifactBuilder(this);
                        
            }

            public N and() {
                return (N) PluginFluentImpl.this.setToArtifacts(index,builder.build());
            }

            public N endMavenArtifactArtifact() {
                return and();
            }
    }


      
  /**
   * ZIP artifact represents an artifact which is downloaded and unpacked using `unzip`
   */
  public class ZipArtifactArtifactsNestedImpl<N> extends io.strimzi.api.kafka.model.connect.build.ZipArtifactFluentImpl<io.strimzi.api.kafka.model.connect.build.PluginFluent.ZipArtifactArtifactsNested<N>> implements io.strimzi.api.kafka.model.connect.build.PluginFluent.ZipArtifactArtifactsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder builder;
        private final int index;

            ZipArtifactArtifactsNestedImpl(int index,io.strimzi.api.kafka.model.connect.build.ZipArtifact item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder(this, item);
                        
            }

            ZipArtifactArtifactsNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder(this);
                        
            }

            public N and() {
                return (N) PluginFluentImpl.this.setToArtifacts(index,builder.build());
            }

            public N endZipArtifactArtifact() {
                return and();
            }
    }


      
  /**
   * Other artifact represents an artifact of assorted types. Users can specify a name of the file under which it will be
   * stored in the container image.
   */
  public class OtherArtifactArtifactsNestedImpl<N> extends io.strimzi.api.kafka.model.connect.build.OtherArtifactFluentImpl<io.strimzi.api.kafka.model.connect.build.PluginFluent.OtherArtifactArtifactsNested<N>> implements io.strimzi.api.kafka.model.connect.build.PluginFluent.OtherArtifactArtifactsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder builder;
        private final int index;

            OtherArtifactArtifactsNestedImpl(int index,io.strimzi.api.kafka.model.connect.build.OtherArtifact item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder(this, item);
                        
            }

            OtherArtifactArtifactsNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.connect.build.OtherArtifactBuilder(this);
                        
            }

            public N and() {
                return (N) PluginFluentImpl.this.setToArtifacts(index,builder.build());
            }

            public N endOtherArtifactArtifact() {
                return and();
            }
    }


      
  /**
   * JAR artifact represents an artifact which is simply downloaded
   */
  public class JarArtifactArtifactsNestedImpl<N> extends io.strimzi.api.kafka.model.connect.build.JarArtifactFluentImpl<io.strimzi.api.kafka.model.connect.build.PluginFluent.JarArtifactArtifactsNested<N>> implements io.strimzi.api.kafka.model.connect.build.PluginFluent.JarArtifactArtifactsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder builder;
        private final int index;

            JarArtifactArtifactsNestedImpl(int index,io.strimzi.api.kafka.model.connect.build.JarArtifact item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder(this, item);
                        
            }

            JarArtifactArtifactsNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder(this);
                        
            }

            public N and() {
                return (N) PluginFluentImpl.this.setToArtifacts(index,builder.build());
            }

            public N endJarArtifactArtifact() {
                return and();
            }
    }


      
  /**
   * TGZ artifact represents an artifact which is downloaded and unpacked using TAR (with GZIP decompression)
   */
  public class TgzArtifactArtifactsNestedImpl<N> extends io.strimzi.api.kafka.model.connect.build.TgzArtifactFluentImpl<io.strimzi.api.kafka.model.connect.build.PluginFluent.TgzArtifactArtifactsNested<N>> implements io.strimzi.api.kafka.model.connect.build.PluginFluent.TgzArtifactArtifactsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder builder;
        private final int index;

            TgzArtifactArtifactsNestedImpl(int index,io.strimzi.api.kafka.model.connect.build.TgzArtifact item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder(this, item);
                        
            }

            TgzArtifactArtifactsNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder(this);
                        
            }

            public N and() {
                return (N) PluginFluentImpl.this.setToArtifacts(index,builder.build());
            }

            public N endTgzArtifactArtifact() {
                return and();
            }
    }


}
