package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * TGZ artifact represents an artifact which is downloaded and unpacked using TAR (with GZIP decompression)
   */
  public class TgzArtifactBuilder extends io.strimzi.api.kafka.model.connect.build.TgzArtifactFluentImpl<io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.connect.build.TgzArtifact,io.strimzi.api.kafka.model.connect.build.TgzArtifactBuilder> {

    io.strimzi.api.kafka.model.connect.build.TgzArtifactFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public TgzArtifactBuilder() {
        this(true);
    }

    public TgzArtifactBuilder(java.lang.Boolean validationEnabled) {
        this(new TgzArtifact(), validationEnabled);
    }

    public TgzArtifactBuilder(io.strimzi.api.kafka.model.connect.build.TgzArtifactFluent<?> fluent) {
        this(fluent, true);
    }

    public TgzArtifactBuilder(io.strimzi.api.kafka.model.connect.build.TgzArtifactFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new TgzArtifact(), validationEnabled);
    }

    public TgzArtifactBuilder(io.strimzi.api.kafka.model.connect.build.TgzArtifactFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.TgzArtifact instance) {
        this(fluent, instance, true);
    }

    public TgzArtifactBuilder(io.strimzi.api.kafka.model.connect.build.TgzArtifactFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.TgzArtifact instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withUrl(instance.getUrl());
        
        fluent.withSha512sum(instance.getSha512sum());
        
        fluent.withInsecure(instance.getInsecure());
        
        this.validationEnabled = validationEnabled; 
    }

    public TgzArtifactBuilder(io.strimzi.api.kafka.model.connect.build.TgzArtifact instance) {
        this(instance,true);
    }

    public TgzArtifactBuilder(io.strimzi.api.kafka.model.connect.build.TgzArtifact instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withUrl(instance.getUrl());
        
        this.withSha512sum(instance.getSha512sum());
        
        this.withInsecure(instance.getInsecure());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.connect.build.TgzArtifact build() {
        TgzArtifact buildable = new TgzArtifact();
        buildable.setUrl(fluent.getUrl());
        buildable.setSha512sum(fluent.getSha512sum());
        buildable.setInsecure(fluent.getInsecure());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TgzArtifactBuilder that = (TgzArtifactBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
