package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * ZIP artifact represents an artifact which is downloaded and unpacked using `unzip`
   */
  public class ZipArtifactBuilder extends io.strimzi.api.kafka.model.connect.build.ZipArtifactFluentImpl<io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.connect.build.ZipArtifact,io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder> {

    io.strimzi.api.kafka.model.connect.build.ZipArtifactFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ZipArtifactBuilder() {
        this(true);
    }

    public ZipArtifactBuilder(java.lang.Boolean validationEnabled) {
        this(new ZipArtifact(), validationEnabled);
    }

    public ZipArtifactBuilder(io.strimzi.api.kafka.model.connect.build.ZipArtifactFluent<?> fluent) {
        this(fluent, true);
    }

    public ZipArtifactBuilder(io.strimzi.api.kafka.model.connect.build.ZipArtifactFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ZipArtifact(), validationEnabled);
    }

    public ZipArtifactBuilder(io.strimzi.api.kafka.model.connect.build.ZipArtifactFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.ZipArtifact instance) {
        this(fluent, instance, true);
    }

    public ZipArtifactBuilder(io.strimzi.api.kafka.model.connect.build.ZipArtifactFluent<?> fluent,io.strimzi.api.kafka.model.connect.build.ZipArtifact instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withUrl(instance.getUrl());
        
        fluent.withSha512sum(instance.getSha512sum());
        
        fluent.withInsecure(instance.getInsecure());
        
        this.validationEnabled = validationEnabled; 
    }

    public ZipArtifactBuilder(io.strimzi.api.kafka.model.connect.build.ZipArtifact instance) {
        this(instance,true);
    }

    public ZipArtifactBuilder(io.strimzi.api.kafka.model.connect.build.ZipArtifact instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withUrl(instance.getUrl());
        
        this.withSha512sum(instance.getSha512sum());
        
        this.withInsecure(instance.getInsecure());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.connect.build.ZipArtifact build() {
        ZipArtifact buildable = new ZipArtifact();
        buildable.setUrl(fluent.getUrl());
        buildable.setSha512sum(fluent.getSha512sum());
        buildable.setInsecure(fluent.getInsecure());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ZipArtifactBuilder that = (ZipArtifactBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
