package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures a listener to use custom authentication.
   */
  public class KafkaListenerAuthenticationCustomBuilder extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluentImpl<io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom,io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomBuilder> {

    io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaListenerAuthenticationCustomBuilder() {
        this(true);
    }

    public KafkaListenerAuthenticationCustomBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaListenerAuthenticationCustom(), validationEnabled);
    }

    public KafkaListenerAuthenticationCustomBuilder(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaListenerAuthenticationCustomBuilder(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaListenerAuthenticationCustom(), validationEnabled);
    }

    public KafkaListenerAuthenticationCustomBuilder(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent<?> fluent,io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom instance) {
        this(fluent, instance, true);
    }

    public KafkaListenerAuthenticationCustomBuilder(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent<?> fluent,io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withListenerConfig(instance.getListenerConfig());
        
        fluent.withSasl(instance.isSasl());
        
        fluent.withSecrets(instance.getSecrets());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaListenerAuthenticationCustomBuilder(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom instance) {
        this(instance,true);
    }

    public KafkaListenerAuthenticationCustomBuilder(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withListenerConfig(instance.getListenerConfig());
        
        this.withSasl(instance.isSasl());
        
        this.withSecrets(instance.getSecrets());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom build() {
        KafkaListenerAuthenticationCustom buildable = new KafkaListenerAuthenticationCustom();
        buildable.setListenerConfig(fluent.getListenerConfig());
        buildable.setSasl(fluent.isSasl());
        buildable.setSecrets(fluent.getSecrets());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaListenerAuthenticationCustomBuilder that = (KafkaListenerAuthenticationCustomBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
