package io.strimzi.api.kafka.model.listener;

import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.strimzi.api.kafka.model.GenericSecretSourceFluent;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

  
  /**
   * Configures a listener to use custom authentication.
   */
  public interface KafkaListenerAuthenticationCustomFluent<A extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent<A>> extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationFluent<A> {


    public A addToListenerConfig(java.lang.String key,java.lang.Object value);
    public A addToListenerConfig(java.util.Map<java.lang.String,java.lang.Object> map);
    public A removeFromListenerConfig(java.lang.String key);
    public A removeFromListenerConfig(java.util.Map<java.lang.String,java.lang.Object> map);
    public java.util.Map<java.lang.String,java.lang.Object> getListenerConfig();
    public <K,V>A withListenerConfig(java.util.Map<java.lang.String,java.lang.Object> listenerConfig);
    public java.lang.Boolean hasListenerConfig();
    public boolean isSasl();
    public A withSasl(boolean sasl);
    public java.lang.Boolean hasSasl();
    public A addToSecrets(int index,io.strimzi.api.kafka.model.GenericSecretSource item);
    public A setToSecrets(int index,io.strimzi.api.kafka.model.GenericSecretSource item);
    public A addToSecrets(io.strimzi.api.kafka.model.GenericSecretSource... items);
    public A addAllToSecrets(java.util.Collection<io.strimzi.api.kafka.model.GenericSecretSource> items);
    public A removeFromSecrets(io.strimzi.api.kafka.model.GenericSecretSource... items);
    public A removeAllFromSecrets(java.util.Collection<io.strimzi.api.kafka.model.GenericSecretSource> items);
    public A removeMatchingFromSecrets(java.util.function.Predicate<io.strimzi.api.kafka.model.GenericSecretSourceBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSecrets instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.GenericSecretSource> getSecrets();
    public java.util.List<io.strimzi.api.kafka.model.GenericSecretSource> buildSecrets();
    public io.strimzi.api.kafka.model.GenericSecretSource buildSecret(int index);
    public io.strimzi.api.kafka.model.GenericSecretSource buildFirstSecret();
    public io.strimzi.api.kafka.model.GenericSecretSource buildLastSecret();
    public io.strimzi.api.kafka.model.GenericSecretSource buildMatchingSecret(java.util.function.Predicate<io.strimzi.api.kafka.model.GenericSecretSourceBuilder> predicate);
    public java.lang.Boolean hasMatchingSecret(java.util.function.Predicate<io.strimzi.api.kafka.model.GenericSecretSourceBuilder> predicate);
    public A withSecrets(java.util.List<io.strimzi.api.kafka.model.GenericSecretSource> secrets);
    public A withSecrets(io.strimzi.api.kafka.model.GenericSecretSource... secrets);
    public java.lang.Boolean hasSecrets();
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<A> addNewSecret();
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<A> addNewSecretLike(io.strimzi.api.kafka.model.GenericSecretSource item);
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<A> setNewSecretLike(int index,io.strimzi.api.kafka.model.GenericSecretSource item);
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<A> editSecret(int index);
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<A> editFirstSecret();
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<A> editLastSecret();
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<A> editMatchingSecret(java.util.function.Predicate<io.strimzi.api.kafka.model.GenericSecretSourceBuilder> predicate);
      
  /**
   * Represents a generic secret inside a Kubernetes Secret
   */
  public interface SecretsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.GenericSecretSourceFluent<io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<N>> {

            public N and();
            public N endSecret();    }


}
