package io.strimzi.api.kafka.model.listener;

import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

  
  /**
   * Configures a listener to use custom authentication.
   */
  public class KafkaListenerAuthenticationCustomFluentImpl<A extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent<A>> extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationFluentImpl<A> implements io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent<A> {

    private java.util.Map<java.lang.String,java.lang.Object> listenerConfig;
    private boolean sasl;
    private java.util.List<io.strimzi.api.kafka.model.GenericSecretSourceBuilder> secrets;

    public KafkaListenerAuthenticationCustomFluentImpl() {
    }

    public KafkaListenerAuthenticationCustomFluentImpl(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom instance) {
        this.withListenerConfig(instance.getListenerConfig());
        
        this.withSasl(instance.isSasl());
        
        this.withSecrets(instance.getSecrets());
    }

    public A addToListenerConfig(java.lang.String key,java.lang.Object value) {
        if(this.listenerConfig == null && key != null && value != null) { this.listenerConfig = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(key != null && value != null) {this.listenerConfig.put(key, value);} return (A)this;
    }

    public A addToListenerConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.listenerConfig == null && map != null) { this.listenerConfig = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(map != null) { this.listenerConfig.putAll(map);} return (A)this;
    }

    public A removeFromListenerConfig(java.lang.String key) {
        if(this.listenerConfig == null) { return (A) this; }
        if(key != null && this.listenerConfig != null) {this.listenerConfig.remove(key);} return (A)this;
    }

    public A removeFromListenerConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.listenerConfig == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.listenerConfig != null){this.listenerConfig.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.Object> getListenerConfig() {
        return this.listenerConfig;
    }

    public <K,V>A withListenerConfig(java.util.Map<java.lang.String,java.lang.Object> listenerConfig) {
        if (listenerConfig == null) { this.listenerConfig =  null;} else {this.listenerConfig = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(listenerConfig);} return (A) this;
    }

    public java.lang.Boolean hasListenerConfig() {
        return this.listenerConfig != null;
    }

    public boolean isSasl() {
        return this.sasl;
    }

    public A withSasl(boolean sasl) {
        this.sasl=sasl; return (A) this;
    }

    public java.lang.Boolean hasSasl() {
        return true;
    }

    public A addToSecrets(int index,io.strimzi.api.kafka.model.GenericSecretSource item) {
        if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.strimzi.api.kafka.model.GenericSecretSourceBuilder>();}
        io.strimzi.api.kafka.model.GenericSecretSourceBuilder builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(item);_visitables.get("secrets").add(index >= 0 ? index : _visitables.get("secrets").size(), builder);this.secrets.add(index >= 0 ? index : secrets.size(), builder); return (A)this;
    }

    public A setToSecrets(int index,io.strimzi.api.kafka.model.GenericSecretSource item) {
        if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.strimzi.api.kafka.model.GenericSecretSourceBuilder>();}
        io.strimzi.api.kafka.model.GenericSecretSourceBuilder builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(item);
        if (index < 0 || index >= _visitables.get("secrets").size()) { _visitables.get("secrets").add(builder); } else { _visitables.get("secrets").set(index, builder);}
        if (index < 0 || index >= secrets.size()) { secrets.add(builder); } else { secrets.set(index, builder);}
         return (A)this;
    }

    public A addToSecrets(io.strimzi.api.kafka.model.GenericSecretSource... items) {
        if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.strimzi.api.kafka.model.GenericSecretSourceBuilder>();}
        for (io.strimzi.api.kafka.model.GenericSecretSource item : items) {io.strimzi.api.kafka.model.GenericSecretSourceBuilder builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
    }

    public A addAllToSecrets(java.util.Collection<io.strimzi.api.kafka.model.GenericSecretSource> items) {
        if (this.secrets == null) {this.secrets = new java.util.ArrayList<io.strimzi.api.kafka.model.GenericSecretSourceBuilder>();}
        for (io.strimzi.api.kafka.model.GenericSecretSource item : items) {io.strimzi.api.kafka.model.GenericSecretSourceBuilder builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(item);_visitables.get("secrets").add(builder);this.secrets.add(builder);} return (A)this;
    }

    public A removeFromSecrets(io.strimzi.api.kafka.model.GenericSecretSource... items) {
        for (io.strimzi.api.kafka.model.GenericSecretSource item : items) {io.strimzi.api.kafka.model.GenericSecretSourceBuilder builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(item);_visitables.get("secrets").remove(builder);if (this.secrets != null) {this.secrets.remove(builder);}} return (A)this;
    }

    public A removeAllFromSecrets(java.util.Collection<io.strimzi.api.kafka.model.GenericSecretSource> items) {
        for (io.strimzi.api.kafka.model.GenericSecretSource item : items) {io.strimzi.api.kafka.model.GenericSecretSourceBuilder builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(item);_visitables.get("secrets").remove(builder);if (this.secrets != null) {this.secrets.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSecrets(java.util.function.Predicate<io.strimzi.api.kafka.model.GenericSecretSourceBuilder> predicate) {
        if (secrets == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.GenericSecretSourceBuilder> each = secrets.iterator();
        final List visitables = _visitables.get("secrets");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.GenericSecretSourceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSecrets instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.GenericSecretSource> getSecrets() {
        return build(secrets);
    }

    public java.util.List<io.strimzi.api.kafka.model.GenericSecretSource> buildSecrets() {
        return build(secrets);
    }

    public io.strimzi.api.kafka.model.GenericSecretSource buildSecret(int index) {
        return this.secrets.get(index).build();
    }

    public io.strimzi.api.kafka.model.GenericSecretSource buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    public io.strimzi.api.kafka.model.GenericSecretSource buildLastSecret() {
        return this.secrets.get(secrets.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.GenericSecretSource buildMatchingSecret(java.util.function.Predicate<io.strimzi.api.kafka.model.GenericSecretSourceBuilder> predicate) {
        for (io.strimzi.api.kafka.model.GenericSecretSourceBuilder item: secrets) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingSecret(java.util.function.Predicate<io.strimzi.api.kafka.model.GenericSecretSourceBuilder> predicate) {
        for (io.strimzi.api.kafka.model.GenericSecretSourceBuilder item: secrets) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSecrets(java.util.List<io.strimzi.api.kafka.model.GenericSecretSource> secrets) {
        if (this.secrets != null) { _visitables.get("secrets").removeAll(this.secrets);}
        if (secrets != null) {this.secrets = new java.util.ArrayList<io.strimzi.api.kafka.model.GenericSecretSourceBuilder>(); for (io.strimzi.api.kafka.model.GenericSecretSource item : secrets){this.addToSecrets(item);}} else { this.secrets = null;} return (A) this;
    }

    public A withSecrets(io.strimzi.api.kafka.model.GenericSecretSource... secrets) {
        if (this.secrets != null) {this.secrets.clear();}
        if (secrets != null) {for (io.strimzi.api.kafka.model.GenericSecretSource item :secrets){ this.addToSecrets(item);}} return (A) this;
    }

    public java.lang.Boolean hasSecrets() {
        return secrets != null && !secrets.isEmpty();
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<A> addNewSecret() {
        return new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluentImpl.SecretsNestedImpl();
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<A> addNewSecretLike(io.strimzi.api.kafka.model.GenericSecretSource item) {
        return new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluentImpl.SecretsNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<A> setNewSecretLike(int index,io.strimzi.api.kafka.model.GenericSecretSource item) {
        return new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluentImpl.SecretsNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<A> editSecret(int index) {
        if (secrets.size() <= index) throw new RuntimeException("Can't edit secrets. Index exceeds size.");
        return setNewSecretLike(index, buildSecret(index));
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<A> editFirstSecret() {
        if (secrets.size() == 0) throw new RuntimeException("Can't edit first secrets. The list is empty.");
        return setNewSecretLike(0, buildSecret(0));
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<A> editLastSecret() {
        int index = secrets.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last secrets. The list is empty.");
        return setNewSecretLike(index, buildSecret(index));
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<A> editMatchingSecret(java.util.function.Predicate<io.strimzi.api.kafka.model.GenericSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<secrets.size();i++) { 
        if (predicate.test(secrets.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching secrets. No match found.");
        return setNewSecretLike(index, buildSecret(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaListenerAuthenticationCustomFluentImpl that = (KafkaListenerAuthenticationCustomFluentImpl) o;
        if (listenerConfig != null ? !listenerConfig.equals(that.listenerConfig) :that.listenerConfig != null) return false;
        if (sasl != that.sasl) return false;
        if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(listenerConfig,  sasl,  secrets,  super.hashCode());
    }

      
  /**
   * Represents a generic secret inside a Kubernetes Secret
   */
  public class SecretsNestedImpl<N> extends io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl<io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<N>> implements io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent.SecretsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.GenericSecretSourceBuilder builder;
        private final int index;

            SecretsNestedImpl(int index,io.strimzi.api.kafka.model.GenericSecretSource item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(this, item);
                        
            }

            SecretsNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaListenerAuthenticationCustomFluentImpl.this.setToSecrets(index,builder.build());
            }

            public N endSecret() {
                return and();
            }
    }


}
