package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures a listener to use OAuth authentication.
   */
  public class KafkaListenerAuthenticationOAuthBuilder extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluentImpl<io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth,io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthBuilder> {

    io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaListenerAuthenticationOAuthBuilder() {
        this(true);
    }

    public KafkaListenerAuthenticationOAuthBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaListenerAuthenticationOAuth(), validationEnabled);
    }

    public KafkaListenerAuthenticationOAuthBuilder(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaListenerAuthenticationOAuthBuilder(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaListenerAuthenticationOAuth(), validationEnabled);
    }

    public KafkaListenerAuthenticationOAuthBuilder(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent<?> fluent,io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth instance) {
        this(fluent, instance, true);
    }

    public KafkaListenerAuthenticationOAuthBuilder(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent<?> fluent,io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withClientId(instance.getClientId());
        
        fluent.withClientSecret(instance.getClientSecret());
        
        fluent.withValidIssuerUri(instance.getValidIssuerUri());
        
        fluent.withCheckIssuer(instance.isCheckIssuer());
        
        fluent.withCheckAudience(instance.isCheckAudience());
        
        fluent.withJwksEndpointUri(instance.getJwksEndpointUri());
        
        fluent.withJwksRefreshSeconds(instance.getJwksRefreshSeconds());
        
        fluent.withJwksMinRefreshPauseSeconds(instance.getJwksMinRefreshPauseSeconds());
        
        fluent.withJwksExpirySeconds(instance.getJwksExpirySeconds());
        
        fluent.withIntrospectionEndpointUri(instance.getIntrospectionEndpointUri());
        
        fluent.withUserNameClaim(instance.getUserNameClaim());
        
        fluent.withFallbackUserNameClaim(instance.getFallbackUserNameClaim());
        
        fluent.withFallbackUserNamePrefix(instance.getFallbackUserNamePrefix());
        
        fluent.withGroupsClaim(instance.getGroupsClaim());
        
        fluent.withGroupsClaimDelimiter(instance.getGroupsClaimDelimiter());
        
        fluent.withUserInfoEndpointUri(instance.getUserInfoEndpointUri());
        
        fluent.withCheckAccessTokenType(instance.isCheckAccessTokenType());
        
        fluent.withValidTokenType(instance.getValidTokenType());
        
        fluent.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
        
        fluent.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        
        fluent.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        
        fluent.withEnableECDSA(instance.getEnableECDSA());
        
        fluent.withMaxSecondsWithoutReauthentication(instance.getMaxSecondsWithoutReauthentication());
        
        fluent.withEnablePlain(instance.isEnablePlain());
        
        fluent.withTokenEndpointUri(instance.getTokenEndpointUri());
        
        fluent.withEnableOauthBearer(instance.isEnableOauthBearer());
        
        fluent.withCustomClaimCheck(instance.getCustomClaimCheck());
        
        fluent.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
        
        fluent.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
        
        fluent.withClientScope(instance.getClientScope());
        
        fluent.withClientAudience(instance.getClientAudience());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaListenerAuthenticationOAuthBuilder(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth instance) {
        this(instance,true);
    }

    public KafkaListenerAuthenticationOAuthBuilder(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withClientId(instance.getClientId());
        
        this.withClientSecret(instance.getClientSecret());
        
        this.withValidIssuerUri(instance.getValidIssuerUri());
        
        this.withCheckIssuer(instance.isCheckIssuer());
        
        this.withCheckAudience(instance.isCheckAudience());
        
        this.withJwksEndpointUri(instance.getJwksEndpointUri());
        
        this.withJwksRefreshSeconds(instance.getJwksRefreshSeconds());
        
        this.withJwksMinRefreshPauseSeconds(instance.getJwksMinRefreshPauseSeconds());
        
        this.withJwksExpirySeconds(instance.getJwksExpirySeconds());
        
        this.withIntrospectionEndpointUri(instance.getIntrospectionEndpointUri());
        
        this.withUserNameClaim(instance.getUserNameClaim());
        
        this.withFallbackUserNameClaim(instance.getFallbackUserNameClaim());
        
        this.withFallbackUserNamePrefix(instance.getFallbackUserNamePrefix());
        
        this.withGroupsClaim(instance.getGroupsClaim());
        
        this.withGroupsClaimDelimiter(instance.getGroupsClaimDelimiter());
        
        this.withUserInfoEndpointUri(instance.getUserInfoEndpointUri());
        
        this.withCheckAccessTokenType(instance.isCheckAccessTokenType());
        
        this.withValidTokenType(instance.getValidTokenType());
        
        this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
        
        this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        
        this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        
        this.withEnableECDSA(instance.getEnableECDSA());
        
        this.withMaxSecondsWithoutReauthentication(instance.getMaxSecondsWithoutReauthentication());
        
        this.withEnablePlain(instance.isEnablePlain());
        
        this.withTokenEndpointUri(instance.getTokenEndpointUri());
        
        this.withEnableOauthBearer(instance.isEnableOauthBearer());
        
        this.withCustomClaimCheck(instance.getCustomClaimCheck());
        
        this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
        
        this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
        
        this.withClientScope(instance.getClientScope());
        
        this.withClientAudience(instance.getClientAudience());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth build() {
        KafkaListenerAuthenticationOAuth buildable = new KafkaListenerAuthenticationOAuth();
        buildable.setClientId(fluent.getClientId());
        buildable.setClientSecret(fluent.getClientSecret());
        buildable.setValidIssuerUri(fluent.getValidIssuerUri());
        buildable.setCheckIssuer(fluent.isCheckIssuer());
        buildable.setCheckAudience(fluent.isCheckAudience());
        buildable.setJwksEndpointUri(fluent.getJwksEndpointUri());
        buildable.setJwksRefreshSeconds(fluent.getJwksRefreshSeconds());
        buildable.setJwksMinRefreshPauseSeconds(fluent.getJwksMinRefreshPauseSeconds());
        buildable.setJwksExpirySeconds(fluent.getJwksExpirySeconds());
        buildable.setIntrospectionEndpointUri(fluent.getIntrospectionEndpointUri());
        buildable.setUserNameClaim(fluent.getUserNameClaim());
        buildable.setFallbackUserNameClaim(fluent.getFallbackUserNameClaim());
        buildable.setFallbackUserNamePrefix(fluent.getFallbackUserNamePrefix());
        buildable.setGroupsClaim(fluent.getGroupsClaim());
        buildable.setGroupsClaimDelimiter(fluent.getGroupsClaimDelimiter());
        buildable.setUserInfoEndpointUri(fluent.getUserInfoEndpointUri());
        buildable.setCheckAccessTokenType(fluent.isCheckAccessTokenType());
        buildable.setValidTokenType(fluent.getValidTokenType());
        buildable.setAccessTokenIsJwt(fluent.isAccessTokenIsJwt());
        buildable.setTlsTrustedCertificates(fluent.getTlsTrustedCertificates());
        buildable.setDisableTlsHostnameVerification(fluent.isDisableTlsHostnameVerification());
        buildable.setEnableECDSA(fluent.getEnableECDSA());
        buildable.setMaxSecondsWithoutReauthentication(fluent.getMaxSecondsWithoutReauthentication());
        buildable.setEnablePlain(fluent.isEnablePlain());
        buildable.setTokenEndpointUri(fluent.getTokenEndpointUri());
        buildable.setEnableOauthBearer(fluent.isEnableOauthBearer());
        buildable.setCustomClaimCheck(fluent.getCustomClaimCheck());
        buildable.setConnectTimeoutSeconds(fluent.getConnectTimeoutSeconds());
        buildable.setReadTimeoutSeconds(fluent.getReadTimeoutSeconds());
        buildable.setClientScope(fluent.getClientScope());
        buildable.setClientAudience(fluent.getClientAudience());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaListenerAuthenticationOAuthBuilder that = (KafkaListenerAuthenticationOAuthBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
