package io.strimzi.api.kafka.model.listener;

import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.strimzi.api.kafka.model.GenericSecretSourceFluent;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.CertSecretSource;

  
  /**
   * Configures a listener to use OAuth authentication.
   */
  public interface KafkaListenerAuthenticationOAuthFluent<A extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent<A>> extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationFluent<A> {


    public java.lang.String getClientId();
    public A withClientId(java.lang.String clientId);
    public java.lang.Boolean hasClientId();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientId instead.
     */
        public A withNewClientId(java.lang.String original);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClientSecret instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.GenericSecretSource getClientSecret();
    public io.strimzi.api.kafka.model.GenericSecretSource buildClientSecret();
    public A withClientSecret(io.strimzi.api.kafka.model.GenericSecretSource clientSecret);
    public java.lang.Boolean hasClientSecret();
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecret();
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecretLike(io.strimzi.api.kafka.model.GenericSecretSource item);
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editClientSecret();
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecret();
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecretLike(io.strimzi.api.kafka.model.GenericSecretSource item);
    public java.lang.String getValidIssuerUri();
    public A withValidIssuerUri(java.lang.String validIssuerUri);
    public java.lang.Boolean hasValidIssuerUri();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withValidIssuerUri instead.
     */
        public A withNewValidIssuerUri(java.lang.String original);
    public boolean isCheckIssuer();
    public A withCheckIssuer(boolean checkIssuer);
    public java.lang.Boolean hasCheckIssuer();
    public boolean isCheckAudience();
    public A withCheckAudience(boolean checkAudience);
    public java.lang.Boolean hasCheckAudience();
    public java.lang.String getJwksEndpointUri();
    public A withJwksEndpointUri(java.lang.String jwksEndpointUri);
    public java.lang.Boolean hasJwksEndpointUri();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withJwksEndpointUri instead.
     */
        public A withNewJwksEndpointUri(java.lang.String original);
    public java.lang.Integer getJwksRefreshSeconds();
    public A withJwksRefreshSeconds(java.lang.Integer jwksRefreshSeconds);
    public java.lang.Boolean hasJwksRefreshSeconds();
    public java.lang.Integer getJwksMinRefreshPauseSeconds();
    public A withJwksMinRefreshPauseSeconds(java.lang.Integer jwksMinRefreshPauseSeconds);
    public java.lang.Boolean hasJwksMinRefreshPauseSeconds();
    public java.lang.Integer getJwksExpirySeconds();
    public A withJwksExpirySeconds(java.lang.Integer jwksExpirySeconds);
    public java.lang.Boolean hasJwksExpirySeconds();
    public java.lang.String getIntrospectionEndpointUri();
    public A withIntrospectionEndpointUri(java.lang.String introspectionEndpointUri);
    public java.lang.Boolean hasIntrospectionEndpointUri();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withIntrospectionEndpointUri instead.
     */
        public A withNewIntrospectionEndpointUri(java.lang.String original);
    public java.lang.String getUserNameClaim();
    public A withUserNameClaim(java.lang.String userNameClaim);
    public java.lang.Boolean hasUserNameClaim();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUserNameClaim instead.
     */
        public A withNewUserNameClaim(java.lang.String original);
    public java.lang.String getFallbackUserNameClaim();
    public A withFallbackUserNameClaim(java.lang.String fallbackUserNameClaim);
    public java.lang.Boolean hasFallbackUserNameClaim();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withFallbackUserNameClaim instead.
     */
        public A withNewFallbackUserNameClaim(java.lang.String original);
    public java.lang.String getFallbackUserNamePrefix();
    public A withFallbackUserNamePrefix(java.lang.String fallbackUserNamePrefix);
    public java.lang.Boolean hasFallbackUserNamePrefix();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withFallbackUserNamePrefix instead.
     */
        public A withNewFallbackUserNamePrefix(java.lang.String original);
    public java.lang.String getGroupsClaim();
    public A withGroupsClaim(java.lang.String groupsClaim);
    public java.lang.Boolean hasGroupsClaim();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withGroupsClaim instead.
     */
        public A withNewGroupsClaim(java.lang.String original);
    public java.lang.String getGroupsClaimDelimiter();
    public A withGroupsClaimDelimiter(java.lang.String groupsClaimDelimiter);
    public java.lang.Boolean hasGroupsClaimDelimiter();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withGroupsClaimDelimiter instead.
     */
        public A withNewGroupsClaimDelimiter(java.lang.String original);
    public java.lang.String getUserInfoEndpointUri();
    public A withUserInfoEndpointUri(java.lang.String userInfoEndpointUri);
    public java.lang.Boolean hasUserInfoEndpointUri();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUserInfoEndpointUri instead.
     */
        public A withNewUserInfoEndpointUri(java.lang.String original);
    public boolean isCheckAccessTokenType();
    public A withCheckAccessTokenType(boolean checkAccessTokenType);
    public java.lang.Boolean hasCheckAccessTokenType();
    public java.lang.String getValidTokenType();
    public A withValidTokenType(java.lang.String validTokenType);
    public java.lang.Boolean hasValidTokenType();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withValidTokenType instead.
     */
        public A withNewValidTokenType(java.lang.String original);
    public boolean isAccessTokenIsJwt();
    public A withAccessTokenIsJwt(boolean accessTokenIsJwt);
    public java.lang.Boolean hasAccessTokenIsJwt();
    public A addToTlsTrustedCertificates(int index,io.strimzi.api.kafka.model.CertSecretSource item);
    public A setToTlsTrustedCertificates(int index,io.strimzi.api.kafka.model.CertSecretSource item);
    public A addToTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items);
    public A addAllToTlsTrustedCertificates(java.util.Collection<io.strimzi.api.kafka.model.CertSecretSource> items);
    public A removeFromTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items);
    public A removeAllFromTlsTrustedCertificates(java.util.Collection<io.strimzi.api.kafka.model.CertSecretSource> items);
    public A removeMatchingFromTlsTrustedCertificates(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTlsTrustedCertificates instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.CertSecretSource> getTlsTrustedCertificates();
    public java.util.List<io.strimzi.api.kafka.model.CertSecretSource> buildTlsTrustedCertificates();
    public io.strimzi.api.kafka.model.CertSecretSource buildTlsTrustedCertificate(int index);
    public io.strimzi.api.kafka.model.CertSecretSource buildFirstTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.CertSecretSource buildLastTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.CertSecretSource buildMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate);
    public java.lang.Boolean hasMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate);
    public A withTlsTrustedCertificates(java.util.List<io.strimzi.api.kafka.model.CertSecretSource> tlsTrustedCertificates);
    public A withTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... tlsTrustedCertificates);
    public java.lang.Boolean hasTlsTrustedCertificates();
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(io.strimzi.api.kafka.model.CertSecretSource item);
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,io.strimzi.api.kafka.model.CertSecretSource item);
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index);
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate);
    public boolean isDisableTlsHostnameVerification();
    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification);
    public java.lang.Boolean hasDisableTlsHostnameVerification();
    public java.lang.Boolean getEnableECDSA();
    public A withEnableECDSA(java.lang.Boolean enableECDSA);
    public java.lang.Boolean hasEnableECDSA();
    public java.lang.Integer getMaxSecondsWithoutReauthentication();
    public A withMaxSecondsWithoutReauthentication(java.lang.Integer maxSecondsWithoutReauthentication);
    public java.lang.Boolean hasMaxSecondsWithoutReauthentication();
    public boolean isEnablePlain();
    public A withEnablePlain(boolean enablePlain);
    public java.lang.Boolean hasEnablePlain();
    public java.lang.String getTokenEndpointUri();
    public A withTokenEndpointUri(java.lang.String tokenEndpointUri);
    public java.lang.Boolean hasTokenEndpointUri();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTokenEndpointUri instead.
     */
        public A withNewTokenEndpointUri(java.lang.String original);
    public boolean isEnableOauthBearer();
    public A withEnableOauthBearer(boolean enableOauthBearer);
    public java.lang.Boolean hasEnableOauthBearer();
    public java.lang.String getCustomClaimCheck();
    public A withCustomClaimCheck(java.lang.String customClaimCheck);
    public java.lang.Boolean hasCustomClaimCheck();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withCustomClaimCheck instead.
     */
        public A withNewCustomClaimCheck(java.lang.String original);
    public java.lang.Integer getConnectTimeoutSeconds();
    public A withConnectTimeoutSeconds(java.lang.Integer connectTimeoutSeconds);
    public java.lang.Boolean hasConnectTimeoutSeconds();
    public java.lang.Integer getReadTimeoutSeconds();
    public A withReadTimeoutSeconds(java.lang.Integer readTimeoutSeconds);
    public java.lang.Boolean hasReadTimeoutSeconds();
    public java.lang.String getClientScope();
    public A withClientScope(java.lang.String clientScope);
    public java.lang.Boolean hasClientScope();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientScope instead.
     */
        public A withNewClientScope(java.lang.String original);
    public java.lang.String getClientAudience();
    public A withClientAudience(java.lang.String clientAudience);
    public java.lang.Boolean hasClientAudience();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientAudience instead.
     */
        public A withNewClientAudience(java.lang.String original);
      
  /**
   * Represents a generic secret inside a Kubernetes Secret
   */
  public interface ClientSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.GenericSecretSourceFluent<io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<N>> {

            public N and();
            public N endClientSecret();    }


      
  /**
   * Represents a certificate inside a Secret
   */
  public interface TlsTrustedCertificatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.CertSecretSourceFluent<io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>> {

            public N and();
            public N endTlsTrustedCertificate();    }


}
