package io.strimzi.api.kafka.model.listener;

import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.CertSecretSource;

  
  /**
   * Configures a listener to use OAuth authentication.
   */
  public class KafkaListenerAuthenticationOAuthFluentImpl<A extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent<A>> extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationFluentImpl<A> implements io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent<A> {

    private java.lang.String clientId;
    private io.strimzi.api.kafka.model.GenericSecretSourceBuilder clientSecret;
    private java.lang.String validIssuerUri;
    private boolean checkIssuer;
    private boolean checkAudience;
    private java.lang.String jwksEndpointUri;
    private java.lang.Integer jwksRefreshSeconds;
    private java.lang.Integer jwksMinRefreshPauseSeconds;
    private java.lang.Integer jwksExpirySeconds;
    private java.lang.String introspectionEndpointUri;
    private java.lang.String userNameClaim;
    private java.lang.String fallbackUserNameClaim;
    private java.lang.String fallbackUserNamePrefix;
    private java.lang.String groupsClaim;
    private java.lang.String groupsClaimDelimiter;
    private java.lang.String userInfoEndpointUri;
    private boolean checkAccessTokenType;
    private java.lang.String validTokenType;
    private boolean accessTokenIsJwt;
    private java.util.List<io.strimzi.api.kafka.model.CertSecretSourceBuilder> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification;
    private java.lang.Boolean enableECDSA;
    private java.lang.Integer maxSecondsWithoutReauthentication;
    private boolean enablePlain;
    private java.lang.String tokenEndpointUri;
    private boolean enableOauthBearer;
    private java.lang.String customClaimCheck;
    private java.lang.Integer connectTimeoutSeconds;
    private java.lang.Integer readTimeoutSeconds;
    private java.lang.String clientScope;
    private java.lang.String clientAudience;

    public KafkaListenerAuthenticationOAuthFluentImpl() {
    }

    public KafkaListenerAuthenticationOAuthFluentImpl(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth instance) {
        this.withClientId(instance.getClientId());
        
        this.withClientSecret(instance.getClientSecret());
        
        this.withValidIssuerUri(instance.getValidIssuerUri());
        
        this.withCheckIssuer(instance.isCheckIssuer());
        
        this.withCheckAudience(instance.isCheckAudience());
        
        this.withJwksEndpointUri(instance.getJwksEndpointUri());
        
        this.withJwksRefreshSeconds(instance.getJwksRefreshSeconds());
        
        this.withJwksMinRefreshPauseSeconds(instance.getJwksMinRefreshPauseSeconds());
        
        this.withJwksExpirySeconds(instance.getJwksExpirySeconds());
        
        this.withIntrospectionEndpointUri(instance.getIntrospectionEndpointUri());
        
        this.withUserNameClaim(instance.getUserNameClaim());
        
        this.withFallbackUserNameClaim(instance.getFallbackUserNameClaim());
        
        this.withFallbackUserNamePrefix(instance.getFallbackUserNamePrefix());
        
        this.withGroupsClaim(instance.getGroupsClaim());
        
        this.withGroupsClaimDelimiter(instance.getGroupsClaimDelimiter());
        
        this.withUserInfoEndpointUri(instance.getUserInfoEndpointUri());
        
        this.withCheckAccessTokenType(instance.isCheckAccessTokenType());
        
        this.withValidTokenType(instance.getValidTokenType());
        
        this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
        
        this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        
        this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        
        this.withEnableECDSA(instance.getEnableECDSA());
        
        this.withMaxSecondsWithoutReauthentication(instance.getMaxSecondsWithoutReauthentication());
        
        this.withEnablePlain(instance.isEnablePlain());
        
        this.withTokenEndpointUri(instance.getTokenEndpointUri());
        
        this.withEnableOauthBearer(instance.isEnableOauthBearer());
        
        this.withCustomClaimCheck(instance.getCustomClaimCheck());
        
        this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
        
        this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
        
        this.withClientScope(instance.getClientScope());
        
        this.withClientAudience(instance.getClientAudience());
    }

    public java.lang.String getClientId() {
        return this.clientId;
    }

    public A withClientId(java.lang.String clientId) {
        this.clientId=clientId; return (A) this;
    }

    public java.lang.Boolean hasClientId() {
        return this.clientId != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientId instead.
     */
        public A withNewClientId(java.lang.String original) {
        return (A)withClientId(new String(original));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClientSecret instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.GenericSecretSource getClientSecret() {
        return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public io.strimzi.api.kafka.model.GenericSecretSource buildClientSecret() {
        return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public A withClientSecret(io.strimzi.api.kafka.model.GenericSecretSource clientSecret) {
        _visitables.get("clientSecret").remove(this.clientSecret);
        if (clientSecret!=null){ this.clientSecret= new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} return (A) this;
    }

    public java.lang.Boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecret() {
        return new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluentImpl.ClientSecretNestedImpl();
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecretLike(io.strimzi.api.kafka.model.GenericSecretSource item) {
        return new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluentImpl.ClientSecretNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editClientSecret() {
        return withNewClientSecretLike(getClientSecret());
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecret() {
        return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new io.strimzi.api.kafka.model.GenericSecretSourceBuilder().build());
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecretLike(io.strimzi.api.kafka.model.GenericSecretSource item) {
        return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
    }

    public java.lang.String getValidIssuerUri() {
        return this.validIssuerUri;
    }

    public A withValidIssuerUri(java.lang.String validIssuerUri) {
        this.validIssuerUri=validIssuerUri; return (A) this;
    }

    public java.lang.Boolean hasValidIssuerUri() {
        return this.validIssuerUri != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withValidIssuerUri instead.
     */
        public A withNewValidIssuerUri(java.lang.String original) {
        return (A)withValidIssuerUri(new String(original));
    }

    public boolean isCheckIssuer() {
        return this.checkIssuer;
    }

    public A withCheckIssuer(boolean checkIssuer) {
        this.checkIssuer=checkIssuer; return (A) this;
    }

    public java.lang.Boolean hasCheckIssuer() {
        return true;
    }

    public boolean isCheckAudience() {
        return this.checkAudience;
    }

    public A withCheckAudience(boolean checkAudience) {
        this.checkAudience=checkAudience; return (A) this;
    }

    public java.lang.Boolean hasCheckAudience() {
        return true;
    }

    public java.lang.String getJwksEndpointUri() {
        return this.jwksEndpointUri;
    }

    public A withJwksEndpointUri(java.lang.String jwksEndpointUri) {
        this.jwksEndpointUri=jwksEndpointUri; return (A) this;
    }

    public java.lang.Boolean hasJwksEndpointUri() {
        return this.jwksEndpointUri != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withJwksEndpointUri instead.
     */
        public A withNewJwksEndpointUri(java.lang.String original) {
        return (A)withJwksEndpointUri(new String(original));
    }

    public java.lang.Integer getJwksRefreshSeconds() {
        return this.jwksRefreshSeconds;
    }

    public A withJwksRefreshSeconds(java.lang.Integer jwksRefreshSeconds) {
        this.jwksRefreshSeconds=jwksRefreshSeconds; return (A) this;
    }

    public java.lang.Boolean hasJwksRefreshSeconds() {
        return this.jwksRefreshSeconds != null;
    }

    public java.lang.Integer getJwksMinRefreshPauseSeconds() {
        return this.jwksMinRefreshPauseSeconds;
    }

    public A withJwksMinRefreshPauseSeconds(java.lang.Integer jwksMinRefreshPauseSeconds) {
        this.jwksMinRefreshPauseSeconds=jwksMinRefreshPauseSeconds; return (A) this;
    }

    public java.lang.Boolean hasJwksMinRefreshPauseSeconds() {
        return this.jwksMinRefreshPauseSeconds != null;
    }

    public java.lang.Integer getJwksExpirySeconds() {
        return this.jwksExpirySeconds;
    }

    public A withJwksExpirySeconds(java.lang.Integer jwksExpirySeconds) {
        this.jwksExpirySeconds=jwksExpirySeconds; return (A) this;
    }

    public java.lang.Boolean hasJwksExpirySeconds() {
        return this.jwksExpirySeconds != null;
    }

    public java.lang.String getIntrospectionEndpointUri() {
        return this.introspectionEndpointUri;
    }

    public A withIntrospectionEndpointUri(java.lang.String introspectionEndpointUri) {
        this.introspectionEndpointUri=introspectionEndpointUri; return (A) this;
    }

    public java.lang.Boolean hasIntrospectionEndpointUri() {
        return this.introspectionEndpointUri != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withIntrospectionEndpointUri instead.
     */
        public A withNewIntrospectionEndpointUri(java.lang.String original) {
        return (A)withIntrospectionEndpointUri(new String(original));
    }

    public java.lang.String getUserNameClaim() {
        return this.userNameClaim;
    }

    public A withUserNameClaim(java.lang.String userNameClaim) {
        this.userNameClaim=userNameClaim; return (A) this;
    }

    public java.lang.Boolean hasUserNameClaim() {
        return this.userNameClaim != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUserNameClaim instead.
     */
        public A withNewUserNameClaim(java.lang.String original) {
        return (A)withUserNameClaim(new String(original));
    }

    public java.lang.String getFallbackUserNameClaim() {
        return this.fallbackUserNameClaim;
    }

    public A withFallbackUserNameClaim(java.lang.String fallbackUserNameClaim) {
        this.fallbackUserNameClaim=fallbackUserNameClaim; return (A) this;
    }

    public java.lang.Boolean hasFallbackUserNameClaim() {
        return this.fallbackUserNameClaim != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withFallbackUserNameClaim instead.
     */
        public A withNewFallbackUserNameClaim(java.lang.String original) {
        return (A)withFallbackUserNameClaim(new String(original));
    }

    public java.lang.String getFallbackUserNamePrefix() {
        return this.fallbackUserNamePrefix;
    }

    public A withFallbackUserNamePrefix(java.lang.String fallbackUserNamePrefix) {
        this.fallbackUserNamePrefix=fallbackUserNamePrefix; return (A) this;
    }

    public java.lang.Boolean hasFallbackUserNamePrefix() {
        return this.fallbackUserNamePrefix != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withFallbackUserNamePrefix instead.
     */
        public A withNewFallbackUserNamePrefix(java.lang.String original) {
        return (A)withFallbackUserNamePrefix(new String(original));
    }

    public java.lang.String getGroupsClaim() {
        return this.groupsClaim;
    }

    public A withGroupsClaim(java.lang.String groupsClaim) {
        this.groupsClaim=groupsClaim; return (A) this;
    }

    public java.lang.Boolean hasGroupsClaim() {
        return this.groupsClaim != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withGroupsClaim instead.
     */
        public A withNewGroupsClaim(java.lang.String original) {
        return (A)withGroupsClaim(new String(original));
    }

    public java.lang.String getGroupsClaimDelimiter() {
        return this.groupsClaimDelimiter;
    }

    public A withGroupsClaimDelimiter(java.lang.String groupsClaimDelimiter) {
        this.groupsClaimDelimiter=groupsClaimDelimiter; return (A) this;
    }

    public java.lang.Boolean hasGroupsClaimDelimiter() {
        return this.groupsClaimDelimiter != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withGroupsClaimDelimiter instead.
     */
        public A withNewGroupsClaimDelimiter(java.lang.String original) {
        return (A)withGroupsClaimDelimiter(new String(original));
    }

    public java.lang.String getUserInfoEndpointUri() {
        return this.userInfoEndpointUri;
    }

    public A withUserInfoEndpointUri(java.lang.String userInfoEndpointUri) {
        this.userInfoEndpointUri=userInfoEndpointUri; return (A) this;
    }

    public java.lang.Boolean hasUserInfoEndpointUri() {
        return this.userInfoEndpointUri != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUserInfoEndpointUri instead.
     */
        public A withNewUserInfoEndpointUri(java.lang.String original) {
        return (A)withUserInfoEndpointUri(new String(original));
    }

    public boolean isCheckAccessTokenType() {
        return this.checkAccessTokenType;
    }

    public A withCheckAccessTokenType(boolean checkAccessTokenType) {
        this.checkAccessTokenType=checkAccessTokenType; return (A) this;
    }

    public java.lang.Boolean hasCheckAccessTokenType() {
        return true;
    }

    public java.lang.String getValidTokenType() {
        return this.validTokenType;
    }

    public A withValidTokenType(java.lang.String validTokenType) {
        this.validTokenType=validTokenType; return (A) this;
    }

    public java.lang.Boolean hasValidTokenType() {
        return this.validTokenType != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withValidTokenType instead.
     */
        public A withNewValidTokenType(java.lang.String original) {
        return (A)withValidTokenType(new String(original));
    }

    public boolean isAccessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    public A withAccessTokenIsJwt(boolean accessTokenIsJwt) {
        this.accessTokenIsJwt=accessTokenIsJwt; return (A) this;
    }

    public java.lang.Boolean hasAccessTokenIsJwt() {
        return true;
    }

    public A addToTlsTrustedCertificates(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(index >= 0 ? index : _visitables.get("tlsTrustedCertificates").size(), builder);this.tlsTrustedCertificates.add(index >= 0 ? index : tlsTrustedCertificates.size(), builder); return (A)this;
    }

    public A setToTlsTrustedCertificates(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);
        if (index < 0 || index >= _visitables.get("tlsTrustedCertificates").size()) { _visitables.get("tlsTrustedCertificates").add(builder); } else { _visitables.get("tlsTrustedCertificates").set(index, builder);}
        if (index < 0 || index >= tlsTrustedCertificates.size()) { tlsTrustedCertificates.add(builder); } else { tlsTrustedCertificates.set(index, builder);}
         return (A)this;
    }

    public A addToTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
    }

    public A addAllToTlsTrustedCertificates(java.util.Collection<io.strimzi.api.kafka.model.CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
    }

    public A removeFromTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items) {
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder);if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeAllFromTlsTrustedCertificates(java.util.Collection<io.strimzi.api.kafka.model.CertSecretSource> items) {
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder);if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTlsTrustedCertificates(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        if (tlsTrustedCertificates == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.CertSecretSourceBuilder> each = tlsTrustedCertificates.iterator();
        final List visitables = _visitables.get("tlsTrustedCertificates");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTlsTrustedCertificates instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.CertSecretSource> getTlsTrustedCertificates() {
        return build(tlsTrustedCertificates);
    }

    public java.util.List<io.strimzi.api.kafka.model.CertSecretSource> buildTlsTrustedCertificates() {
        return build(tlsTrustedCertificates);
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildTlsTrustedCertificate(int index) {
        return this.tlsTrustedCertificates.get(index).build();
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildFirstTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(0).build();
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildLastTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(tlsTrustedCertificates.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        for (io.strimzi.api.kafka.model.CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        for (io.strimzi.api.kafka.model.CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTlsTrustedCertificates(java.util.List<io.strimzi.api.kafka.model.CertSecretSource> tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) { _visitables.get("tlsTrustedCertificates").removeAll(this.tlsTrustedCertificates);}
        if (tlsTrustedCertificates != null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>(); for (io.strimzi.api.kafka.model.CertSecretSource item : tlsTrustedCertificates){this.addToTlsTrustedCertificates(item);}} else { this.tlsTrustedCertificates = null;} return (A) this;
    }

    public A withTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.clear();}
        if (tlsTrustedCertificates != null) {for (io.strimzi.api.kafka.model.CertSecretSource item :tlsTrustedCertificates){ this.addToTlsTrustedCertificates(item);}} return (A) this;
    }

    public java.lang.Boolean hasTlsTrustedCertificates() {
        return tlsTrustedCertificates != null && !tlsTrustedCertificates.isEmpty();
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
        return new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluentImpl.TlsTrustedCertificatesNestedImpl();
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(io.strimzi.api.kafka.model.CertSecretSource item) {
        return new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluentImpl.TlsTrustedCertificatesNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
        return new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluentImpl.TlsTrustedCertificatesNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
        if (tlsTrustedCertificates.size() <= index) throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
        return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
        if (tlsTrustedCertificates.size() == 0) throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
        return setNewTlsTrustedCertificateLike(0, buildTlsTrustedCertificate(0));
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
        int index = tlsTrustedCertificates.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
        return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<tlsTrustedCertificates.size();i++) { 
        if (predicate.test(tlsTrustedCertificates.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
        return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification=disableTlsHostnameVerification; return (A) this;
    }

    public java.lang.Boolean hasDisableTlsHostnameVerification() {
        return true;
    }

    public java.lang.Boolean getEnableECDSA() {
        return this.enableECDSA;
    }

    public A withEnableECDSA(java.lang.Boolean enableECDSA) {
        this.enableECDSA=enableECDSA; return (A) this;
    }

    public java.lang.Boolean hasEnableECDSA() {
        return this.enableECDSA != null;
    }

    public java.lang.Integer getMaxSecondsWithoutReauthentication() {
        return this.maxSecondsWithoutReauthentication;
    }

    public A withMaxSecondsWithoutReauthentication(java.lang.Integer maxSecondsWithoutReauthentication) {
        this.maxSecondsWithoutReauthentication=maxSecondsWithoutReauthentication; return (A) this;
    }

    public java.lang.Boolean hasMaxSecondsWithoutReauthentication() {
        return this.maxSecondsWithoutReauthentication != null;
    }

    public boolean isEnablePlain() {
        return this.enablePlain;
    }

    public A withEnablePlain(boolean enablePlain) {
        this.enablePlain=enablePlain; return (A) this;
    }

    public java.lang.Boolean hasEnablePlain() {
        return true;
    }

    public java.lang.String getTokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public A withTokenEndpointUri(java.lang.String tokenEndpointUri) {
        this.tokenEndpointUri=tokenEndpointUri; return (A) this;
    }

    public java.lang.Boolean hasTokenEndpointUri() {
        return this.tokenEndpointUri != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTokenEndpointUri instead.
     */
        public A withNewTokenEndpointUri(java.lang.String original) {
        return (A)withTokenEndpointUri(new String(original));
    }

    public boolean isEnableOauthBearer() {
        return this.enableOauthBearer;
    }

    public A withEnableOauthBearer(boolean enableOauthBearer) {
        this.enableOauthBearer=enableOauthBearer; return (A) this;
    }

    public java.lang.Boolean hasEnableOauthBearer() {
        return true;
    }

    public java.lang.String getCustomClaimCheck() {
        return this.customClaimCheck;
    }

    public A withCustomClaimCheck(java.lang.String customClaimCheck) {
        this.customClaimCheck=customClaimCheck; return (A) this;
    }

    public java.lang.Boolean hasCustomClaimCheck() {
        return this.customClaimCheck != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withCustomClaimCheck instead.
     */
        public A withNewCustomClaimCheck(java.lang.String original) {
        return (A)withCustomClaimCheck(new String(original));
    }

    public java.lang.Integer getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public A withConnectTimeoutSeconds(java.lang.Integer connectTimeoutSeconds) {
        this.connectTimeoutSeconds=connectTimeoutSeconds; return (A) this;
    }

    public java.lang.Boolean hasConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds != null;
    }

    public java.lang.Integer getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public A withReadTimeoutSeconds(java.lang.Integer readTimeoutSeconds) {
        this.readTimeoutSeconds=readTimeoutSeconds; return (A) this;
    }

    public java.lang.Boolean hasReadTimeoutSeconds() {
        return this.readTimeoutSeconds != null;
    }

    public java.lang.String getClientScope() {
        return this.clientScope;
    }

    public A withClientScope(java.lang.String clientScope) {
        this.clientScope=clientScope; return (A) this;
    }

    public java.lang.Boolean hasClientScope() {
        return this.clientScope != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientScope instead.
     */
        public A withNewClientScope(java.lang.String original) {
        return (A)withClientScope(new String(original));
    }

    public java.lang.String getClientAudience() {
        return this.clientAudience;
    }

    public A withClientAudience(java.lang.String clientAudience) {
        this.clientAudience=clientAudience; return (A) this;
    }

    public java.lang.Boolean hasClientAudience() {
        return this.clientAudience != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientAudience instead.
     */
        public A withNewClientAudience(java.lang.String original) {
        return (A)withClientAudience(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaListenerAuthenticationOAuthFluentImpl that = (KafkaListenerAuthenticationOAuthFluentImpl) o;
        if (clientId != null ? !clientId.equals(that.clientId) :that.clientId != null) return false;
        if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
        if (validIssuerUri != null ? !validIssuerUri.equals(that.validIssuerUri) :that.validIssuerUri != null) return false;
        if (checkIssuer != that.checkIssuer) return false;
        if (checkAudience != that.checkAudience) return false;
        if (jwksEndpointUri != null ? !jwksEndpointUri.equals(that.jwksEndpointUri) :that.jwksEndpointUri != null) return false;
        if (jwksRefreshSeconds != null ? !jwksRefreshSeconds.equals(that.jwksRefreshSeconds) :that.jwksRefreshSeconds != null) return false;
        if (jwksMinRefreshPauseSeconds != null ? !jwksMinRefreshPauseSeconds.equals(that.jwksMinRefreshPauseSeconds) :that.jwksMinRefreshPauseSeconds != null) return false;
        if (jwksExpirySeconds != null ? !jwksExpirySeconds.equals(that.jwksExpirySeconds) :that.jwksExpirySeconds != null) return false;
        if (introspectionEndpointUri != null ? !introspectionEndpointUri.equals(that.introspectionEndpointUri) :that.introspectionEndpointUri != null) return false;
        if (userNameClaim != null ? !userNameClaim.equals(that.userNameClaim) :that.userNameClaim != null) return false;
        if (fallbackUserNameClaim != null ? !fallbackUserNameClaim.equals(that.fallbackUserNameClaim) :that.fallbackUserNameClaim != null) return false;
        if (fallbackUserNamePrefix != null ? !fallbackUserNamePrefix.equals(that.fallbackUserNamePrefix) :that.fallbackUserNamePrefix != null) return false;
        if (groupsClaim != null ? !groupsClaim.equals(that.groupsClaim) :that.groupsClaim != null) return false;
        if (groupsClaimDelimiter != null ? !groupsClaimDelimiter.equals(that.groupsClaimDelimiter) :that.groupsClaimDelimiter != null) return false;
        if (userInfoEndpointUri != null ? !userInfoEndpointUri.equals(that.userInfoEndpointUri) :that.userInfoEndpointUri != null) return false;
        if (checkAccessTokenType != that.checkAccessTokenType) return false;
        if (validTokenType != null ? !validTokenType.equals(that.validTokenType) :that.validTokenType != null) return false;
        if (accessTokenIsJwt != that.accessTokenIsJwt) return false;
        if (tlsTrustedCertificates != null ? !tlsTrustedCertificates.equals(that.tlsTrustedCertificates) :that.tlsTrustedCertificates != null) return false;
        if (disableTlsHostnameVerification != that.disableTlsHostnameVerification) return false;
        if (enableECDSA != null ? !enableECDSA.equals(that.enableECDSA) :that.enableECDSA != null) return false;
        if (maxSecondsWithoutReauthentication != null ? !maxSecondsWithoutReauthentication.equals(that.maxSecondsWithoutReauthentication) :that.maxSecondsWithoutReauthentication != null) return false;
        if (enablePlain != that.enablePlain) return false;
        if (tokenEndpointUri != null ? !tokenEndpointUri.equals(that.tokenEndpointUri) :that.tokenEndpointUri != null) return false;
        if (enableOauthBearer != that.enableOauthBearer) return false;
        if (customClaimCheck != null ? !customClaimCheck.equals(that.customClaimCheck) :that.customClaimCheck != null) return false;
        if (connectTimeoutSeconds != null ? !connectTimeoutSeconds.equals(that.connectTimeoutSeconds) :that.connectTimeoutSeconds != null) return false;
        if (readTimeoutSeconds != null ? !readTimeoutSeconds.equals(that.readTimeoutSeconds) :that.readTimeoutSeconds != null) return false;
        if (clientScope != null ? !clientScope.equals(that.clientScope) :that.clientScope != null) return false;
        if (clientAudience != null ? !clientAudience.equals(that.clientAudience) :that.clientAudience != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(clientId,  clientSecret,  validIssuerUri,  checkIssuer,  checkAudience,  jwksEndpointUri,  jwksRefreshSeconds,  jwksMinRefreshPauseSeconds,  jwksExpirySeconds,  introspectionEndpointUri,  userNameClaim,  fallbackUserNameClaim,  fallbackUserNamePrefix,  groupsClaim,  groupsClaimDelimiter,  userInfoEndpointUri,  checkAccessTokenType,  validTokenType,  accessTokenIsJwt,  tlsTrustedCertificates,  disableTlsHostnameVerification,  enableECDSA,  maxSecondsWithoutReauthentication,  enablePlain,  tokenEndpointUri,  enableOauthBearer,  customClaimCheck,  connectTimeoutSeconds,  readTimeoutSeconds,  clientScope,  clientAudience,  super.hashCode());
    }

      
  /**
   * Represents a generic secret inside a Kubernetes Secret
   */
  public class ClientSecretNestedImpl<N> extends io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl<io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<N>> implements io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.GenericSecretSourceBuilder builder;

            ClientSecretNestedImpl(io.strimzi.api.kafka.model.GenericSecretSource item) {
                this.builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(this, item);
                        
            }

            ClientSecretNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaListenerAuthenticationOAuthFluentImpl.this.withClientSecret(builder.build());
            }

            public N endClientSecret() {
                return and();
            }
    }


      
  /**
   * Represents a certificate inside a Secret
   */
  public class TlsTrustedCertificatesNestedImpl<N> extends io.strimzi.api.kafka.model.CertSecretSourceFluentImpl<io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>> implements io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.CertSecretSourceBuilder builder;
        private final int index;

            TlsTrustedCertificatesNestedImpl(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(this, item);
                        
            }

            TlsTrustedCertificatesNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaListenerAuthenticationOAuthFluentImpl.this.setToTlsTrustedCertificates(index,builder.build());
            }

            public N endTlsTrustedCertificate() {
                return and();
            }
    }


}
