package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures the external listener which exposes Kafka outside of Kubernetes / OpenShift
   */
  public class GenericKafkaListenerBuilder extends io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluentImpl<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerBuilder> {

    io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public GenericKafkaListenerBuilder() {
        this(true);
    }

    public GenericKafkaListenerBuilder(java.lang.Boolean validationEnabled) {
        this(new GenericKafkaListener(), validationEnabled);
    }

    public GenericKafkaListenerBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent<?> fluent) {
        this(fluent, true);
    }

    public GenericKafkaListenerBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new GenericKafkaListener(), validationEnabled);
    }

    public GenericKafkaListenerBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent<?> fluent,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener instance) {
        this(fluent, instance, true);
    }

    public GenericKafkaListenerBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent<?> fluent,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName());
        
        fluent.withPort(instance.getPort());
        
        fluent.withType(instance.getType());
        
        fluent.withTls(instance.isTls());
        
        fluent.withAuth(instance.getAuth());
        
        fluent.withConfiguration(instance.getConfiguration());
        
        fluent.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
        
        this.validationEnabled = validationEnabled; 
    }

    public GenericKafkaListenerBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener instance) {
        this(instance,true);
    }

    public GenericKafkaListenerBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName());
        
        this.withPort(instance.getPort());
        
        this.withType(instance.getType());
        
        this.withTls(instance.isTls());
        
        this.withAuth(instance.getAuth());
        
        this.withConfiguration(instance.getConfiguration());
        
        this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener build() {
        GenericKafkaListener buildable = new GenericKafkaListener();
        buildable.setName(fluent.getName());
        buildable.setPort(fluent.getPort());
        buildable.setType(fluent.getType());
        buildable.setTls(fluent.isTls());
        buildable.setAuth(fluent.getAuth());
        buildable.setConfiguration(fluent.getConfiguration());
        buildable.setNetworkPolicyPeers(fluent.getNetworkPolicyPeers());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GenericKafkaListenerBuilder that = (GenericKafkaListenerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
