package io.strimzi.api.kafka.model.listener.arraylistener;

import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

  
  /**
   * Configures listener bootstrap configuration
   */
  public class GenericKafkaListenerConfigurationBootstrapFluentImpl<A extends io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrapFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrapFluent<A> {

    private java.util.List<java.lang.String> alternativeNames;
    private java.lang.String host;
    private java.util.Map<java.lang.String,java.lang.String> annotations;
    private java.util.Map<java.lang.String,java.lang.String> labels;
    private java.lang.Integer nodePort;
    private java.lang.String loadBalancerIP;

    public GenericKafkaListenerConfigurationBootstrapFluentImpl() {
    }

    public GenericKafkaListenerConfigurationBootstrapFluentImpl(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrap instance) {
        this.withAlternativeNames(instance.getAlternativeNames());
        
        this.withHost(instance.getHost());
        
        this.withAnnotations(instance.getAnnotations());
        
        this.withLabels(instance.getLabels());
        
        this.withNodePort(instance.getNodePort());
        
        this.withLoadBalancerIP(instance.getLoadBalancerIP());
    }

    public A addToAlternativeNames(int index,java.lang.String item) {
        if (this.alternativeNames == null) {this.alternativeNames = new java.util.ArrayList<java.lang.String>();}
        this.alternativeNames.add(index, item);
        return (A)this;
    }

    public A setToAlternativeNames(int index,java.lang.String item) {
        if (this.alternativeNames == null) {this.alternativeNames = new java.util.ArrayList<java.lang.String>();}
        this.alternativeNames.set(index, item); return (A)this;
    }

    public A addToAlternativeNames(java.lang.String... items) {
        if (this.alternativeNames == null) {this.alternativeNames = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.alternativeNames.add(item);} return (A)this;
    }

    public A addAllToAlternativeNames(java.util.Collection<java.lang.String> items) {
        if (this.alternativeNames == null) {this.alternativeNames = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.alternativeNames.add(item);} return (A)this;
    }

    public A removeFromAlternativeNames(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.alternativeNames!= null){ this.alternativeNames.remove(item);}} return (A)this;
    }

    public A removeAllFromAlternativeNames(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.alternativeNames!= null){ this.alternativeNames.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getAlternativeNames() {
        return this.alternativeNames;
    }

    public java.lang.String getAlternativeName(int index) {
        return this.alternativeNames.get(index);
    }

    public java.lang.String getFirstAlternativeName() {
        return this.alternativeNames.get(0);
    }

    public java.lang.String getLastAlternativeName() {
        return this.alternativeNames.get(alternativeNames.size() - 1);
    }

    public java.lang.String getMatchingAlternativeName(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: alternativeNames) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingAlternativeName(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: alternativeNames) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAlternativeNames(java.util.List<java.lang.String> alternativeNames) {
        if (this.alternativeNames != null) { _visitables.get("alternativeNames").removeAll(this.alternativeNames);}
        if (alternativeNames != null) {this.alternativeNames = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : alternativeNames){this.addToAlternativeNames(item);}} else { this.alternativeNames = null;} return (A) this;
    }

    public A withAlternativeNames(java.lang.String... alternativeNames) {
        if (this.alternativeNames != null) {this.alternativeNames.clear();}
        if (alternativeNames != null) {for (java.lang.String item :alternativeNames){ this.addToAlternativeNames(item);}} return (A) this;
    }

    public java.lang.Boolean hasAlternativeNames() {
        return alternativeNames != null && !alternativeNames.isEmpty();
    }

    public A addNewAlternativeName(java.lang.String original) {
        return (A)addToAlternativeNames(new String(original));
    }

    public java.lang.String getHost() {
        return this.host;
    }

    public A withHost(java.lang.String host) {
        this.host=host; return (A) this;
    }

    public java.lang.Boolean hasHost() {
        return this.host != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHost instead.
     */
        public A withNewHost(java.lang.String original) {
        return (A)withHost(new String(original));
    }

    public A addToAnnotations(java.lang.String key,java.lang.String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.annotations == null && map != null) { this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(java.lang.String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.String> getAnnotations() {
        return this.annotations;
    }

    public <K,V>A withAnnotations(java.util.Map<java.lang.String,java.lang.String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(annotations);} return (A) this;
    }

    public java.lang.Boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToLabels(java.lang.String key,java.lang.String value) {
        if(this.labels == null && key != null && value != null) { this.labels = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.labels == null && map != null) { this.labels = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(java.lang.String key) {
        if(this.labels == null) { return (A) this; }
        if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.labels == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.String> getLabels() {
        return this.labels;
    }

    public <K,V>A withLabels(java.util.Map<java.lang.String,java.lang.String> labels) {
        if (labels == null) { this.labels =  null;} else {this.labels = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(labels);} return (A) this;
    }

    public java.lang.Boolean hasLabels() {
        return this.labels != null;
    }

    public java.lang.Integer getNodePort() {
        return this.nodePort;
    }

    public A withNodePort(java.lang.Integer nodePort) {
        this.nodePort=nodePort; return (A) this;
    }

    public java.lang.Boolean hasNodePort() {
        return this.nodePort != null;
    }

    public java.lang.String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    public A withLoadBalancerIP(java.lang.String loadBalancerIP) {
        this.loadBalancerIP=loadBalancerIP; return (A) this;
    }

    public java.lang.Boolean hasLoadBalancerIP() {
        return this.loadBalancerIP != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLoadBalancerIP instead.
     */
        public A withNewLoadBalancerIP(java.lang.String original) {
        return (A)withLoadBalancerIP(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GenericKafkaListenerConfigurationBootstrapFluentImpl that = (GenericKafkaListenerConfigurationBootstrapFluentImpl) o;
        if (alternativeNames != null ? !alternativeNames.equals(that.alternativeNames) :that.alternativeNames != null) return false;
        if (host != null ? !host.equals(that.host) :that.host != null) return false;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
        if (nodePort != null ? !nodePort.equals(that.nodePort) :that.nodePort != null) return false;
        if (loadBalancerIP != null ? !loadBalancerIP.equals(that.loadBalancerIP) :that.loadBalancerIP != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(alternativeNames,  host,  annotations,  labels,  nodePort,  loadBalancerIP,  super.hashCode());
    }

}
