package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures listener per-broker configuration
   */
  public class GenericKafkaListenerConfigurationBrokerBuilder extends io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerFluentImpl<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder> {

    io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public GenericKafkaListenerConfigurationBrokerBuilder() {
        this(true);
    }

    public GenericKafkaListenerConfigurationBrokerBuilder(java.lang.Boolean validationEnabled) {
        this(new GenericKafkaListenerConfigurationBroker(), validationEnabled);
    }

    public GenericKafkaListenerConfigurationBrokerBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerFluent<?> fluent) {
        this(fluent, true);
    }

    public GenericKafkaListenerConfigurationBrokerBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new GenericKafkaListenerConfigurationBroker(), validationEnabled);
    }

    public GenericKafkaListenerConfigurationBrokerBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerFluent<?> fluent,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker instance) {
        this(fluent, instance, true);
    }

    public GenericKafkaListenerConfigurationBrokerBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerFluent<?> fluent,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBroker(instance.getBroker());
        
        fluent.withAdvertisedHost(instance.getAdvertisedHost());
        
        fluent.withAdvertisedPort(instance.getAdvertisedPort());
        
        fluent.withHost(instance.getHost());
        
        fluent.withAnnotations(instance.getAnnotations());
        
        fluent.withLabels(instance.getLabels());
        
        fluent.withNodePort(instance.getNodePort());
        
        fluent.withLoadBalancerIP(instance.getLoadBalancerIP());
        
        this.validationEnabled = validationEnabled; 
    }

    public GenericKafkaListenerConfigurationBrokerBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker instance) {
        this(instance,true);
    }

    public GenericKafkaListenerConfigurationBrokerBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withBroker(instance.getBroker());
        
        this.withAdvertisedHost(instance.getAdvertisedHost());
        
        this.withAdvertisedPort(instance.getAdvertisedPort());
        
        this.withHost(instance.getHost());
        
        this.withAnnotations(instance.getAnnotations());
        
        this.withLabels(instance.getLabels());
        
        this.withNodePort(instance.getNodePort());
        
        this.withLoadBalancerIP(instance.getLoadBalancerIP());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker build() {
        GenericKafkaListenerConfigurationBroker buildable = new GenericKafkaListenerConfigurationBroker();
        buildable.setBroker(fluent.getBroker());
        buildable.setAdvertisedHost(fluent.getAdvertisedHost());
        buildable.setAdvertisedPort(fluent.getAdvertisedPort());
        buildable.setHost(fluent.getHost());
        buildable.setAnnotations(fluent.getAnnotations());
        buildable.setLabels(fluent.getLabels());
        buildable.setNodePort(fluent.getNodePort());
        buildable.setLoadBalancerIP(fluent.getLoadBalancerIP());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GenericKafkaListenerConfigurationBrokerBuilder that = (GenericKafkaListenerConfigurationBrokerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
