package io.strimzi.api.kafka.model.listener.arraylistener;

import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

  
  /**
   * Configures listener per-broker configuration
   */
  public class GenericKafkaListenerConfigurationBrokerFluentImpl<A extends io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerFluent<A> {

    private java.lang.Integer broker;
    private java.lang.String advertisedHost;
    private java.lang.Integer advertisedPort;
    private java.lang.String host;
    private java.util.Map<java.lang.String,java.lang.String> annotations;
    private java.util.Map<java.lang.String,java.lang.String> labels;
    private java.lang.Integer nodePort;
    private java.lang.String loadBalancerIP;

    public GenericKafkaListenerConfigurationBrokerFluentImpl() {
    }

    public GenericKafkaListenerConfigurationBrokerFluentImpl(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker instance) {
        this.withBroker(instance.getBroker());
        
        this.withAdvertisedHost(instance.getAdvertisedHost());
        
        this.withAdvertisedPort(instance.getAdvertisedPort());
        
        this.withHost(instance.getHost());
        
        this.withAnnotations(instance.getAnnotations());
        
        this.withLabels(instance.getLabels());
        
        this.withNodePort(instance.getNodePort());
        
        this.withLoadBalancerIP(instance.getLoadBalancerIP());
    }

    public java.lang.Integer getBroker() {
        return this.broker;
    }

    public A withBroker(java.lang.Integer broker) {
        this.broker=broker; return (A) this;
    }

    public java.lang.Boolean hasBroker() {
        return this.broker != null;
    }

    public java.lang.String getAdvertisedHost() {
        return this.advertisedHost;
    }

    public A withAdvertisedHost(java.lang.String advertisedHost) {
        this.advertisedHost=advertisedHost; return (A) this;
    }

    public java.lang.Boolean hasAdvertisedHost() {
        return this.advertisedHost != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withAdvertisedHost instead.
     */
        public A withNewAdvertisedHost(java.lang.String original) {
        return (A)withAdvertisedHost(new String(original));
    }

    public java.lang.Integer getAdvertisedPort() {
        return this.advertisedPort;
    }

    public A withAdvertisedPort(java.lang.Integer advertisedPort) {
        this.advertisedPort=advertisedPort; return (A) this;
    }

    public java.lang.Boolean hasAdvertisedPort() {
        return this.advertisedPort != null;
    }

    public java.lang.String getHost() {
        return this.host;
    }

    public A withHost(java.lang.String host) {
        this.host=host; return (A) this;
    }

    public java.lang.Boolean hasHost() {
        return this.host != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHost instead.
     */
        public A withNewHost(java.lang.String original) {
        return (A)withHost(new String(original));
    }

    public A addToAnnotations(java.lang.String key,java.lang.String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.annotations == null && map != null) { this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(java.lang.String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.String> getAnnotations() {
        return this.annotations;
    }

    public <K,V>A withAnnotations(java.util.Map<java.lang.String,java.lang.String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(annotations);} return (A) this;
    }

    public java.lang.Boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToLabels(java.lang.String key,java.lang.String value) {
        if(this.labels == null && key != null && value != null) { this.labels = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.labels == null && map != null) { this.labels = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(java.lang.String key) {
        if(this.labels == null) { return (A) this; }
        if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.labels == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.String> getLabels() {
        return this.labels;
    }

    public <K,V>A withLabels(java.util.Map<java.lang.String,java.lang.String> labels) {
        if (labels == null) { this.labels =  null;} else {this.labels = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(labels);} return (A) this;
    }

    public java.lang.Boolean hasLabels() {
        return this.labels != null;
    }

    public java.lang.Integer getNodePort() {
        return this.nodePort;
    }

    public A withNodePort(java.lang.Integer nodePort) {
        this.nodePort=nodePort; return (A) this;
    }

    public java.lang.Boolean hasNodePort() {
        return this.nodePort != null;
    }

    public java.lang.String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    public A withLoadBalancerIP(java.lang.String loadBalancerIP) {
        this.loadBalancerIP=loadBalancerIP; return (A) this;
    }

    public java.lang.Boolean hasLoadBalancerIP() {
        return this.loadBalancerIP != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLoadBalancerIP instead.
     */
        public A withNewLoadBalancerIP(java.lang.String original) {
        return (A)withLoadBalancerIP(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GenericKafkaListenerConfigurationBrokerFluentImpl that = (GenericKafkaListenerConfigurationBrokerFluentImpl) o;
        if (broker != null ? !broker.equals(that.broker) :that.broker != null) return false;
        if (advertisedHost != null ? !advertisedHost.equals(that.advertisedHost) :that.advertisedHost != null) return false;
        if (advertisedPort != null ? !advertisedPort.equals(that.advertisedPort) :that.advertisedPort != null) return false;
        if (host != null ? !host.equals(that.host) :that.host != null) return false;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
        if (nodePort != null ? !nodePort.equals(that.nodePort) :that.nodePort != null) return false;
        if (loadBalancerIP != null ? !loadBalancerIP.equals(that.loadBalancerIP) :that.loadBalancerIP != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(broker,  advertisedHost,  advertisedPort,  host,  annotations,  labels,  nodePort,  loadBalancerIP,  super.hashCode());
    }

}
