package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures Kafka listeners
   */
  public class GenericKafkaListenerConfigurationBuilder extends io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluentImpl<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBuilder> {

    io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public GenericKafkaListenerConfigurationBuilder() {
        this(true);
    }

    public GenericKafkaListenerConfigurationBuilder(java.lang.Boolean validationEnabled) {
        this(new GenericKafkaListenerConfiguration(), validationEnabled);
    }

    public GenericKafkaListenerConfigurationBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent<?> fluent) {
        this(fluent, true);
    }

    public GenericKafkaListenerConfigurationBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new GenericKafkaListenerConfiguration(), validationEnabled);
    }

    public GenericKafkaListenerConfigurationBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent<?> fluent,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration instance) {
        this(fluent, instance, true);
    }

    public GenericKafkaListenerConfigurationBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent<?> fluent,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
        
        fluent.withIngressClass(instance.getIngressClass());
        
        fluent.withPreferredNodePortAddressType(instance.getPreferredNodePortAddressType());
        
        fluent.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
        
        fluent.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
        
        fluent.withFinalizers(instance.getFinalizers());
        
        fluent.withUseServiceDnsDomain(instance.getUseServiceDnsDomain());
        
        fluent.withBootstrap(instance.getBootstrap());
        
        fluent.withBrokers(instance.getBrokers());
        
        fluent.withMaxConnections(instance.getMaxConnections());
        
        fluent.withMaxConnectionCreationRate(instance.getMaxConnectionCreationRate());
        
        fluent.withIpFamilyPolicy(instance.getIpFamilyPolicy());
        
        fluent.withIpFamilies(instance.getIpFamilies());
        
        fluent.withCreateBootstrapService(instance.getCreateBootstrapService());
        
        this.validationEnabled = validationEnabled; 
    }

    public GenericKafkaListenerConfigurationBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration instance) {
        this(instance,true);
    }

    public GenericKafkaListenerConfigurationBuilder(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
        
        this.withIngressClass(instance.getIngressClass());
        
        this.withPreferredNodePortAddressType(instance.getPreferredNodePortAddressType());
        
        this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
        
        this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
        
        this.withFinalizers(instance.getFinalizers());
        
        this.withUseServiceDnsDomain(instance.getUseServiceDnsDomain());
        
        this.withBootstrap(instance.getBootstrap());
        
        this.withBrokers(instance.getBrokers());
        
        this.withMaxConnections(instance.getMaxConnections());
        
        this.withMaxConnectionCreationRate(instance.getMaxConnectionCreationRate());
        
        this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
        
        this.withIpFamilies(instance.getIpFamilies());
        
        this.withCreateBootstrapService(instance.getCreateBootstrapService());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration build() {
        GenericKafkaListenerConfiguration buildable = new GenericKafkaListenerConfiguration();
        buildable.setBrokerCertChainAndKey(fluent.getBrokerCertChainAndKey());
        buildable.setIngressClass(fluent.getIngressClass());
        buildable.setPreferredNodePortAddressType(fluent.getPreferredNodePortAddressType());
        buildable.setExternalTrafficPolicy(fluent.getExternalTrafficPolicy());
        buildable.setLoadBalancerSourceRanges(fluent.getLoadBalancerSourceRanges());
        buildable.setFinalizers(fluent.getFinalizers());
        buildable.setUseServiceDnsDomain(fluent.getUseServiceDnsDomain());
        buildable.setBootstrap(fluent.getBootstrap());
        buildable.setBrokers(fluent.getBrokers());
        buildable.setMaxConnections(fluent.getMaxConnections());
        buildable.setMaxConnectionCreationRate(fluent.getMaxConnectionCreationRate());
        buildable.setIpFamilyPolicy(fluent.getIpFamilyPolicy());
        buildable.setIpFamilies(fluent.getIpFamilies());
        buildable.setCreateBootstrapService(fluent.getCreateBootstrapService());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GenericKafkaListenerConfigurationBuilder that = (GenericKafkaListenerConfigurationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
