package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.listener.NodeAddressType;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.strimzi.api.kafka.model.template.IpFamilyPolicy;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.CertAndKeySecretSource;
import io.strimzi.api.kafka.model.template.IpFamily;
import io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder;
import java.lang.Integer;
import io.strimzi.api.kafka.model.CertAndKeySecretSourceFluentImpl;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.template.ExternalTrafficPolicy;

  
  /**
   * Configures Kafka listeners
   */
  public class GenericKafkaListenerConfigurationFluentImpl<A extends io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent<A> {

    private io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder brokerCertChainAndKey;
    private java.lang.String ingressClass;
    private io.strimzi.api.kafka.model.listener.NodeAddressType preferredNodePortAddressType;
    private io.strimzi.api.kafka.model.template.ExternalTrafficPolicy externalTrafficPolicy;
    private java.util.List<java.lang.String> loadBalancerSourceRanges;
    private java.util.List<java.lang.String> finalizers;
    private java.lang.Boolean useServiceDnsDomain;
    private io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrapBuilder bootstrap;
    private java.util.List<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder> brokers;
    private java.lang.Integer maxConnections;
    private java.lang.Integer maxConnectionCreationRate;
    private io.strimzi.api.kafka.model.template.IpFamilyPolicy ipFamilyPolicy;
    private java.util.List<io.strimzi.api.kafka.model.template.IpFamily> ipFamilies;
    private java.lang.Boolean createBootstrapService;

    public GenericKafkaListenerConfigurationFluentImpl() {
    }

    public GenericKafkaListenerConfigurationFluentImpl(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration instance) {
        this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
        
        this.withIngressClass(instance.getIngressClass());
        
        this.withPreferredNodePortAddressType(instance.getPreferredNodePortAddressType());
        
        this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
        
        this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
        
        this.withFinalizers(instance.getFinalizers());
        
        this.withUseServiceDnsDomain(instance.getUseServiceDnsDomain());
        
        this.withBootstrap(instance.getBootstrap());
        
        this.withBrokers(instance.getBrokers());
        
        this.withMaxConnections(instance.getMaxConnections());
        
        this.withMaxConnectionCreationRate(instance.getMaxConnectionCreationRate());
        
        this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
        
        this.withIpFamilies(instance.getIpFamilies());
        
        this.withCreateBootstrapService(instance.getCreateBootstrapService());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBrokerCertChainAndKey instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.CertAndKeySecretSource getBrokerCertChainAndKey() {
        return this.brokerCertChainAndKey!=null?this.brokerCertChainAndKey.build():null;
    }

    public io.strimzi.api.kafka.model.CertAndKeySecretSource buildBrokerCertChainAndKey() {
        return this.brokerCertChainAndKey!=null?this.brokerCertChainAndKey.build():null;
    }

    public A withBrokerCertChainAndKey(io.strimzi.api.kafka.model.CertAndKeySecretSource brokerCertChainAndKey) {
        _visitables.get("brokerCertChainAndKey").remove(this.brokerCertChainAndKey);
        if (brokerCertChainAndKey!=null){ this.brokerCertChainAndKey= new io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder(brokerCertChainAndKey); _visitables.get("brokerCertChainAndKey").add(this.brokerCertChainAndKey);} return (A) this;
    }

    public java.lang.Boolean hasBrokerCertChainAndKey() {
        return this.brokerCertChainAndKey != null;
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokerCertChainAndKeyNested<A> withNewBrokerCertChainAndKey() {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluentImpl.BrokerCertChainAndKeyNestedImpl();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokerCertChainAndKeyNested<A> withNewBrokerCertChainAndKeyLike(io.strimzi.api.kafka.model.CertAndKeySecretSource item) {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluentImpl.BrokerCertChainAndKeyNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokerCertChainAndKeyNested<A> editBrokerCertChainAndKey() {
        return withNewBrokerCertChainAndKeyLike(getBrokerCertChainAndKey());
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokerCertChainAndKeyNested<A> editOrNewBrokerCertChainAndKey() {
        return withNewBrokerCertChainAndKeyLike(getBrokerCertChainAndKey() != null ? getBrokerCertChainAndKey(): new io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder().build());
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokerCertChainAndKeyNested<A> editOrNewBrokerCertChainAndKeyLike(io.strimzi.api.kafka.model.CertAndKeySecretSource item) {
        return withNewBrokerCertChainAndKeyLike(getBrokerCertChainAndKey() != null ? getBrokerCertChainAndKey(): item);
    }

    public java.lang.String getIngressClass() {
        return this.ingressClass;
    }

    public A withIngressClass(java.lang.String ingressClass) {
        this.ingressClass=ingressClass; return (A) this;
    }

    public java.lang.Boolean hasIngressClass() {
        return this.ingressClass != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withIngressClass instead.
     */
        public A withNewIngressClass(java.lang.String original) {
        return (A)withIngressClass(new String(original));
    }

    public io.strimzi.api.kafka.model.listener.NodeAddressType getPreferredNodePortAddressType() {
        return this.preferredNodePortAddressType;
    }

    public A withPreferredNodePortAddressType(io.strimzi.api.kafka.model.listener.NodeAddressType preferredNodePortAddressType) {
        this.preferredNodePortAddressType=preferredNodePortAddressType; return (A) this;
    }

    public java.lang.Boolean hasPreferredNodePortAddressType() {
        return this.preferredNodePortAddressType != null;
    }

    public io.strimzi.api.kafka.model.template.ExternalTrafficPolicy getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    public A withExternalTrafficPolicy(io.strimzi.api.kafka.model.template.ExternalTrafficPolicy externalTrafficPolicy) {
        this.externalTrafficPolicy=externalTrafficPolicy; return (A) this;
    }

    public java.lang.Boolean hasExternalTrafficPolicy() {
        return this.externalTrafficPolicy != null;
    }

    public A addToLoadBalancerSourceRanges(int index,java.lang.String item) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new java.util.ArrayList<java.lang.String>();}
        this.loadBalancerSourceRanges.add(index, item);
        return (A)this;
    }

    public A setToLoadBalancerSourceRanges(int index,java.lang.String item) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new java.util.ArrayList<java.lang.String>();}
        this.loadBalancerSourceRanges.set(index, item); return (A)this;
    }

    public A addToLoadBalancerSourceRanges(java.lang.String... items) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.loadBalancerSourceRanges.add(item);} return (A)this;
    }

    public A addAllToLoadBalancerSourceRanges(java.util.Collection<java.lang.String> items) {
        if (this.loadBalancerSourceRanges == null) {this.loadBalancerSourceRanges = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.loadBalancerSourceRanges.add(item);} return (A)this;
    }

    public A removeFromLoadBalancerSourceRanges(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.loadBalancerSourceRanges!= null){ this.loadBalancerSourceRanges.remove(item);}} return (A)this;
    }

    public A removeAllFromLoadBalancerSourceRanges(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.loadBalancerSourceRanges!= null){ this.loadBalancerSourceRanges.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    public java.lang.String getLoadBalancerSourceRange(int index) {
        return this.loadBalancerSourceRanges.get(index);
    }

    public java.lang.String getFirstLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(0);
    }

    public java.lang.String getLastLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(loadBalancerSourceRanges.size() - 1);
    }

    public java.lang.String getMatchingLoadBalancerSourceRange(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: loadBalancerSourceRanges) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingLoadBalancerSourceRange(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: loadBalancerSourceRanges) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withLoadBalancerSourceRanges(java.util.List<java.lang.String> loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) { _visitables.get("loadBalancerSourceRanges").removeAll(this.loadBalancerSourceRanges);}
        if (loadBalancerSourceRanges != null) {this.loadBalancerSourceRanges = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : loadBalancerSourceRanges){this.addToLoadBalancerSourceRanges(item);}} else { this.loadBalancerSourceRanges = null;} return (A) this;
    }

    public A withLoadBalancerSourceRanges(java.lang.String... loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) {this.loadBalancerSourceRanges.clear();}
        if (loadBalancerSourceRanges != null) {for (java.lang.String item :loadBalancerSourceRanges){ this.addToLoadBalancerSourceRanges(item);}} return (A) this;
    }

    public java.lang.Boolean hasLoadBalancerSourceRanges() {
        return loadBalancerSourceRanges != null && !loadBalancerSourceRanges.isEmpty();
    }

    public A addNewLoadBalancerSourceRange(java.lang.String original) {
        return (A)addToLoadBalancerSourceRanges(new String(original));
    }

    public A addToFinalizers(int index,java.lang.String item) {
        if (this.finalizers == null) {this.finalizers = new java.util.ArrayList<java.lang.String>();}
        this.finalizers.add(index, item);
        return (A)this;
    }

    public A setToFinalizers(int index,java.lang.String item) {
        if (this.finalizers == null) {this.finalizers = new java.util.ArrayList<java.lang.String>();}
        this.finalizers.set(index, item); return (A)this;
    }

    public A addToFinalizers(java.lang.String... items) {
        if (this.finalizers == null) {this.finalizers = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.finalizers.add(item);} return (A)this;
    }

    public A addAllToFinalizers(java.util.Collection<java.lang.String> items) {
        if (this.finalizers == null) {this.finalizers = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.finalizers.add(item);} return (A)this;
    }

    public A removeFromFinalizers(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.finalizers!= null){ this.finalizers.remove(item);}} return (A)this;
    }

    public A removeAllFromFinalizers(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.finalizers!= null){ this.finalizers.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getFinalizers() {
        return this.finalizers;
    }

    public java.lang.String getFinalizer(int index) {
        return this.finalizers.get(index);
    }

    public java.lang.String getFirstFinalizer() {
        return this.finalizers.get(0);
    }

    public java.lang.String getLastFinalizer() {
        return this.finalizers.get(finalizers.size() - 1);
    }

    public java.lang.String getMatchingFinalizer(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: finalizers) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingFinalizer(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: finalizers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withFinalizers(java.util.List<java.lang.String> finalizers) {
        if (this.finalizers != null) { _visitables.get("finalizers").removeAll(this.finalizers);}
        if (finalizers != null) {this.finalizers = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : finalizers){this.addToFinalizers(item);}} else { this.finalizers = null;} return (A) this;
    }

    public A withFinalizers(java.lang.String... finalizers) {
        if (this.finalizers != null) {this.finalizers.clear();}
        if (finalizers != null) {for (java.lang.String item :finalizers){ this.addToFinalizers(item);}} return (A) this;
    }

    public java.lang.Boolean hasFinalizers() {
        return finalizers != null && !finalizers.isEmpty();
    }

    public A addNewFinalizer(java.lang.String original) {
        return (A)addToFinalizers(new String(original));
    }

    public java.lang.Boolean getUseServiceDnsDomain() {
        return this.useServiceDnsDomain;
    }

    public A withUseServiceDnsDomain(java.lang.Boolean useServiceDnsDomain) {
        this.useServiceDnsDomain=useServiceDnsDomain; return (A) this;
    }

    public java.lang.Boolean hasUseServiceDnsDomain() {
        return this.useServiceDnsDomain != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBootstrap instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrap getBootstrap() {
        return this.bootstrap!=null?this.bootstrap.build():null;
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrap buildBootstrap() {
        return this.bootstrap!=null?this.bootstrap.build():null;
    }

    public A withBootstrap(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrap bootstrap) {
        _visitables.get("bootstrap").remove(this.bootstrap);
        if (bootstrap!=null){ this.bootstrap= new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrapBuilder(bootstrap); _visitables.get("bootstrap").add(this.bootstrap);} return (A) this;
    }

    public java.lang.Boolean hasBootstrap() {
        return this.bootstrap != null;
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BootstrapNested<A> withNewBootstrap() {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluentImpl.BootstrapNestedImpl();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BootstrapNested<A> withNewBootstrapLike(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrap item) {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluentImpl.BootstrapNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BootstrapNested<A> editBootstrap() {
        return withNewBootstrapLike(getBootstrap());
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BootstrapNested<A> editOrNewBootstrap() {
        return withNewBootstrapLike(getBootstrap() != null ? getBootstrap(): new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrapBuilder().build());
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BootstrapNested<A> editOrNewBootstrapLike(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrap item) {
        return withNewBootstrapLike(getBootstrap() != null ? getBootstrap(): item);
    }

    public A addToBrokers(int index,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker item) {
        if (this.brokers == null) {this.brokers = new java.util.ArrayList<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder>();}
        io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder(item);_visitables.get("brokers").add(index >= 0 ? index : _visitables.get("brokers").size(), builder);this.brokers.add(index >= 0 ? index : brokers.size(), builder); return (A)this;
    }

    public A setToBrokers(int index,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker item) {
        if (this.brokers == null) {this.brokers = new java.util.ArrayList<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder>();}
        io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder(item);
        if (index < 0 || index >= _visitables.get("brokers").size()) { _visitables.get("brokers").add(builder); } else { _visitables.get("brokers").set(index, builder);}
        if (index < 0 || index >= brokers.size()) { brokers.add(builder); } else { brokers.set(index, builder);}
         return (A)this;
    }

    public A addToBrokers(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker... items) {
        if (this.brokers == null) {this.brokers = new java.util.ArrayList<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder>();}
        for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker item : items) {io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder(item);_visitables.get("brokers").add(builder);this.brokers.add(builder);} return (A)this;
    }

    public A addAllToBrokers(java.util.Collection<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker> items) {
        if (this.brokers == null) {this.brokers = new java.util.ArrayList<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder>();}
        for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker item : items) {io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder(item);_visitables.get("brokers").add(builder);this.brokers.add(builder);} return (A)this;
    }

    public A removeFromBrokers(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker... items) {
        for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker item : items) {io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder(item);_visitables.get("brokers").remove(builder);if (this.brokers != null) {this.brokers.remove(builder);}} return (A)this;
    }

    public A removeAllFromBrokers(java.util.Collection<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker> items) {
        for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker item : items) {io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder(item);_visitables.get("brokers").remove(builder);if (this.brokers != null) {this.brokers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBrokers(java.util.function.Predicate<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
        if (brokers == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder> each = brokers.iterator();
        final List visitables = _visitables.get("brokers");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBrokers instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker> getBrokers() {
        return build(brokers);
    }

    public java.util.List<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker> buildBrokers() {
        return build(brokers);
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker buildBroker(int index) {
        return this.brokers.get(index).build();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker buildFirstBroker() {
        return this.brokers.get(0).build();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker buildLastBroker() {
        return this.brokers.get(brokers.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker buildMatchingBroker(java.util.function.Predicate<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
        for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder item: brokers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingBroker(java.util.function.Predicate<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
        for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder item: brokers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withBrokers(java.util.List<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker> brokers) {
        if (this.brokers != null) { _visitables.get("brokers").removeAll(this.brokers);}
        if (brokers != null) {this.brokers = new java.util.ArrayList<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder>(); for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker item : brokers){this.addToBrokers(item);}} else { this.brokers = null;} return (A) this;
    }

    public A withBrokers(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker... brokers) {
        if (this.brokers != null) {this.brokers.clear();}
        if (brokers != null) {for (io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker item :brokers){ this.addToBrokers(item);}} return (A) this;
    }

    public java.lang.Boolean hasBrokers() {
        return brokers != null && !brokers.isEmpty();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokersNested<A> addNewBroker() {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluentImpl.BrokersNestedImpl();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokersNested<A> addNewBrokerLike(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker item) {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluentImpl.BrokersNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokersNested<A> setNewBrokerLike(int index,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker item) {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluentImpl.BrokersNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokersNested<A> editBroker(int index) {
        if (brokers.size() <= index) throw new RuntimeException("Can't edit brokers. Index exceeds size.");
        return setNewBrokerLike(index, buildBroker(index));
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokersNested<A> editFirstBroker() {
        if (brokers.size() == 0) throw new RuntimeException("Can't edit first brokers. The list is empty.");
        return setNewBrokerLike(0, buildBroker(0));
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokersNested<A> editLastBroker() {
        int index = brokers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last brokers. The list is empty.");
        return setNewBrokerLike(index, buildBroker(index));
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokersNested<A> editMatchingBroker(java.util.function.Predicate<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
        int index = -1;
        for (int i=0;i<brokers.size();i++) { 
        if (predicate.test(brokers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching brokers. No match found.");
        return setNewBrokerLike(index, buildBroker(index));
    }

    public java.lang.Integer getMaxConnections() {
        return this.maxConnections;
    }

    public A withMaxConnections(java.lang.Integer maxConnections) {
        this.maxConnections=maxConnections; return (A) this;
    }

    public java.lang.Boolean hasMaxConnections() {
        return this.maxConnections != null;
    }

    public java.lang.Integer getMaxConnectionCreationRate() {
        return this.maxConnectionCreationRate;
    }

    public A withMaxConnectionCreationRate(java.lang.Integer maxConnectionCreationRate) {
        this.maxConnectionCreationRate=maxConnectionCreationRate; return (A) this;
    }

    public java.lang.Boolean hasMaxConnectionCreationRate() {
        return this.maxConnectionCreationRate != null;
    }

    public io.strimzi.api.kafka.model.template.IpFamilyPolicy getIpFamilyPolicy() {
        return this.ipFamilyPolicy;
    }

    public A withIpFamilyPolicy(io.strimzi.api.kafka.model.template.IpFamilyPolicy ipFamilyPolicy) {
        this.ipFamilyPolicy=ipFamilyPolicy; return (A) this;
    }

    public java.lang.Boolean hasIpFamilyPolicy() {
        return this.ipFamilyPolicy != null;
    }

    public A addToIpFamilies(int index,io.strimzi.api.kafka.model.template.IpFamily item) {
        if (this.ipFamilies == null) {this.ipFamilies = new java.util.ArrayList<io.strimzi.api.kafka.model.template.IpFamily>();}
        this.ipFamilies.add(index, item);
        return (A)this;
    }

    public A setToIpFamilies(int index,io.strimzi.api.kafka.model.template.IpFamily item) {
        if (this.ipFamilies == null) {this.ipFamilies = new java.util.ArrayList<io.strimzi.api.kafka.model.template.IpFamily>();}
        this.ipFamilies.set(index, item); return (A)this;
    }

    public A addToIpFamilies(io.strimzi.api.kafka.model.template.IpFamily... items) {
        if (this.ipFamilies == null) {this.ipFamilies = new java.util.ArrayList<io.strimzi.api.kafka.model.template.IpFamily>();}
        for (io.strimzi.api.kafka.model.template.IpFamily item : items) {this.ipFamilies.add(item);} return (A)this;
    }

    public A addAllToIpFamilies(java.util.Collection<io.strimzi.api.kafka.model.template.IpFamily> items) {
        if (this.ipFamilies == null) {this.ipFamilies = new java.util.ArrayList<io.strimzi.api.kafka.model.template.IpFamily>();}
        for (io.strimzi.api.kafka.model.template.IpFamily item : items) {this.ipFamilies.add(item);} return (A)this;
    }

    public A removeFromIpFamilies(io.strimzi.api.kafka.model.template.IpFamily... items) {
        for (io.strimzi.api.kafka.model.template.IpFamily item : items) {if (this.ipFamilies!= null){ this.ipFamilies.remove(item);}} return (A)this;
    }

    public A removeAllFromIpFamilies(java.util.Collection<io.strimzi.api.kafka.model.template.IpFamily> items) {
        for (io.strimzi.api.kafka.model.template.IpFamily item : items) {if (this.ipFamilies!= null){ this.ipFamilies.remove(item);}} return (A)this;
    }

    public java.util.List<io.strimzi.api.kafka.model.template.IpFamily> getIpFamilies() {
        return this.ipFamilies;
    }

    public io.strimzi.api.kafka.model.template.IpFamily getIpFamily(int index) {
        return this.ipFamilies.get(index);
    }

    public io.strimzi.api.kafka.model.template.IpFamily getFirstIpFamily() {
        return this.ipFamilies.get(0);
    }

    public io.strimzi.api.kafka.model.template.IpFamily getLastIpFamily() {
        return this.ipFamilies.get(ipFamilies.size() - 1);
    }

    public io.strimzi.api.kafka.model.template.IpFamily getMatchingIpFamily(java.util.function.Predicate<io.strimzi.api.kafka.model.template.IpFamily> predicate) {
        for (io.strimzi.api.kafka.model.template.IpFamily item: ipFamilies) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingIpFamily(java.util.function.Predicate<io.strimzi.api.kafka.model.template.IpFamily> predicate) {
        for (io.strimzi.api.kafka.model.template.IpFamily item: ipFamilies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIpFamilies(java.util.List<io.strimzi.api.kafka.model.template.IpFamily> ipFamilies) {
        if (this.ipFamilies != null) { _visitables.get("ipFamilies").removeAll(this.ipFamilies);}
        if (ipFamilies != null) {this.ipFamilies = new java.util.ArrayList<io.strimzi.api.kafka.model.template.IpFamily>(); for (io.strimzi.api.kafka.model.template.IpFamily item : ipFamilies){this.addToIpFamilies(item);}} else { this.ipFamilies = null;} return (A) this;
    }

    public A withIpFamilies(io.strimzi.api.kafka.model.template.IpFamily... ipFamilies) {
        if (this.ipFamilies != null) {this.ipFamilies.clear();}
        if (ipFamilies != null) {for (io.strimzi.api.kafka.model.template.IpFamily item :ipFamilies){ this.addToIpFamilies(item);}} return (A) this;
    }

    public java.lang.Boolean hasIpFamilies() {
        return ipFamilies != null && !ipFamilies.isEmpty();
    }

    public java.lang.Boolean getCreateBootstrapService() {
        return this.createBootstrapService;
    }

    public A withCreateBootstrapService(java.lang.Boolean createBootstrapService) {
        this.createBootstrapService=createBootstrapService; return (A) this;
    }

    public java.lang.Boolean hasCreateBootstrapService() {
        return this.createBootstrapService != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GenericKafkaListenerConfigurationFluentImpl that = (GenericKafkaListenerConfigurationFluentImpl) o;
        if (brokerCertChainAndKey != null ? !brokerCertChainAndKey.equals(that.brokerCertChainAndKey) :that.brokerCertChainAndKey != null) return false;
        if (ingressClass != null ? !ingressClass.equals(that.ingressClass) :that.ingressClass != null) return false;
        if (preferredNodePortAddressType != null ? !preferredNodePortAddressType.equals(that.preferredNodePortAddressType) :that.preferredNodePortAddressType != null) return false;
        if (externalTrafficPolicy != null ? !externalTrafficPolicy.equals(that.externalTrafficPolicy) :that.externalTrafficPolicy != null) return false;
        if (loadBalancerSourceRanges != null ? !loadBalancerSourceRanges.equals(that.loadBalancerSourceRanges) :that.loadBalancerSourceRanges != null) return false;
        if (finalizers != null ? !finalizers.equals(that.finalizers) :that.finalizers != null) return false;
        if (useServiceDnsDomain != null ? !useServiceDnsDomain.equals(that.useServiceDnsDomain) :that.useServiceDnsDomain != null) return false;
        if (bootstrap != null ? !bootstrap.equals(that.bootstrap) :that.bootstrap != null) return false;
        if (brokers != null ? !brokers.equals(that.brokers) :that.brokers != null) return false;
        if (maxConnections != null ? !maxConnections.equals(that.maxConnections) :that.maxConnections != null) return false;
        if (maxConnectionCreationRate != null ? !maxConnectionCreationRate.equals(that.maxConnectionCreationRate) :that.maxConnectionCreationRate != null) return false;
        if (ipFamilyPolicy != null ? !ipFamilyPolicy.equals(that.ipFamilyPolicy) :that.ipFamilyPolicy != null) return false;
        if (ipFamilies != null ? !ipFamilies.equals(that.ipFamilies) :that.ipFamilies != null) return false;
        if (createBootstrapService != null ? !createBootstrapService.equals(that.createBootstrapService) :that.createBootstrapService != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(brokerCertChainAndKey,  ingressClass,  preferredNodePortAddressType,  externalTrafficPolicy,  loadBalancerSourceRanges,  finalizers,  useServiceDnsDomain,  bootstrap,  brokers,  maxConnections,  maxConnectionCreationRate,  ipFamilyPolicy,  ipFamilies,  createBootstrapService,  super.hashCode());
    }

      
  /**
   * Represents a certificate and private key pair inside a Secret
   */
  public class BrokerCertChainAndKeyNestedImpl<N> extends io.strimzi.api.kafka.model.CertAndKeySecretSourceFluentImpl<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokerCertChainAndKeyNested<N>> implements io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokerCertChainAndKeyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder builder;

            BrokerCertChainAndKeyNestedImpl(io.strimzi.api.kafka.model.CertAndKeySecretSource item) {
                this.builder = new io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder(this, item);
                        
            }

            BrokerCertChainAndKeyNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerConfigurationFluentImpl.this.withBrokerCertChainAndKey(builder.build());
            }

            public N endBrokerCertChainAndKey() {
                return and();
            }
    }


      
  /**
   * Configures listener bootstrap configuration
   */
  public class BootstrapNestedImpl<N> extends io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrapFluentImpl<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BootstrapNested<N>> implements io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BootstrapNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrapBuilder builder;

            BootstrapNestedImpl(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrap item) {
                this.builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrapBuilder(this, item);
                        
            }

            BootstrapNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBootstrapBuilder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerConfigurationFluentImpl.this.withBootstrap(builder.build());
            }

            public N endBootstrap() {
                return and();
            }
    }


      
  /**
   * Configures listener per-broker configuration
   */
  public class BrokersNestedImpl<N> extends io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerFluentImpl<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokersNested<N>> implements io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent.BrokersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder builder;
        private final int index;

            BrokersNestedImpl(int index,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBroker item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder(this, item);
                        
            }

            BrokersNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBrokerBuilder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerConfigurationFluentImpl.this.setToBrokers(index,builder.build());
            }

            public N endBroker() {
                return and();
            }
    }


}
