package io.strimzi.api.kafka.model.listener.arraylistener;

import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth;
import java.lang.String;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Builder;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls;
import java.lang.Deprecated;
import java.util.List;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomBuilder;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

  
  /**
   * Configures the external listener which exposes Kafka outside of Kubernetes / OpenShift
   */
  public interface GenericKafkaListenerFluent<A extends io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.String getName();
    public A withName(java.lang.String name);
    public java.lang.Boolean hasName();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String original);
    public int getPort();
    public A withPort(int port);
    public java.lang.Boolean hasPort();
    public io.strimzi.api.kafka.model.listener.arraylistener.KafkaListenerType getType();
    public A withType(io.strimzi.api.kafka.model.listener.arraylistener.KafkaListenerType type);
    public java.lang.Boolean hasType();
    public boolean isTls();
    public A withTls(boolean tls);
    public java.lang.Boolean hasTls();
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAuth instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication getAuth();
    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication buildAuth();
    public A withAuth(io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication auth);
    public java.lang.Boolean hasAuth();
    public A withKafkaListenerAuthenticationOAuth(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth kafkaListenerAuthenticationOAuth);
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuth();
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuthLike(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth item);
    public A withKafkaListenerAuthenticationTlsAuth(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls kafkaListenerAuthenticationTlsAuth);
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuth();
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuthLike(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls item);
    public A withKafkaListenerAuthenticationScramSha512Auth(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512 kafkaListenerAuthenticationScramSha512Auth);
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512Auth();
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512AuthLike(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512 item);
    public A withKafkaListenerAuthenticationCustomAuth(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom kafkaListenerAuthenticationCustomAuth);
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationCustomAuthNested<A> withNewKafkaListenerAuthenticationCustomAuth();
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationCustomAuthNested<A> withNewKafkaListenerAuthenticationCustomAuthLike(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConfiguration instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration getConfiguration();
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration buildConfiguration();
    public A withConfiguration(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration configuration);
    public java.lang.Boolean hasConfiguration();
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.ConfigurationNested<A> withNewConfiguration();
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.ConfigurationNested<A> withNewConfigurationLike(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration item);
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.ConfigurationNested<A> editConfiguration();
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.ConfigurationNested<A> editOrNewConfiguration();
    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.ConfigurationNested<A> editOrNewConfigurationLike(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration item);
    public A addToNetworkPolicyPeers(int index,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item);
    public A setToNetworkPolicyPeers(int index,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item);
    public A addToNetworkPolicyPeers(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... items);
    public A addAllToNetworkPolicyPeers(java.util.Collection<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> items);
    public A removeFromNetworkPolicyPeers(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... items);
    public A removeAllFromNetworkPolicyPeers(java.util.Collection<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> items);
    public java.util.List<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> getNetworkPolicyPeers();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer getNetworkPolicyPeer(int index);
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer getFirstNetworkPolicyPeer();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer getLastNetworkPolicyPeer();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer getMatchingNetworkPolicyPeer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> predicate);
    public java.lang.Boolean hasMatchingNetworkPolicyPeer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> predicate);
    public A withNetworkPolicyPeers(java.util.List<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> networkPolicyPeers);
    public A withNetworkPolicyPeers(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... networkPolicyPeers);
    public java.lang.Boolean hasNetworkPolicyPeers();
      
  /**
   * Configures a listener to use OAuth authentication.
   */
  public interface KafkaListenerAuthenticationOAuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluent<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<N>> {

            public N and();
            public N endKafkaListenerAuthenticationOAuth();    }


      
  /**
   * Configures a listener to use mutual TLS authentication.
   */
  public interface KafkaListenerAuthenticationTlsAuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsFluent<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<N>> {

            public N and();
            public N endKafkaListenerAuthenticationTlsAuth();    }


      
  /**
   * Configures a listener to use SASL SCRAM-SHA-512 for authentication.
   */
  public interface KafkaListenerAuthenticationScramSha512AuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Fluent<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>> {

            public N and();
            public N endKafkaListenerAuthenticationScramSha512Auth();    }


      
  /**
   * Configures a listener to use custom authentication.
   */
  public interface KafkaListenerAuthenticationCustomAuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationCustomAuthNested<N>> {

            public N and();
            public N endKafkaListenerAuthenticationCustomAuth();    }


      
  /**
   * Configures Kafka listeners
   */
  public interface ConfigurationNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluent<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.ConfigurationNested<N>> {

            public N and();
            public N endConfiguration();    }


}
