package io.strimzi.api.kafka.model.listener.arraylistener;

import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth;
import java.lang.String;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Builder;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomBuilder;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512FluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsFluentImpl;
import java.util.Collection;
import java.lang.Object;

  
  /**
   * Configures the external listener which exposes Kafka outside of Kubernetes / OpenShift
   */
  public class GenericKafkaListenerFluentImpl<A extends io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent<A> {

    private java.lang.String name;
    private int port;
    private io.strimzi.api.kafka.model.listener.arraylistener.KafkaListenerType type;
    private boolean tls;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication,?> auth;
    private io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBuilder configuration;
    private java.util.List<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> networkPolicyPeers;

    public GenericKafkaListenerFluentImpl() {
    }

    public GenericKafkaListenerFluentImpl(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListener instance) {
        this.withName(instance.getName());
        
        this.withPort(instance.getPort());
        
        this.withType(instance.getType());
        
        this.withTls(instance.isTls());
        
        this.withAuth(instance.getAuth());
        
        this.withConfiguration(instance.getConfiguration());
        
        this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
    }

    public java.lang.String getName() {
        return this.name;
    }

    public A withName(java.lang.String name) {
        this.name=name; return (A) this;
    }

    public java.lang.Boolean hasName() {
        return this.name != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String original) {
        return (A)withName(new String(original));
    }

    public int getPort() {
        return this.port;
    }

    public A withPort(int port) {
        this.port=port; return (A) this;
    }

    public java.lang.Boolean hasPort() {
        return true;
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.KafkaListenerType getType() {
        return this.type;
    }

    public A withType(io.strimzi.api.kafka.model.listener.arraylistener.KafkaListenerType type) {
        this.type=type; return (A) this;
    }

    public java.lang.Boolean hasType() {
        return this.type != null;
    }

    public boolean isTls() {
        return this.tls;
    }

    public A withTls(boolean tls) {
        this.tls=tls; return (A) this;
    }

    public java.lang.Boolean hasTls() {
        return true;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAuth instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication getAuth() {
        return this.auth!=null?this.auth.build():null;
    }

    public io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication buildAuth() {
        return this.auth!=null?this.auth.build():null;
    }

    public A withAuth(io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication auth) {
        _visitables.get("auth").remove(this.auth);
        if (auth instanceof io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth){ this.auth= new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthBuilder((io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth)auth); _visitables.get("auth").add(this.auth);}
        if (auth instanceof io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls){ this.auth= new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsBuilder((io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls)auth); _visitables.get("auth").add(this.auth);}
        if (auth instanceof io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512){ this.auth= new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Builder((io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512)auth); _visitables.get("auth").add(this.auth);}
        if (auth instanceof io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom){ this.auth= new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomBuilder((io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom)auth); _visitables.get("auth").add(this.auth);}
        return (A) this;
    }

    public java.lang.Boolean hasAuth() {
        return this.auth != null;
    }

    public A withKafkaListenerAuthenticationOAuth(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth kafkaListenerAuthenticationOAuth) {
        _visitables.get("auth").remove(this.auth);
        if (kafkaListenerAuthenticationOAuth!=null){ this.auth= new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthBuilder(kafkaListenerAuthenticationOAuth); _visitables.get("auth").add(this.auth);} return (A) this;
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuth() {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluentImpl.KafkaListenerAuthenticationOAuthNestedImpl();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuthLike(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth item) {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluentImpl.KafkaListenerAuthenticationOAuthNestedImpl(item);
    }

    public A withKafkaListenerAuthenticationTlsAuth(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls kafkaListenerAuthenticationTlsAuth) {
        _visitables.get("auth").remove(this.auth);
        if (kafkaListenerAuthenticationTlsAuth!=null){ this.auth= new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsBuilder(kafkaListenerAuthenticationTlsAuth); _visitables.get("auth").add(this.auth);} return (A) this;
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuth() {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluentImpl.KafkaListenerAuthenticationTlsAuthNestedImpl();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuthLike(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls item) {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluentImpl.KafkaListenerAuthenticationTlsAuthNestedImpl(item);
    }

    public A withKafkaListenerAuthenticationScramSha512Auth(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512 kafkaListenerAuthenticationScramSha512Auth) {
        _visitables.get("auth").remove(this.auth);
        if (kafkaListenerAuthenticationScramSha512Auth!=null){ this.auth= new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Builder(kafkaListenerAuthenticationScramSha512Auth); _visitables.get("auth").add(this.auth);} return (A) this;
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512Auth() {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluentImpl.KafkaListenerAuthenticationScramSha512AuthNestedImpl();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512AuthLike(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512 item) {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluentImpl.KafkaListenerAuthenticationScramSha512AuthNestedImpl(item);
    }

    public A withKafkaListenerAuthenticationCustomAuth(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom kafkaListenerAuthenticationCustomAuth) {
        _visitables.get("auth").remove(this.auth);
        if (kafkaListenerAuthenticationCustomAuth!=null){ this.auth= new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomBuilder(kafkaListenerAuthenticationCustomAuth); _visitables.get("auth").add(this.auth);} return (A) this;
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationCustomAuthNested<A> withNewKafkaListenerAuthenticationCustomAuth() {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluentImpl.KafkaListenerAuthenticationCustomAuthNestedImpl();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationCustomAuthNested<A> withNewKafkaListenerAuthenticationCustomAuthLike(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom item) {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluentImpl.KafkaListenerAuthenticationCustomAuthNestedImpl(item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConfiguration instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration getConfiguration() {
        return this.configuration!=null?this.configuration.build():null;
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration buildConfiguration() {
        return this.configuration!=null?this.configuration.build():null;
    }

    public A withConfiguration(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration configuration) {
        _visitables.get("configuration").remove(this.configuration);
        if (configuration!=null){ this.configuration= new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBuilder(configuration); _visitables.get("configuration").add(this.configuration);} return (A) this;
    }

    public java.lang.Boolean hasConfiguration() {
        return this.configuration != null;
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.ConfigurationNested<A> withNewConfiguration() {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluentImpl.ConfigurationNestedImpl();
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.ConfigurationNested<A> withNewConfigurationLike(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration item) {
        return new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluentImpl.ConfigurationNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.ConfigurationNested<A> editConfiguration() {
        return withNewConfigurationLike(getConfiguration());
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.ConfigurationNested<A> editOrNewConfiguration() {
        return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBuilder().build());
    }

    public io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.ConfigurationNested<A> editOrNewConfigurationLike(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration item) {
        return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): item);
    }

    public A addToNetworkPolicyPeers(int index,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item) {
        if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer>();}
        this.networkPolicyPeers.add(index, item);
        return (A)this;
    }

    public A setToNetworkPolicyPeers(int index,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item) {
        if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer>();}
        this.networkPolicyPeers.set(index, item); return (A)this;
    }

    public A addToNetworkPolicyPeers(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... items) {
        if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer>();}
        for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item : items) {this.networkPolicyPeers.add(item);} return (A)this;
    }

    public A addAllToNetworkPolicyPeers(java.util.Collection<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> items) {
        if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer>();}
        for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item : items) {this.networkPolicyPeers.add(item);} return (A)this;
    }

    public A removeFromNetworkPolicyPeers(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... items) {
        for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item : items) {if (this.networkPolicyPeers!= null){ this.networkPolicyPeers.remove(item);}} return (A)this;
    }

    public A removeAllFromNetworkPolicyPeers(java.util.Collection<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> items) {
        for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item : items) {if (this.networkPolicyPeers!= null){ this.networkPolicyPeers.remove(item);}} return (A)this;
    }

    public java.util.List<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> getNetworkPolicyPeers() {
        return this.networkPolicyPeers;
    }

    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer getNetworkPolicyPeer(int index) {
        return this.networkPolicyPeers.get(index);
    }

    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer getFirstNetworkPolicyPeer() {
        return this.networkPolicyPeers.get(0);
    }

    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer getLastNetworkPolicyPeer() {
        return this.networkPolicyPeers.get(networkPolicyPeers.size() - 1);
    }

    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer getMatchingNetworkPolicyPeer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> predicate) {
        for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item: networkPolicyPeers) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingNetworkPolicyPeer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> predicate) {
        for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item: networkPolicyPeers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNetworkPolicyPeers(java.util.List<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> networkPolicyPeers) {
        if (this.networkPolicyPeers != null) { _visitables.get("networkPolicyPeers").removeAll(this.networkPolicyPeers);}
        if (networkPolicyPeers != null) {this.networkPolicyPeers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer>(); for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item : networkPolicyPeers){this.addToNetworkPolicyPeers(item);}} else { this.networkPolicyPeers = null;} return (A) this;
    }

    public A withNetworkPolicyPeers(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... networkPolicyPeers) {
        if (this.networkPolicyPeers != null) {this.networkPolicyPeers.clear();}
        if (networkPolicyPeers != null) {for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item :networkPolicyPeers){ this.addToNetworkPolicyPeers(item);}} return (A) this;
    }

    public java.lang.Boolean hasNetworkPolicyPeers() {
        return networkPolicyPeers != null && !networkPolicyPeers.isEmpty();
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GenericKafkaListenerFluentImpl that = (GenericKafkaListenerFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (port != that.port) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        if (tls != that.tls) return false;
        if (auth != null ? !auth.equals(that.auth) :that.auth != null) return false;
        if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
        if (networkPolicyPeers != null ? !networkPolicyPeers.equals(that.networkPolicyPeers) :that.networkPolicyPeers != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  port,  type,  tls,  auth,  configuration,  networkPolicyPeers,  super.hashCode());
    }

      
  /**
   * Configures a listener to use OAuth authentication.
   */
  public class KafkaListenerAuthenticationOAuthNestedImpl<N> extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluentImpl<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<N>> implements io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthBuilder builder;

            KafkaListenerAuthenticationOAuthNestedImpl(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth item) {
                this.builder = new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthBuilder(this, item);
                        
            }

            KafkaListenerAuthenticationOAuthNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthBuilder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerFluentImpl.this.withAuth(builder.build());
            }

            public N endKafkaListenerAuthenticationOAuth() {
                return and();
            }
    }


      
  /**
   * Configures a listener to use mutual TLS authentication.
   */
  public class KafkaListenerAuthenticationTlsAuthNestedImpl<N> extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsFluentImpl<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<N>> implements io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsBuilder builder;

            KafkaListenerAuthenticationTlsAuthNestedImpl(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls item) {
                this.builder = new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsBuilder(this, item);
                        
            }

            KafkaListenerAuthenticationTlsAuthNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsBuilder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerFluentImpl.this.withAuth(builder.build());
            }

            public N endKafkaListenerAuthenticationTlsAuth() {
                return and();
            }
    }


      
  /**
   * Configures a listener to use SASL SCRAM-SHA-512 for authentication.
   */
  public class KafkaListenerAuthenticationScramSha512AuthNestedImpl<N> extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512FluentImpl<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>> implements io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Builder builder;

            KafkaListenerAuthenticationScramSha512AuthNestedImpl(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512 item) {
                this.builder = new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Builder(this, item);
                        
            }

            KafkaListenerAuthenticationScramSha512AuthNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Builder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerFluentImpl.this.withAuth(builder.build());
            }

            public N endKafkaListenerAuthenticationScramSha512Auth() {
                return and();
            }
    }


      
  /**
   * Configures a listener to use custom authentication.
   */
  public class KafkaListenerAuthenticationCustomAuthNestedImpl<N> extends io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluentImpl<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationCustomAuthNested<N>> implements io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.KafkaListenerAuthenticationCustomAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomBuilder builder;

            KafkaListenerAuthenticationCustomAuthNestedImpl(io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom item) {
                this.builder = new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomBuilder(this, item);
                        
            }

            KafkaListenerAuthenticationCustomAuthNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomBuilder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerFluentImpl.this.withAuth(builder.build());
            }

            public N endKafkaListenerAuthenticationCustomAuth() {
                return and();
            }
    }


      
  /**
   * Configures Kafka listeners
   */
  public class ConfigurationNestedImpl<N> extends io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationFluentImpl<io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.ConfigurationNested<N>> implements io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBuilder builder;

            ConfigurationNestedImpl(io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfiguration item) {
                this.builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBuilder(this, item);
                        
            }

            ConfigurationNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.listener.arraylistener.GenericKafkaListenerConfigurationBuilder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerFluentImpl.this.withConfiguration(builder.build());
            }

            public N endConfiguration() {
                return and();
            }
    }


}
