package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConditionBuilder extends io.strimzi.api.kafka.model.status.ConditionFluentImpl<io.strimzi.api.kafka.model.status.ConditionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.status.Condition,io.strimzi.api.kafka.model.status.ConditionBuilder> {

    io.strimzi.api.kafka.model.status.ConditionFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ConditionBuilder() {
        this(true);
    }

    public ConditionBuilder(java.lang.Boolean validationEnabled) {
        this(new Condition(), validationEnabled);
    }

    public ConditionBuilder(io.strimzi.api.kafka.model.status.ConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public ConditionBuilder(io.strimzi.api.kafka.model.status.ConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Condition(), validationEnabled);
    }

    public ConditionBuilder(io.strimzi.api.kafka.model.status.ConditionFluent<?> fluent,io.strimzi.api.kafka.model.status.Condition instance) {
        this(fluent, instance, true);
    }

    public ConditionBuilder(io.strimzi.api.kafka.model.status.ConditionFluent<?> fluent,io.strimzi.api.kafka.model.status.Condition instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withStatus(instance.getStatus());
        
        fluent.withReason(instance.getReason());
        
        fluent.withMessage(instance.getMessage());
        
        fluent.withType(instance.getType());
        
        fluent.withLastTransitionTime(instance.getLastTransitionTime());
        
        this.validationEnabled = validationEnabled; 
    }

    public ConditionBuilder(io.strimzi.api.kafka.model.status.Condition instance) {
        this(instance,true);
    }

    public ConditionBuilder(io.strimzi.api.kafka.model.status.Condition instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withStatus(instance.getStatus());
        
        this.withReason(instance.getReason());
        
        this.withMessage(instance.getMessage());
        
        this.withType(instance.getType());
        
        this.withLastTransitionTime(instance.getLastTransitionTime());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.status.Condition build() {
        Condition buildable = new Condition();
        buildable.setStatus(fluent.getStatus());
        buildable.setReason(fluent.getReason());
        buildable.setMessage(fluent.getMessage());
        buildable.setType(fluent.getType());
        buildable.setLastTransitionTime(fluent.getLastTransitionTime());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConditionBuilder that = (ConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
