package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a status of the Kafka Bridge resource
   */
  public class KafkaBridgeStatusBuilder extends io.strimzi.api.kafka.model.status.KafkaBridgeStatusFluentImpl<io.strimzi.api.kafka.model.status.KafkaBridgeStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.status.KafkaBridgeStatus,io.strimzi.api.kafka.model.status.KafkaBridgeStatusBuilder> {

    io.strimzi.api.kafka.model.status.KafkaBridgeStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaBridgeStatusBuilder() {
        this(true);
    }

    public KafkaBridgeStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaBridgeStatus(), validationEnabled);
    }

    public KafkaBridgeStatusBuilder(io.strimzi.api.kafka.model.status.KafkaBridgeStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaBridgeStatusBuilder(io.strimzi.api.kafka.model.status.KafkaBridgeStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaBridgeStatus(), validationEnabled);
    }

    public KafkaBridgeStatusBuilder(io.strimzi.api.kafka.model.status.KafkaBridgeStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaBridgeStatus instance) {
        this(fluent, instance, true);
    }

    public KafkaBridgeStatusBuilder(io.strimzi.api.kafka.model.status.KafkaBridgeStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaBridgeStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withUrl(instance.getUrl());
        
        fluent.withReplicas(instance.getReplicas());
        
        fluent.withLabelSelector(instance.getLabelSelector());
        
        fluent.withConditions(instance.getConditions());
        
        fluent.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeStatusBuilder(io.strimzi.api.kafka.model.status.KafkaBridgeStatus instance) {
        this(instance,true);
    }

    public KafkaBridgeStatusBuilder(io.strimzi.api.kafka.model.status.KafkaBridgeStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withUrl(instance.getUrl());
        
        this.withReplicas(instance.getReplicas());
        
        this.withLabelSelector(instance.getLabelSelector());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.status.KafkaBridgeStatus build() {
        KafkaBridgeStatus buildable = new KafkaBridgeStatus();
        buildable.setConditions(fluent.getConditions());
        buildable.setObservedGeneration(fluent.getObservedGeneration());
        buildable.setUrl(fluent.getUrl());
        buildable.setReplicas(fluent.getReplicas());
        buildable.setLabelSelector(fluent.getLabelSelector());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBridgeStatusBuilder that = (KafkaBridgeStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
