package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder;
import io.strimzi.api.kafka.model.connect.ConnectorPluginFluent;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.connect.ConnectorPlugin;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

  
  /**
   * Represents a status of the Kafka Connect resource
   */
  public interface KafkaConnectStatusFluent<A extends io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent<A>> extends io.strimzi.api.kafka.model.status.StatusFluent<A> {


    public java.lang.String getUrl();
    public A withUrl(java.lang.String url);
    public java.lang.Boolean hasUrl();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUrl instead.
     */
        public A withNewUrl(java.lang.String original);
    public A addToConnectorPlugins(int index,io.strimzi.api.kafka.model.connect.ConnectorPlugin item);
    public A setToConnectorPlugins(int index,io.strimzi.api.kafka.model.connect.ConnectorPlugin item);
    public A addToConnectorPlugins(io.strimzi.api.kafka.model.connect.ConnectorPlugin... items);
    public A addAllToConnectorPlugins(java.util.Collection<io.strimzi.api.kafka.model.connect.ConnectorPlugin> items);
    public A removeFromConnectorPlugins(io.strimzi.api.kafka.model.connect.ConnectorPlugin... items);
    public A removeAllFromConnectorPlugins(java.util.Collection<io.strimzi.api.kafka.model.connect.ConnectorPlugin> items);
    public A removeMatchingFromConnectorPlugins(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConnectorPlugins instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.connect.ConnectorPlugin> getConnectorPlugins();
    public java.util.List<io.strimzi.api.kafka.model.connect.ConnectorPlugin> buildConnectorPlugins();
    public io.strimzi.api.kafka.model.connect.ConnectorPlugin buildConnectorPlugin(int index);
    public io.strimzi.api.kafka.model.connect.ConnectorPlugin buildFirstConnectorPlugin();
    public io.strimzi.api.kafka.model.connect.ConnectorPlugin buildLastConnectorPlugin();
    public io.strimzi.api.kafka.model.connect.ConnectorPlugin buildMatchingConnectorPlugin(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder> predicate);
    public java.lang.Boolean hasMatchingConnectorPlugin(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder> predicate);
    public A withConnectorPlugins(java.util.List<io.strimzi.api.kafka.model.connect.ConnectorPlugin> connectorPlugins);
    public A withConnectorPlugins(io.strimzi.api.kafka.model.connect.ConnectorPlugin... connectorPlugins);
    public java.lang.Boolean hasConnectorPlugins();
    public io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<A> addNewConnectorPlugin();
    public io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<A> addNewConnectorPluginLike(io.strimzi.api.kafka.model.connect.ConnectorPlugin item);
    public io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<A> setNewConnectorPluginLike(int index,io.strimzi.api.kafka.model.connect.ConnectorPlugin item);
    public io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<A> editConnectorPlugin(int index);
    public io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<A> editFirstConnectorPlugin();
    public io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<A> editLastConnectorPlugin();
    public io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<A> editMatchingConnectorPlugin(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder> predicate);
    public int getReplicas();
    public A withReplicas(int replicas);
    public java.lang.Boolean hasReplicas();
    public java.lang.String getLabelSelector();
    public A withLabelSelector(java.lang.String labelSelector);
    public java.lang.Boolean hasLabelSelector();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLabelSelector instead.
     */
        public A withNewLabelSelector(java.lang.String original);
      
  /**
   * Representation a connector plugin available in the Kafka Connect deployment
   */
  public interface ConnectorPluginsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.connect.ConnectorPluginFluent<io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<N>> {

            public N and();
            public N endConnectorPlugin();    }


}
