package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.connect.ConnectorPlugin;
import io.strimzi.api.kafka.model.connect.ConnectorPluginFluentImpl;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

  
  /**
   * Represents a status of the Kafka Connect resource
   */
  public class KafkaConnectStatusFluentImpl<A extends io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent<A>> extends io.strimzi.api.kafka.model.status.StatusFluentImpl<A> implements io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent<A> {

    private java.lang.String url;
    private java.util.List<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder> connectorPlugins;
    private int replicas;
    private java.lang.String labelSelector;

    public KafkaConnectStatusFluentImpl() {
    }

    public KafkaConnectStatusFluentImpl(io.strimzi.api.kafka.model.status.KafkaConnectStatus instance) {
        this.withUrl(instance.getUrl());
        
        this.withConnectorPlugins(instance.getConnectorPlugins());
        
        this.withReplicas(instance.getReplicas());
        
        this.withLabelSelector(instance.getLabelSelector());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public java.lang.String getUrl() {
        return this.url;
    }

    public A withUrl(java.lang.String url) {
        this.url=url; return (A) this;
    }

    public java.lang.Boolean hasUrl() {
        return this.url != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUrl instead.
     */
        public A withNewUrl(java.lang.String original) {
        return (A)withUrl(new String(original));
    }

    public A addToConnectorPlugins(int index,io.strimzi.api.kafka.model.connect.ConnectorPlugin item) {
        if (this.connectorPlugins == null) {this.connectorPlugins = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder>();}
        io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder builder = new io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder(item);_visitables.get("connectorPlugins").add(index >= 0 ? index : _visitables.get("connectorPlugins").size(), builder);this.connectorPlugins.add(index >= 0 ? index : connectorPlugins.size(), builder); return (A)this;
    }

    public A setToConnectorPlugins(int index,io.strimzi.api.kafka.model.connect.ConnectorPlugin item) {
        if (this.connectorPlugins == null) {this.connectorPlugins = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder>();}
        io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder builder = new io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder(item);
        if (index < 0 || index >= _visitables.get("connectorPlugins").size()) { _visitables.get("connectorPlugins").add(builder); } else { _visitables.get("connectorPlugins").set(index, builder);}
        if (index < 0 || index >= connectorPlugins.size()) { connectorPlugins.add(builder); } else { connectorPlugins.set(index, builder);}
         return (A)this;
    }

    public A addToConnectorPlugins(io.strimzi.api.kafka.model.connect.ConnectorPlugin... items) {
        if (this.connectorPlugins == null) {this.connectorPlugins = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder>();}
        for (io.strimzi.api.kafka.model.connect.ConnectorPlugin item : items) {io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder builder = new io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder(item);_visitables.get("connectorPlugins").add(builder);this.connectorPlugins.add(builder);} return (A)this;
    }

    public A addAllToConnectorPlugins(java.util.Collection<io.strimzi.api.kafka.model.connect.ConnectorPlugin> items) {
        if (this.connectorPlugins == null) {this.connectorPlugins = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder>();}
        for (io.strimzi.api.kafka.model.connect.ConnectorPlugin item : items) {io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder builder = new io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder(item);_visitables.get("connectorPlugins").add(builder);this.connectorPlugins.add(builder);} return (A)this;
    }

    public A removeFromConnectorPlugins(io.strimzi.api.kafka.model.connect.ConnectorPlugin... items) {
        for (io.strimzi.api.kafka.model.connect.ConnectorPlugin item : items) {io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder builder = new io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder(item);_visitables.get("connectorPlugins").remove(builder);if (this.connectorPlugins != null) {this.connectorPlugins.remove(builder);}} return (A)this;
    }

    public A removeAllFromConnectorPlugins(java.util.Collection<io.strimzi.api.kafka.model.connect.ConnectorPlugin> items) {
        for (io.strimzi.api.kafka.model.connect.ConnectorPlugin item : items) {io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder builder = new io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder(item);_visitables.get("connectorPlugins").remove(builder);if (this.connectorPlugins != null) {this.connectorPlugins.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConnectorPlugins(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder> predicate) {
        if (connectorPlugins == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder> each = connectorPlugins.iterator();
        final List visitables = _visitables.get("connectorPlugins");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConnectorPlugins instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.connect.ConnectorPlugin> getConnectorPlugins() {
        return build(connectorPlugins);
    }

    public java.util.List<io.strimzi.api.kafka.model.connect.ConnectorPlugin> buildConnectorPlugins() {
        return build(connectorPlugins);
    }

    public io.strimzi.api.kafka.model.connect.ConnectorPlugin buildConnectorPlugin(int index) {
        return this.connectorPlugins.get(index).build();
    }

    public io.strimzi.api.kafka.model.connect.ConnectorPlugin buildFirstConnectorPlugin() {
        return this.connectorPlugins.get(0).build();
    }

    public io.strimzi.api.kafka.model.connect.ConnectorPlugin buildLastConnectorPlugin() {
        return this.connectorPlugins.get(connectorPlugins.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.connect.ConnectorPlugin buildMatchingConnectorPlugin(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder> predicate) {
        for (io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder item: connectorPlugins) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingConnectorPlugin(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder> predicate) {
        for (io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder item: connectorPlugins) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConnectorPlugins(java.util.List<io.strimzi.api.kafka.model.connect.ConnectorPlugin> connectorPlugins) {
        if (this.connectorPlugins != null) { _visitables.get("connectorPlugins").removeAll(this.connectorPlugins);}
        if (connectorPlugins != null) {this.connectorPlugins = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder>(); for (io.strimzi.api.kafka.model.connect.ConnectorPlugin item : connectorPlugins){this.addToConnectorPlugins(item);}} else { this.connectorPlugins = null;} return (A) this;
    }

    public A withConnectorPlugins(io.strimzi.api.kafka.model.connect.ConnectorPlugin... connectorPlugins) {
        if (this.connectorPlugins != null) {this.connectorPlugins.clear();}
        if (connectorPlugins != null) {for (io.strimzi.api.kafka.model.connect.ConnectorPlugin item :connectorPlugins){ this.addToConnectorPlugins(item);}} return (A) this;
    }

    public java.lang.Boolean hasConnectorPlugins() {
        return connectorPlugins != null && !connectorPlugins.isEmpty();
    }

    public io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<A> addNewConnectorPlugin() {
        return new io.strimzi.api.kafka.model.status.KafkaConnectStatusFluentImpl.ConnectorPluginsNestedImpl();
    }

    public io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<A> addNewConnectorPluginLike(io.strimzi.api.kafka.model.connect.ConnectorPlugin item) {
        return new io.strimzi.api.kafka.model.status.KafkaConnectStatusFluentImpl.ConnectorPluginsNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<A> setNewConnectorPluginLike(int index,io.strimzi.api.kafka.model.connect.ConnectorPlugin item) {
        return new io.strimzi.api.kafka.model.status.KafkaConnectStatusFluentImpl.ConnectorPluginsNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<A> editConnectorPlugin(int index) {
        if (connectorPlugins.size() <= index) throw new RuntimeException("Can't edit connectorPlugins. Index exceeds size.");
        return setNewConnectorPluginLike(index, buildConnectorPlugin(index));
    }

    public io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<A> editFirstConnectorPlugin() {
        if (connectorPlugins.size() == 0) throw new RuntimeException("Can't edit first connectorPlugins. The list is empty.");
        return setNewConnectorPluginLike(0, buildConnectorPlugin(0));
    }

    public io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<A> editLastConnectorPlugin() {
        int index = connectorPlugins.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last connectorPlugins. The list is empty.");
        return setNewConnectorPluginLike(index, buildConnectorPlugin(index));
    }

    public io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<A> editMatchingConnectorPlugin(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder> predicate) {
        int index = -1;
        for (int i=0;i<connectorPlugins.size();i++) { 
        if (predicate.test(connectorPlugins.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching connectorPlugins. No match found.");
        return setNewConnectorPluginLike(index, buildConnectorPlugin(index));
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas=replicas; return (A) this;
    }

    public java.lang.Boolean hasReplicas() {
        return true;
    }

    public java.lang.String getLabelSelector() {
        return this.labelSelector;
    }

    public A withLabelSelector(java.lang.String labelSelector) {
        this.labelSelector=labelSelector; return (A) this;
    }

    public java.lang.Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLabelSelector instead.
     */
        public A withNewLabelSelector(java.lang.String original) {
        return (A)withLabelSelector(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectStatusFluentImpl that = (KafkaConnectStatusFluentImpl) o;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        if (connectorPlugins != null ? !connectorPlugins.equals(that.connectorPlugins) :that.connectorPlugins != null) return false;
        if (replicas != that.replicas) return false;
        if (labelSelector != null ? !labelSelector.equals(that.labelSelector) :that.labelSelector != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(url,  connectorPlugins,  replicas,  labelSelector,  super.hashCode());
    }

      
  /**
   * Representation a connector plugin available in the Kafka Connect deployment
   */
  public class ConnectorPluginsNestedImpl<N> extends io.strimzi.api.kafka.model.connect.ConnectorPluginFluentImpl<io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<N>> implements io.strimzi.api.kafka.model.status.KafkaConnectStatusFluent.ConnectorPluginsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder builder;
        private final int index;

            ConnectorPluginsNestedImpl(int index,io.strimzi.api.kafka.model.connect.ConnectorPlugin item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder(this, item);
                        
            }

            ConnectorPluginsNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectStatusFluentImpl.this.setToConnectorPlugins(index,builder.build());
            }

            public N endConnectorPlugin() {
                return and();
            }
    }


}
