package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a status of the KafkaConnector resource
   */
  public class KafkaConnectorStatusBuilder extends io.strimzi.api.kafka.model.status.KafkaConnectorStatusFluentImpl<io.strimzi.api.kafka.model.status.KafkaConnectorStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.status.KafkaConnectorStatus,io.strimzi.api.kafka.model.status.KafkaConnectorStatusBuilder> {

    io.strimzi.api.kafka.model.status.KafkaConnectorStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaConnectorStatusBuilder() {
        this(true);
    }

    public KafkaConnectorStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaConnectorStatus(), validationEnabled);
    }

    public KafkaConnectorStatusBuilder(io.strimzi.api.kafka.model.status.KafkaConnectorStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaConnectorStatusBuilder(io.strimzi.api.kafka.model.status.KafkaConnectorStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaConnectorStatus(), validationEnabled);
    }

    public KafkaConnectorStatusBuilder(io.strimzi.api.kafka.model.status.KafkaConnectorStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaConnectorStatus instance) {
        this(fluent, instance, true);
    }

    public KafkaConnectorStatusBuilder(io.strimzi.api.kafka.model.status.KafkaConnectorStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaConnectorStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConnectorStatus(instance.getConnectorStatus());
        
        fluent.withTasksMax(instance.getTasksMax());
        
        fluent.withTopics(instance.getTopics());
        
        fluent.withConditions(instance.getConditions());
        
        fluent.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectorStatusBuilder(io.strimzi.api.kafka.model.status.KafkaConnectorStatus instance) {
        this(instance,true);
    }

    public KafkaConnectorStatusBuilder(io.strimzi.api.kafka.model.status.KafkaConnectorStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConnectorStatus(instance.getConnectorStatus());
        
        this.withTasksMax(instance.getTasksMax());
        
        this.withTopics(instance.getTopics());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.status.KafkaConnectorStatus build() {
        KafkaConnectorStatus buildable = new KafkaConnectorStatus();
        buildable.setConditions(fluent.getConditions());
        buildable.setObservedGeneration(fluent.getObservedGeneration());
        buildable.setConnectorStatus(fluent.getConnectorStatus());
        buildable.setTasksMax(fluent.getTasksMax());
        buildable.setTopics(fluent.getTopics());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectorStatusBuilder that = (KafkaConnectorStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
