package io.strimzi.api.kafka.model.status;

import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

  
  /**
   * Represents a status of the KafkaConnector resource
   */
  public class KafkaConnectorStatusFluentImpl<A extends io.strimzi.api.kafka.model.status.KafkaConnectorStatusFluent<A>> extends io.strimzi.api.kafka.model.status.StatusFluentImpl<A> implements io.strimzi.api.kafka.model.status.KafkaConnectorStatusFluent<A> {

    private java.util.Map<java.lang.String,java.lang.Object> connectorStatus;
    private int tasksMax;
    private java.util.List<java.lang.String> topics;

    public KafkaConnectorStatusFluentImpl() {
    }

    public KafkaConnectorStatusFluentImpl(io.strimzi.api.kafka.model.status.KafkaConnectorStatus instance) {
        this.withConnectorStatus(instance.getConnectorStatus());
        
        this.withTasksMax(instance.getTasksMax());
        
        this.withTopics(instance.getTopics());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public A addToConnectorStatus(java.lang.String key,java.lang.Object value) {
        if(this.connectorStatus == null && key != null && value != null) { this.connectorStatus = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(key != null && value != null) {this.connectorStatus.put(key, value);} return (A)this;
    }

    public A addToConnectorStatus(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.connectorStatus == null && map != null) { this.connectorStatus = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(map != null) { this.connectorStatus.putAll(map);} return (A)this;
    }

    public A removeFromConnectorStatus(java.lang.String key) {
        if(this.connectorStatus == null) { return (A) this; }
        if(key != null && this.connectorStatus != null) {this.connectorStatus.remove(key);} return (A)this;
    }

    public A removeFromConnectorStatus(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.connectorStatus == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.connectorStatus != null){this.connectorStatus.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.Object> getConnectorStatus() {
        return this.connectorStatus;
    }

    public <K,V>A withConnectorStatus(java.util.Map<java.lang.String,java.lang.Object> connectorStatus) {
        if (connectorStatus == null) { this.connectorStatus =  null;} else {this.connectorStatus = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(connectorStatus);} return (A) this;
    }

    public java.lang.Boolean hasConnectorStatus() {
        return this.connectorStatus != null;
    }

    public int getTasksMax() {
        return this.tasksMax;
    }

    public A withTasksMax(int tasksMax) {
        this.tasksMax=tasksMax; return (A) this;
    }

    public java.lang.Boolean hasTasksMax() {
        return true;
    }

    public A addToTopics(int index,java.lang.String item) {
        if (this.topics == null) {this.topics = new java.util.ArrayList<java.lang.String>();}
        this.topics.add(index, item);
        return (A)this;
    }

    public A setToTopics(int index,java.lang.String item) {
        if (this.topics == null) {this.topics = new java.util.ArrayList<java.lang.String>();}
        this.topics.set(index, item); return (A)this;
    }

    public A addToTopics(java.lang.String... items) {
        if (this.topics == null) {this.topics = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.topics.add(item);} return (A)this;
    }

    public A addAllToTopics(java.util.Collection<java.lang.String> items) {
        if (this.topics == null) {this.topics = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.topics.add(item);} return (A)this;
    }

    public A removeFromTopics(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.topics!= null){ this.topics.remove(item);}} return (A)this;
    }

    public A removeAllFromTopics(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.topics!= null){ this.topics.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getTopics() {
        return this.topics;
    }

    public java.lang.String getTopic(int index) {
        return this.topics.get(index);
    }

    public java.lang.String getFirstTopic() {
        return this.topics.get(0);
    }

    public java.lang.String getLastTopic() {
        return this.topics.get(topics.size() - 1);
    }

    public java.lang.String getMatchingTopic(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: topics) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingTopic(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: topics) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTopics(java.util.List<java.lang.String> topics) {
        if (this.topics != null) { _visitables.get("topics").removeAll(this.topics);}
        if (topics != null) {this.topics = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : topics){this.addToTopics(item);}} else { this.topics = null;} return (A) this;
    }

    public A withTopics(java.lang.String... topics) {
        if (this.topics != null) {this.topics.clear();}
        if (topics != null) {for (java.lang.String item :topics){ this.addToTopics(item);}} return (A) this;
    }

    public java.lang.Boolean hasTopics() {
        return topics != null && !topics.isEmpty();
    }

    public A addNewTopic(java.lang.String original) {
        return (A)addToTopics(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectorStatusFluentImpl that = (KafkaConnectorStatusFluentImpl) o;
        if (connectorStatus != null ? !connectorStatus.equals(that.connectorStatus) :that.connectorStatus != null) return false;
        if (tasksMax != that.tasksMax) return false;
        if (topics != null ? !topics.equals(that.topics) :that.topics != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(connectorStatus,  tasksMax,  topics,  super.hashCode());
    }

}
