package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a status of the Kafka MirrorMaker 2.0 resource
   */
  public class KafkaMirrorMaker2StatusBuilder extends io.strimzi.api.kafka.model.status.KafkaMirrorMaker2StatusFluentImpl<io.strimzi.api.kafka.model.status.KafkaMirrorMaker2StatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.status.KafkaMirrorMaker2Status,io.strimzi.api.kafka.model.status.KafkaMirrorMaker2StatusBuilder> {

    io.strimzi.api.kafka.model.status.KafkaMirrorMaker2StatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaMirrorMaker2StatusBuilder() {
        this(true);
    }

    public KafkaMirrorMaker2StatusBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaMirrorMaker2Status(), validationEnabled);
    }

    public KafkaMirrorMaker2StatusBuilder(io.strimzi.api.kafka.model.status.KafkaMirrorMaker2StatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMaker2StatusBuilder(io.strimzi.api.kafka.model.status.KafkaMirrorMaker2StatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMaker2Status(), validationEnabled);
    }

    public KafkaMirrorMaker2StatusBuilder(io.strimzi.api.kafka.model.status.KafkaMirrorMaker2StatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaMirrorMaker2Status instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMaker2StatusBuilder(io.strimzi.api.kafka.model.status.KafkaMirrorMaker2StatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaMirrorMaker2Status instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConnectors(instance.getConnectors());
        
        fluent.withUrl(instance.getUrl());
        
        fluent.withConnectorPlugins(instance.getConnectorPlugins());
        
        fluent.withReplicas(instance.getReplicas());
        
        fluent.withLabelSelector(instance.getLabelSelector());
        
        fluent.withConditions(instance.getConditions());
        
        fluent.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker2StatusBuilder(io.strimzi.api.kafka.model.status.KafkaMirrorMaker2Status instance) {
        this(instance,true);
    }

    public KafkaMirrorMaker2StatusBuilder(io.strimzi.api.kafka.model.status.KafkaMirrorMaker2Status instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConnectors(instance.getConnectors());
        
        this.withUrl(instance.getUrl());
        
        this.withConnectorPlugins(instance.getConnectorPlugins());
        
        this.withReplicas(instance.getReplicas());
        
        this.withLabelSelector(instance.getLabelSelector());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.status.KafkaMirrorMaker2Status build() {
        KafkaMirrorMaker2Status buildable = new KafkaMirrorMaker2Status();
        buildable.setConditions(fluent.getConditions());
        buildable.setObservedGeneration(fluent.getObservedGeneration());
        buildable.setUrl(fluent.getUrl());
        buildable.setConnectorPlugins(fluent.getConnectorPlugins());
        buildable.setReplicas(fluent.getReplicas());
        buildable.setLabelSelector(fluent.getLabelSelector());
        buildable.setConnectors(fluent.getConnectors());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMaker2StatusBuilder that = (KafkaMirrorMaker2StatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
