package io.strimzi.api.kafka.model.status;

import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.function.Predicate;

  
  /**
   * Represents a status of the Kafka MirrorMaker 2.0 resource
   */
  public class KafkaMirrorMaker2StatusFluentImpl<A extends io.strimzi.api.kafka.model.status.KafkaMirrorMaker2StatusFluent<A>> extends io.strimzi.api.kafka.model.status.KafkaConnectStatusFluentImpl<A> implements io.strimzi.api.kafka.model.status.KafkaMirrorMaker2StatusFluent<A> {

    private java.util.List<java.util.Map<java.lang.String,java.lang.Object>> connectors;

    public KafkaMirrorMaker2StatusFluentImpl() {
    }

    public KafkaMirrorMaker2StatusFluentImpl(io.strimzi.api.kafka.model.status.KafkaMirrorMaker2Status instance) {
        this.withConnectors(instance.getConnectors());
        
        this.withUrl(instance.getUrl());
        
        this.withConnectorPlugins(instance.getConnectorPlugins());
        
        this.withReplicas(instance.getReplicas());
        
        this.withLabelSelector(instance.getLabelSelector());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public A addToConnectors(int index,java.util.Map<java.lang.String,java.lang.Object> item) {
        if (this.connectors == null) {this.connectors = new java.util.ArrayList<java.util.Map<java.lang.String,java.lang.Object>>();}
        this.connectors.add(index, item);
        return (A)this;
    }

    public A setToConnectors(int index,java.util.Map<java.lang.String,java.lang.Object> item) {
        if (this.connectors == null) {this.connectors = new java.util.ArrayList<java.util.Map<java.lang.String,java.lang.Object>>();}
        this.connectors.set(index, item); return (A)this;
    }

    public A addToConnectors(java.util.Map<java.lang.String,java.lang.Object>... items) {
        if (this.connectors == null) {this.connectors = new java.util.ArrayList<java.util.Map<java.lang.String,java.lang.Object>>();}
        for (java.util.Map<java.lang.String,java.lang.Object> item : items) {this.connectors.add(item);} return (A)this;
    }

    public A addAllToConnectors(java.util.Collection<java.util.Map<java.lang.String,java.lang.Object>> items) {
        if (this.connectors == null) {this.connectors = new java.util.ArrayList<java.util.Map<java.lang.String,java.lang.Object>>();}
        for (java.util.Map<java.lang.String,java.lang.Object> item : items) {this.connectors.add(item);} return (A)this;
    }

    public A removeFromConnectors(java.util.Map<java.lang.String,java.lang.Object>... items) {
        for (java.util.Map<java.lang.String,java.lang.Object> item : items) {if (this.connectors!= null){ this.connectors.remove(item);}} return (A)this;
    }

    public A removeAllFromConnectors(java.util.Collection<java.util.Map<java.lang.String,java.lang.Object>> items) {
        for (java.util.Map<java.lang.String,java.lang.Object> item : items) {if (this.connectors!= null){ this.connectors.remove(item);}} return (A)this;
    }

    public java.util.List<java.util.Map<java.lang.String,java.lang.Object>> getConnectors() {
        return this.connectors;
    }

    public java.util.Map<java.lang.String,java.lang.Object> getConnector(int index) {
        return this.connectors.get(index);
    }

    public java.util.Map<java.lang.String,java.lang.Object> getFirstConnector() {
        return this.connectors.get(0);
    }

    public java.util.Map<java.lang.String,java.lang.Object> getLastConnector() {
        return this.connectors.get(connectors.size() - 1);
    }

    public java.util.Map<java.lang.String,java.lang.Object> getMatchingConnector(java.util.function.Predicate<java.util.Map<java.lang.String,java.lang.Object>> predicate) {
        for (java.util.Map<java.lang.String,java.lang.Object> item: connectors) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingConnector(java.util.function.Predicate<java.util.Map<java.lang.String,java.lang.Object>> predicate) {
        for (java.util.Map<java.lang.String,java.lang.Object> item: connectors) { if(predicate.test(item)){ return true;} } return false;
    }

    public <K,V>A withConnectors(java.util.List<java.util.Map<java.lang.String,java.lang.Object>> connectors) {
        if (this.connectors != null) { _visitables.get("connectors").removeAll(this.connectors);}
        if (connectors != null) {this.connectors = new java.util.ArrayList<java.util.Map<java.lang.String,java.lang.Object>>(); for (java.util.Map<java.lang.String,java.lang.Object> item : connectors){this.addToConnectors(item);}} else { this.connectors = null;} return (A) this;
    }

    public A withConnectors(java.util.Map<java.lang.String,java.lang.Object>... connectors) {
        if (this.connectors != null) {this.connectors.clear();}
        if (connectors != null) {for (java.util.Map<java.lang.String,java.lang.Object> item :connectors){ this.addToConnectors(item);}} return (A) this;
    }

    public java.lang.Boolean hasConnectors() {
        return connectors != null && !connectors.isEmpty();
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMaker2StatusFluentImpl that = (KafkaMirrorMaker2StatusFluentImpl) o;
        if (connectors != null ? !connectors.equals(that.connectors) :that.connectors != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(connectors,  super.hashCode());
    }

}
