package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a status of the Kafka MirrorMaker resource
   */
  public class KafkaMirrorMakerStatusBuilder extends io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusFluentImpl<io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus,io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusBuilder> {

    io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaMirrorMakerStatusBuilder() {
        this(true);
    }

    public KafkaMirrorMakerStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaMirrorMakerStatus(), validationEnabled);
    }

    public KafkaMirrorMakerStatusBuilder(io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMakerStatusBuilder(io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMakerStatus(), validationEnabled);
    }

    public KafkaMirrorMakerStatusBuilder(io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMakerStatusBuilder(io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withReplicas(instance.getReplicas());
        
        fluent.withLabelSelector(instance.getLabelSelector());
        
        fluent.withConditions(instance.getConditions());
        
        fluent.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerStatusBuilder(io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus instance) {
        this(instance,true);
    }

    public KafkaMirrorMakerStatusBuilder(io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withReplicas(instance.getReplicas());
        
        this.withLabelSelector(instance.getLabelSelector());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus build() {
        KafkaMirrorMakerStatus buildable = new KafkaMirrorMakerStatus();
        buildable.setConditions(fluent.getConditions());
        buildable.setObservedGeneration(fluent.getObservedGeneration());
        buildable.setReplicas(fluent.getReplicas());
        buildable.setLabelSelector(fluent.getLabelSelector());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMakerStatusBuilder that = (KafkaMirrorMakerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
