package io.strimzi.api.kafka.model.status;

import java.lang.Deprecated;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

  
  /**
   * Represents a status of the Kafka MirrorMaker resource
   */
  public class KafkaMirrorMakerStatusFluentImpl<A extends io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusFluent<A>> extends io.strimzi.api.kafka.model.status.StatusFluentImpl<A> implements io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatusFluent<A> {

    private int replicas;
    private java.lang.String labelSelector;

    public KafkaMirrorMakerStatusFluentImpl() {
    }

    public KafkaMirrorMakerStatusFluentImpl(io.strimzi.api.kafka.model.status.KafkaMirrorMakerStatus instance) {
        this.withReplicas(instance.getReplicas());
        
        this.withLabelSelector(instance.getLabelSelector());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas=replicas; return (A) this;
    }

    public java.lang.Boolean hasReplicas() {
        return true;
    }

    public java.lang.String getLabelSelector() {
        return this.labelSelector;
    }

    public A withLabelSelector(java.lang.String labelSelector) {
        this.labelSelector=labelSelector; return (A) this;
    }

    public java.lang.Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLabelSelector instead.
     */
        public A withNewLabelSelector(java.lang.String original) {
        return (A)withLabelSelector(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMakerStatusFluentImpl that = (KafkaMirrorMakerStatusFluentImpl) o;
        if (replicas != that.replicas) return false;
        if (labelSelector != null ? !labelSelector.equals(that.labelSelector) :that.labelSelector != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(replicas,  labelSelector,  super.hashCode());
    }

}
