package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a status of the Kafka Rebalance resource
   */
  public class KafkaRebalanceStatusBuilder extends io.strimzi.api.kafka.model.status.KafkaRebalanceStatusFluentImpl<io.strimzi.api.kafka.model.status.KafkaRebalanceStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.status.KafkaRebalanceStatus,io.strimzi.api.kafka.model.status.KafkaRebalanceStatusBuilder> {

    io.strimzi.api.kafka.model.status.KafkaRebalanceStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaRebalanceStatusBuilder() {
        this(true);
    }

    public KafkaRebalanceStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaRebalanceStatus(), validationEnabled);
    }

    public KafkaRebalanceStatusBuilder(io.strimzi.api.kafka.model.status.KafkaRebalanceStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaRebalanceStatusBuilder(io.strimzi.api.kafka.model.status.KafkaRebalanceStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaRebalanceStatus(), validationEnabled);
    }

    public KafkaRebalanceStatusBuilder(io.strimzi.api.kafka.model.status.KafkaRebalanceStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaRebalanceStatus instance) {
        this(fluent, instance, true);
    }

    public KafkaRebalanceStatusBuilder(io.strimzi.api.kafka.model.status.KafkaRebalanceStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaRebalanceStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSessionId(instance.getSessionId());
        
        fluent.withOptimizationResult(instance.getOptimizationResult());
        
        fluent.withConditions(instance.getConditions());
        
        fluent.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaRebalanceStatusBuilder(io.strimzi.api.kafka.model.status.KafkaRebalanceStatus instance) {
        this(instance,true);
    }

    public KafkaRebalanceStatusBuilder(io.strimzi.api.kafka.model.status.KafkaRebalanceStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withSessionId(instance.getSessionId());
        
        this.withOptimizationResult(instance.getOptimizationResult());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.status.KafkaRebalanceStatus build() {
        KafkaRebalanceStatus buildable = new KafkaRebalanceStatus();
        buildable.setConditions(fluent.getConditions());
        buildable.setObservedGeneration(fluent.getObservedGeneration());
        buildable.setSessionId(fluent.getSessionId());
        buildable.setOptimizationResult(fluent.getOptimizationResult());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaRebalanceStatusBuilder that = (KafkaRebalanceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
