package io.strimzi.api.kafka.model.status;

import java.lang.Deprecated;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

  
  /**
   * Represents a status of the Kafka Rebalance resource
   */
  public class KafkaRebalanceStatusFluentImpl<A extends io.strimzi.api.kafka.model.status.KafkaRebalanceStatusFluent<A>> extends io.strimzi.api.kafka.model.status.StatusFluentImpl<A> implements io.strimzi.api.kafka.model.status.KafkaRebalanceStatusFluent<A> {

    private java.lang.String sessionId;
    private java.util.Map<java.lang.String,java.lang.Object> optimizationResult;

    public KafkaRebalanceStatusFluentImpl() {
    }

    public KafkaRebalanceStatusFluentImpl(io.strimzi.api.kafka.model.status.KafkaRebalanceStatus instance) {
        this.withSessionId(instance.getSessionId());
        
        this.withOptimizationResult(instance.getOptimizationResult());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public java.lang.String getSessionId() {
        return this.sessionId;
    }

    public A withSessionId(java.lang.String sessionId) {
        this.sessionId=sessionId; return (A) this;
    }

    public java.lang.Boolean hasSessionId() {
        return this.sessionId != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withSessionId instead.
     */
        public A withNewSessionId(java.lang.String original) {
        return (A)withSessionId(new String(original));
    }

    public A addToOptimizationResult(java.lang.String key,java.lang.Object value) {
        if(this.optimizationResult == null && key != null && value != null) { this.optimizationResult = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(key != null && value != null) {this.optimizationResult.put(key, value);} return (A)this;
    }

    public A addToOptimizationResult(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.optimizationResult == null && map != null) { this.optimizationResult = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(map != null) { this.optimizationResult.putAll(map);} return (A)this;
    }

    public A removeFromOptimizationResult(java.lang.String key) {
        if(this.optimizationResult == null) { return (A) this; }
        if(key != null && this.optimizationResult != null) {this.optimizationResult.remove(key);} return (A)this;
    }

    public A removeFromOptimizationResult(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.optimizationResult == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.optimizationResult != null){this.optimizationResult.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.Object> getOptimizationResult() {
        return this.optimizationResult;
    }

    public <K,V>A withOptimizationResult(java.util.Map<java.lang.String,java.lang.Object> optimizationResult) {
        if (optimizationResult == null) { this.optimizationResult =  null;} else {this.optimizationResult = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(optimizationResult);} return (A) this;
    }

    public java.lang.Boolean hasOptimizationResult() {
        return this.optimizationResult != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaRebalanceStatusFluentImpl that = (KafkaRebalanceStatusFluentImpl) o;
        if (sessionId != null ? !sessionId.equals(that.sessionId) :that.sessionId != null) return false;
        if (optimizationResult != null ? !optimizationResult.equals(that.optimizationResult) :that.optimizationResult != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(sessionId,  optimizationResult,  super.hashCode());
    }

}
