package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a status of the Kafka resource
   */
  public class KafkaStatusBuilder extends io.strimzi.api.kafka.model.status.KafkaStatusFluentImpl<io.strimzi.api.kafka.model.status.KafkaStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.status.KafkaStatus,io.strimzi.api.kafka.model.status.KafkaStatusBuilder> {

    io.strimzi.api.kafka.model.status.KafkaStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaStatusBuilder() {
        this(true);
    }

    public KafkaStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaStatus(), validationEnabled);
    }

    public KafkaStatusBuilder(io.strimzi.api.kafka.model.status.KafkaStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaStatusBuilder(io.strimzi.api.kafka.model.status.KafkaStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaStatus(), validationEnabled);
    }

    public KafkaStatusBuilder(io.strimzi.api.kafka.model.status.KafkaStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaStatus instance) {
        this(fluent, instance, true);
    }

    public KafkaStatusBuilder(io.strimzi.api.kafka.model.status.KafkaStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withListeners(instance.getListeners());
        
        fluent.withClusterId(instance.getClusterId());
        
        fluent.withConditions(instance.getConditions());
        
        fluent.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaStatusBuilder(io.strimzi.api.kafka.model.status.KafkaStatus instance) {
        this(instance,true);
    }

    public KafkaStatusBuilder(io.strimzi.api.kafka.model.status.KafkaStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withListeners(instance.getListeners());
        
        this.withClusterId(instance.getClusterId());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.status.KafkaStatus build() {
        KafkaStatus buildable = new KafkaStatus();
        buildable.setConditions(fluent.getConditions());
        buildable.setObservedGeneration(fluent.getObservedGeneration());
        buildable.setListeners(fluent.getListeners());
        buildable.setClusterId(fluent.getClusterId());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaStatusBuilder that = (KafkaStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
