package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

  
  /**
   * Represents a status of the Kafka resource
   */
  public class KafkaStatusFluentImpl<A extends io.strimzi.api.kafka.model.status.KafkaStatusFluent<A>> extends io.strimzi.api.kafka.model.status.StatusFluentImpl<A> implements io.strimzi.api.kafka.model.status.KafkaStatusFluent<A> {

    private java.util.List<io.strimzi.api.kafka.model.status.ListenerStatusBuilder> listeners;
    private java.lang.String clusterId;

    public KafkaStatusFluentImpl() {
    }

    public KafkaStatusFluentImpl(io.strimzi.api.kafka.model.status.KafkaStatus instance) {
        this.withListeners(instance.getListeners());
        
        this.withClusterId(instance.getClusterId());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public A addToListeners(int index,io.strimzi.api.kafka.model.status.ListenerStatus item) {
        if (this.listeners == null) {this.listeners = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ListenerStatusBuilder>();}
        io.strimzi.api.kafka.model.status.ListenerStatusBuilder builder = new io.strimzi.api.kafka.model.status.ListenerStatusBuilder(item);_visitables.get("listeners").add(index >= 0 ? index : _visitables.get("listeners").size(), builder);this.listeners.add(index >= 0 ? index : listeners.size(), builder); return (A)this;
    }

    public A setToListeners(int index,io.strimzi.api.kafka.model.status.ListenerStatus item) {
        if (this.listeners == null) {this.listeners = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ListenerStatusBuilder>();}
        io.strimzi.api.kafka.model.status.ListenerStatusBuilder builder = new io.strimzi.api.kafka.model.status.ListenerStatusBuilder(item);
        if (index < 0 || index >= _visitables.get("listeners").size()) { _visitables.get("listeners").add(builder); } else { _visitables.get("listeners").set(index, builder);}
        if (index < 0 || index >= listeners.size()) { listeners.add(builder); } else { listeners.set(index, builder);}
         return (A)this;
    }

    public A addToListeners(io.strimzi.api.kafka.model.status.ListenerStatus... items) {
        if (this.listeners == null) {this.listeners = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ListenerStatusBuilder>();}
        for (io.strimzi.api.kafka.model.status.ListenerStatus item : items) {io.strimzi.api.kafka.model.status.ListenerStatusBuilder builder = new io.strimzi.api.kafka.model.status.ListenerStatusBuilder(item);_visitables.get("listeners").add(builder);this.listeners.add(builder);} return (A)this;
    }

    public A addAllToListeners(java.util.Collection<io.strimzi.api.kafka.model.status.ListenerStatus> items) {
        if (this.listeners == null) {this.listeners = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ListenerStatusBuilder>();}
        for (io.strimzi.api.kafka.model.status.ListenerStatus item : items) {io.strimzi.api.kafka.model.status.ListenerStatusBuilder builder = new io.strimzi.api.kafka.model.status.ListenerStatusBuilder(item);_visitables.get("listeners").add(builder);this.listeners.add(builder);} return (A)this;
    }

    public A removeFromListeners(io.strimzi.api.kafka.model.status.ListenerStatus... items) {
        for (io.strimzi.api.kafka.model.status.ListenerStatus item : items) {io.strimzi.api.kafka.model.status.ListenerStatusBuilder builder = new io.strimzi.api.kafka.model.status.ListenerStatusBuilder(item);_visitables.get("listeners").remove(builder);if (this.listeners != null) {this.listeners.remove(builder);}} return (A)this;
    }

    public A removeAllFromListeners(java.util.Collection<io.strimzi.api.kafka.model.status.ListenerStatus> items) {
        for (io.strimzi.api.kafka.model.status.ListenerStatus item : items) {io.strimzi.api.kafka.model.status.ListenerStatusBuilder builder = new io.strimzi.api.kafka.model.status.ListenerStatusBuilder(item);_visitables.get("listeners").remove(builder);if (this.listeners != null) {this.listeners.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromListeners(java.util.function.Predicate<io.strimzi.api.kafka.model.status.ListenerStatusBuilder> predicate) {
        if (listeners == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.status.ListenerStatusBuilder> each = listeners.iterator();
        final List visitables = _visitables.get("listeners");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.status.ListenerStatusBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildListeners instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.status.ListenerStatus> getListeners() {
        return build(listeners);
    }

    public java.util.List<io.strimzi.api.kafka.model.status.ListenerStatus> buildListeners() {
        return build(listeners);
    }

    public io.strimzi.api.kafka.model.status.ListenerStatus buildListener(int index) {
        return this.listeners.get(index).build();
    }

    public io.strimzi.api.kafka.model.status.ListenerStatus buildFirstListener() {
        return this.listeners.get(0).build();
    }

    public io.strimzi.api.kafka.model.status.ListenerStatus buildLastListener() {
        return this.listeners.get(listeners.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.status.ListenerStatus buildMatchingListener(java.util.function.Predicate<io.strimzi.api.kafka.model.status.ListenerStatusBuilder> predicate) {
        for (io.strimzi.api.kafka.model.status.ListenerStatusBuilder item: listeners) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingListener(java.util.function.Predicate<io.strimzi.api.kafka.model.status.ListenerStatusBuilder> predicate) {
        for (io.strimzi.api.kafka.model.status.ListenerStatusBuilder item: listeners) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withListeners(java.util.List<io.strimzi.api.kafka.model.status.ListenerStatus> listeners) {
        if (this.listeners != null) { _visitables.get("listeners").removeAll(this.listeners);}
        if (listeners != null) {this.listeners = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ListenerStatusBuilder>(); for (io.strimzi.api.kafka.model.status.ListenerStatus item : listeners){this.addToListeners(item);}} else { this.listeners = null;} return (A) this;
    }

    public A withListeners(io.strimzi.api.kafka.model.status.ListenerStatus... listeners) {
        if (this.listeners != null) {this.listeners.clear();}
        if (listeners != null) {for (io.strimzi.api.kafka.model.status.ListenerStatus item :listeners){ this.addToListeners(item);}} return (A) this;
    }

    public java.lang.Boolean hasListeners() {
        return listeners != null && !listeners.isEmpty();
    }

    public io.strimzi.api.kafka.model.status.KafkaStatusFluent.ListenersNested<A> addNewListener() {
        return new io.strimzi.api.kafka.model.status.KafkaStatusFluentImpl.ListenersNestedImpl();
    }

    public io.strimzi.api.kafka.model.status.KafkaStatusFluent.ListenersNested<A> addNewListenerLike(io.strimzi.api.kafka.model.status.ListenerStatus item) {
        return new io.strimzi.api.kafka.model.status.KafkaStatusFluentImpl.ListenersNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.status.KafkaStatusFluent.ListenersNested<A> setNewListenerLike(int index,io.strimzi.api.kafka.model.status.ListenerStatus item) {
        return new io.strimzi.api.kafka.model.status.KafkaStatusFluentImpl.ListenersNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.status.KafkaStatusFluent.ListenersNested<A> editListener(int index) {
        if (listeners.size() <= index) throw new RuntimeException("Can't edit listeners. Index exceeds size.");
        return setNewListenerLike(index, buildListener(index));
    }

    public io.strimzi.api.kafka.model.status.KafkaStatusFluent.ListenersNested<A> editFirstListener() {
        if (listeners.size() == 0) throw new RuntimeException("Can't edit first listeners. The list is empty.");
        return setNewListenerLike(0, buildListener(0));
    }

    public io.strimzi.api.kafka.model.status.KafkaStatusFluent.ListenersNested<A> editLastListener() {
        int index = listeners.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last listeners. The list is empty.");
        return setNewListenerLike(index, buildListener(index));
    }

    public io.strimzi.api.kafka.model.status.KafkaStatusFluent.ListenersNested<A> editMatchingListener(java.util.function.Predicate<io.strimzi.api.kafka.model.status.ListenerStatusBuilder> predicate) {
        int index = -1;
        for (int i=0;i<listeners.size();i++) { 
        if (predicate.test(listeners.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching listeners. No match found.");
        return setNewListenerLike(index, buildListener(index));
    }

    public java.lang.String getClusterId() {
        return this.clusterId;
    }

    public A withClusterId(java.lang.String clusterId) {
        this.clusterId=clusterId; return (A) this;
    }

    public java.lang.Boolean hasClusterId() {
        return this.clusterId != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClusterId instead.
     */
        public A withNewClusterId(java.lang.String original) {
        return (A)withClusterId(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaStatusFluentImpl that = (KafkaStatusFluentImpl) o;
        if (listeners != null ? !listeners.equals(that.listeners) :that.listeners != null) return false;
        if (clusterId != null ? !clusterId.equals(that.clusterId) :that.clusterId != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(listeners,  clusterId,  super.hashCode());
    }

      
  /**
   * Represents a single listener
   */
  public class ListenersNestedImpl<N> extends io.strimzi.api.kafka.model.status.ListenerStatusFluentImpl<io.strimzi.api.kafka.model.status.KafkaStatusFluent.ListenersNested<N>> implements io.strimzi.api.kafka.model.status.KafkaStatusFluent.ListenersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.status.ListenerStatusBuilder builder;
        private final int index;

            ListenersNestedImpl(int index,io.strimzi.api.kafka.model.status.ListenerStatus item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.status.ListenerStatusBuilder(this, item);
                        
            }

            ListenersNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.status.ListenerStatusBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaStatusFluentImpl.this.setToListeners(index,builder.build());
            }

            public N endListener() {
                return and();
            }
    }


}
