package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a status of the KafkaTopic resource
   */
  public class KafkaTopicStatusBuilder extends io.strimzi.api.kafka.model.status.KafkaTopicStatusFluentImpl<io.strimzi.api.kafka.model.status.KafkaTopicStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.status.KafkaTopicStatus,io.strimzi.api.kafka.model.status.KafkaTopicStatusBuilder> {

    io.strimzi.api.kafka.model.status.KafkaTopicStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaTopicStatusBuilder() {
        this(true);
    }

    public KafkaTopicStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaTopicStatus(), validationEnabled);
    }

    public KafkaTopicStatusBuilder(io.strimzi.api.kafka.model.status.KafkaTopicStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaTopicStatusBuilder(io.strimzi.api.kafka.model.status.KafkaTopicStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaTopicStatus(), validationEnabled);
    }

    public KafkaTopicStatusBuilder(io.strimzi.api.kafka.model.status.KafkaTopicStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaTopicStatus instance) {
        this(fluent, instance, true);
    }

    public KafkaTopicStatusBuilder(io.strimzi.api.kafka.model.status.KafkaTopicStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaTopicStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTopicName(instance.getTopicName());
        
        fluent.withConditions(instance.getConditions());
        
        fluent.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaTopicStatusBuilder(io.strimzi.api.kafka.model.status.KafkaTopicStatus instance) {
        this(instance,true);
    }

    public KafkaTopicStatusBuilder(io.strimzi.api.kafka.model.status.KafkaTopicStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withTopicName(instance.getTopicName());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.status.KafkaTopicStatus build() {
        KafkaTopicStatus buildable = new KafkaTopicStatus();
        buildable.setConditions(fluent.getConditions());
        buildable.setObservedGeneration(fluent.getObservedGeneration());
        buildable.setTopicName(fluent.getTopicName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaTopicStatusBuilder that = (KafkaTopicStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
