package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a status of the Kafka User resource
   */
  public class KafkaUserStatusBuilder extends io.strimzi.api.kafka.model.status.KafkaUserStatusFluentImpl<io.strimzi.api.kafka.model.status.KafkaUserStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.status.KafkaUserStatus,io.strimzi.api.kafka.model.status.KafkaUserStatusBuilder> {

    io.strimzi.api.kafka.model.status.KafkaUserStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaUserStatusBuilder() {
        this(true);
    }

    public KafkaUserStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaUserStatus(), validationEnabled);
    }

    public KafkaUserStatusBuilder(io.strimzi.api.kafka.model.status.KafkaUserStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaUserStatusBuilder(io.strimzi.api.kafka.model.status.KafkaUserStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaUserStatus(), validationEnabled);
    }

    public KafkaUserStatusBuilder(io.strimzi.api.kafka.model.status.KafkaUserStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaUserStatus instance) {
        this(fluent, instance, true);
    }

    public KafkaUserStatusBuilder(io.strimzi.api.kafka.model.status.KafkaUserStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.KafkaUserStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withUsername(instance.getUsername());
        
        fluent.withSecret(instance.getSecret());
        
        fluent.withConditions(instance.getConditions());
        
        fluent.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaUserStatusBuilder(io.strimzi.api.kafka.model.status.KafkaUserStatus instance) {
        this(instance,true);
    }

    public KafkaUserStatusBuilder(io.strimzi.api.kafka.model.status.KafkaUserStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withUsername(instance.getUsername());
        
        this.withSecret(instance.getSecret());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.status.KafkaUserStatus build() {
        KafkaUserStatus buildable = new KafkaUserStatus();
        buildable.setConditions(fluent.getConditions());
        buildable.setObservedGeneration(fluent.getObservedGeneration());
        buildable.setUsername(fluent.getUsername());
        buildable.setSecret(fluent.getSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaUserStatusBuilder that = (KafkaUserStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
