package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a single address of particular listener
   */
  public class ListenerAddressBuilder extends io.strimzi.api.kafka.model.status.ListenerAddressFluentImpl<io.strimzi.api.kafka.model.status.ListenerAddressBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.status.ListenerAddress,io.strimzi.api.kafka.model.status.ListenerAddressBuilder> {

    io.strimzi.api.kafka.model.status.ListenerAddressFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ListenerAddressBuilder() {
        this(true);
    }

    public ListenerAddressBuilder(java.lang.Boolean validationEnabled) {
        this(new ListenerAddress(), validationEnabled);
    }

    public ListenerAddressBuilder(io.strimzi.api.kafka.model.status.ListenerAddressFluent<?> fluent) {
        this(fluent, true);
    }

    public ListenerAddressBuilder(io.strimzi.api.kafka.model.status.ListenerAddressFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ListenerAddress(), validationEnabled);
    }

    public ListenerAddressBuilder(io.strimzi.api.kafka.model.status.ListenerAddressFluent<?> fluent,io.strimzi.api.kafka.model.status.ListenerAddress instance) {
        this(fluent, instance, true);
    }

    public ListenerAddressBuilder(io.strimzi.api.kafka.model.status.ListenerAddressFluent<?> fluent,io.strimzi.api.kafka.model.status.ListenerAddress instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHost(instance.getHost());
        
        fluent.withPort(instance.getPort());
        
        this.validationEnabled = validationEnabled; 
    }

    public ListenerAddressBuilder(io.strimzi.api.kafka.model.status.ListenerAddress instance) {
        this(instance,true);
    }

    public ListenerAddressBuilder(io.strimzi.api.kafka.model.status.ListenerAddress instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withHost(instance.getHost());
        
        this.withPort(instance.getPort());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.status.ListenerAddress build() {
        ListenerAddress buildable = new ListenerAddress();
        buildable.setHost(fluent.getHost());
        buildable.setPort(fluent.getPort());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ListenerAddressBuilder that = (ListenerAddressBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
