package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a single listener
   */
  public class ListenerStatusBuilder extends io.strimzi.api.kafka.model.status.ListenerStatusFluentImpl<io.strimzi.api.kafka.model.status.ListenerStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.status.ListenerStatus,io.strimzi.api.kafka.model.status.ListenerStatusBuilder> {

    io.strimzi.api.kafka.model.status.ListenerStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ListenerStatusBuilder() {
        this(true);
    }

    public ListenerStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new ListenerStatus(), validationEnabled);
    }

    public ListenerStatusBuilder(io.strimzi.api.kafka.model.status.ListenerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ListenerStatusBuilder(io.strimzi.api.kafka.model.status.ListenerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ListenerStatus(), validationEnabled);
    }

    public ListenerStatusBuilder(io.strimzi.api.kafka.model.status.ListenerStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.ListenerStatus instance) {
        this(fluent, instance, true);
    }

    public ListenerStatusBuilder(io.strimzi.api.kafka.model.status.ListenerStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.ListenerStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName());
        
        fluent.withAddresses(instance.getAddresses());
        
        fluent.withCertificates(instance.getCertificates());
        
        this.validationEnabled = validationEnabled; 
    }

    public ListenerStatusBuilder(io.strimzi.api.kafka.model.status.ListenerStatus instance) {
        this(instance,true);
    }

    public ListenerStatusBuilder(io.strimzi.api.kafka.model.status.ListenerStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName());
        
        this.withAddresses(instance.getAddresses());
        
        this.withCertificates(instance.getCertificates());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.status.ListenerStatus build() {
        ListenerStatus buildable = new ListenerStatus();
        buildable.setName(fluent.getName());
        buildable.setAddresses(fluent.getAddresses());
        buildable.setCertificates(fluent.getCertificates());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ListenerStatusBuilder that = (ListenerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
