package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

  
  /**
   * Represents a single listener
   */
  public class ListenerStatusFluentImpl<A extends io.strimzi.api.kafka.model.status.ListenerStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.status.ListenerStatusFluent<A> {

    private java.lang.String name;
    private java.util.List<io.strimzi.api.kafka.model.status.ListenerAddressBuilder> addresses;
    private java.util.List<java.lang.String> certificates;

    public ListenerStatusFluentImpl() {
    }

    public ListenerStatusFluentImpl(io.strimzi.api.kafka.model.status.ListenerStatus instance) {
        this.withName(instance.getName());
        
        this.withAddresses(instance.getAddresses());
        
        this.withCertificates(instance.getCertificates());
    }

    public java.lang.String getName() {
        return this.name;
    }

    public A withName(java.lang.String name) {
        this.name=name; return (A) this;
    }

    public java.lang.Boolean hasName() {
        return this.name != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String original) {
        return (A)withName(new String(original));
    }

    public A addToAddresses(int index,io.strimzi.api.kafka.model.status.ListenerAddress item) {
        if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ListenerAddressBuilder>();}
        io.strimzi.api.kafka.model.status.ListenerAddressBuilder builder = new io.strimzi.api.kafka.model.status.ListenerAddressBuilder(item);_visitables.get("addresses").add(index >= 0 ? index : _visitables.get("addresses").size(), builder);this.addresses.add(index >= 0 ? index : addresses.size(), builder); return (A)this;
    }

    public A setToAddresses(int index,io.strimzi.api.kafka.model.status.ListenerAddress item) {
        if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ListenerAddressBuilder>();}
        io.strimzi.api.kafka.model.status.ListenerAddressBuilder builder = new io.strimzi.api.kafka.model.status.ListenerAddressBuilder(item);
        if (index < 0 || index >= _visitables.get("addresses").size()) { _visitables.get("addresses").add(builder); } else { _visitables.get("addresses").set(index, builder);}
        if (index < 0 || index >= addresses.size()) { addresses.add(builder); } else { addresses.set(index, builder);}
         return (A)this;
    }

    public A addToAddresses(io.strimzi.api.kafka.model.status.ListenerAddress... items) {
        if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ListenerAddressBuilder>();}
        for (io.strimzi.api.kafka.model.status.ListenerAddress item : items) {io.strimzi.api.kafka.model.status.ListenerAddressBuilder builder = new io.strimzi.api.kafka.model.status.ListenerAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
    }

    public A addAllToAddresses(java.util.Collection<io.strimzi.api.kafka.model.status.ListenerAddress> items) {
        if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ListenerAddressBuilder>();}
        for (io.strimzi.api.kafka.model.status.ListenerAddress item : items) {io.strimzi.api.kafka.model.status.ListenerAddressBuilder builder = new io.strimzi.api.kafka.model.status.ListenerAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
    }

    public A removeFromAddresses(io.strimzi.api.kafka.model.status.ListenerAddress... items) {
        for (io.strimzi.api.kafka.model.status.ListenerAddress item : items) {io.strimzi.api.kafka.model.status.ListenerAddressBuilder builder = new io.strimzi.api.kafka.model.status.ListenerAddressBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
    }

    public A removeAllFromAddresses(java.util.Collection<io.strimzi.api.kafka.model.status.ListenerAddress> items) {
        for (io.strimzi.api.kafka.model.status.ListenerAddress item : items) {io.strimzi.api.kafka.model.status.ListenerAddressBuilder builder = new io.strimzi.api.kafka.model.status.ListenerAddressBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAddresses(java.util.function.Predicate<io.strimzi.api.kafka.model.status.ListenerAddressBuilder> predicate) {
        if (addresses == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.status.ListenerAddressBuilder> each = addresses.iterator();
        final List visitables = _visitables.get("addresses");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.status.ListenerAddressBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAddresses instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.status.ListenerAddress> getAddresses() {
        return build(addresses);
    }

    public java.util.List<io.strimzi.api.kafka.model.status.ListenerAddress> buildAddresses() {
        return build(addresses);
    }

    public io.strimzi.api.kafka.model.status.ListenerAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public io.strimzi.api.kafka.model.status.ListenerAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public io.strimzi.api.kafka.model.status.ListenerAddress buildLastAddress() {
        return this.addresses.get(addresses.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.status.ListenerAddress buildMatchingAddress(java.util.function.Predicate<io.strimzi.api.kafka.model.status.ListenerAddressBuilder> predicate) {
        for (io.strimzi.api.kafka.model.status.ListenerAddressBuilder item: addresses) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingAddress(java.util.function.Predicate<io.strimzi.api.kafka.model.status.ListenerAddressBuilder> predicate) {
        for (io.strimzi.api.kafka.model.status.ListenerAddressBuilder item: addresses) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAddresses(java.util.List<io.strimzi.api.kafka.model.status.ListenerAddress> addresses) {
        if (this.addresses != null) { _visitables.get("addresses").removeAll(this.addresses);}
        if (addresses != null) {this.addresses = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ListenerAddressBuilder>(); for (io.strimzi.api.kafka.model.status.ListenerAddress item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
    }

    public A withAddresses(io.strimzi.api.kafka.model.status.ListenerAddress... addresses) {
        if (this.addresses != null) {this.addresses.clear();}
        if (addresses != null) {for (io.strimzi.api.kafka.model.status.ListenerAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
    }

    public java.lang.Boolean hasAddresses() {
        return addresses != null && !addresses.isEmpty();
    }

    public io.strimzi.api.kafka.model.status.ListenerStatusFluent.AddressesNested<A> addNewAddress() {
        return new io.strimzi.api.kafka.model.status.ListenerStatusFluentImpl.AddressesNestedImpl();
    }

    public io.strimzi.api.kafka.model.status.ListenerStatusFluent.AddressesNested<A> addNewAddressLike(io.strimzi.api.kafka.model.status.ListenerAddress item) {
        return new io.strimzi.api.kafka.model.status.ListenerStatusFluentImpl.AddressesNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.status.ListenerStatusFluent.AddressesNested<A> setNewAddressLike(int index,io.strimzi.api.kafka.model.status.ListenerAddress item) {
        return new io.strimzi.api.kafka.model.status.ListenerStatusFluentImpl.AddressesNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.status.ListenerStatusFluent.AddressesNested<A> editAddress(int index) {
        if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        return setNewAddressLike(index, buildAddress(index));
    }

    public io.strimzi.api.kafka.model.status.ListenerStatusFluent.AddressesNested<A> editFirstAddress() {
        if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
        return setNewAddressLike(0, buildAddress(0));
    }

    public io.strimzi.api.kafka.model.status.ListenerStatusFluent.AddressesNested<A> editLastAddress() {
        int index = addresses.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
        return setNewAddressLike(index, buildAddress(index));
    }

    public io.strimzi.api.kafka.model.status.ListenerStatusFluent.AddressesNested<A> editMatchingAddress(java.util.function.Predicate<io.strimzi.api.kafka.model.status.ListenerAddressBuilder> predicate) {
        int index = -1;
        for (int i=0;i<addresses.size();i++) { 
        if (predicate.test(addresses.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
        return setNewAddressLike(index, buildAddress(index));
    }

    public A addToCertificates(int index,java.lang.String item) {
        if (this.certificates == null) {this.certificates = new java.util.ArrayList<java.lang.String>();}
        this.certificates.add(index, item);
        return (A)this;
    }

    public A setToCertificates(int index,java.lang.String item) {
        if (this.certificates == null) {this.certificates = new java.util.ArrayList<java.lang.String>();}
        this.certificates.set(index, item); return (A)this;
    }

    public A addToCertificates(java.lang.String... items) {
        if (this.certificates == null) {this.certificates = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.certificates.add(item);} return (A)this;
    }

    public A addAllToCertificates(java.util.Collection<java.lang.String> items) {
        if (this.certificates == null) {this.certificates = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.certificates.add(item);} return (A)this;
    }

    public A removeFromCertificates(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.certificates!= null){ this.certificates.remove(item);}} return (A)this;
    }

    public A removeAllFromCertificates(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.certificates!= null){ this.certificates.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getCertificates() {
        return this.certificates;
    }

    public java.lang.String getCertificate(int index) {
        return this.certificates.get(index);
    }

    public java.lang.String getFirstCertificate() {
        return this.certificates.get(0);
    }

    public java.lang.String getLastCertificate() {
        return this.certificates.get(certificates.size() - 1);
    }

    public java.lang.String getMatchingCertificate(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: certificates) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingCertificate(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: certificates) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withCertificates(java.util.List<java.lang.String> certificates) {
        if (this.certificates != null) { _visitables.get("certificates").removeAll(this.certificates);}
        if (certificates != null) {this.certificates = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : certificates){this.addToCertificates(item);}} else { this.certificates = null;} return (A) this;
    }

    public A withCertificates(java.lang.String... certificates) {
        if (this.certificates != null) {this.certificates.clear();}
        if (certificates != null) {for (java.lang.String item :certificates){ this.addToCertificates(item);}} return (A) this;
    }

    public java.lang.Boolean hasCertificates() {
        return certificates != null && !certificates.isEmpty();
    }

    public A addNewCertificate(java.lang.String original) {
        return (A)addToCertificates(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ListenerStatusFluentImpl that = (ListenerStatusFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
        if (certificates != null ? !certificates.equals(that.certificates) :that.certificates != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  addresses,  certificates,  super.hashCode());
    }

      
  /**
   * Represents a single address of particular listener
   */
  public class AddressesNestedImpl<N> extends io.strimzi.api.kafka.model.status.ListenerAddressFluentImpl<io.strimzi.api.kafka.model.status.ListenerStatusFluent.AddressesNested<N>> implements io.strimzi.api.kafka.model.status.ListenerStatusFluent.AddressesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.status.ListenerAddressBuilder builder;
        private final int index;

            AddressesNestedImpl(int index,io.strimzi.api.kafka.model.status.ListenerAddress item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.status.ListenerAddressBuilder(this, item);
                        
            }

            AddressesNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.status.ListenerAddressBuilder(this);
                        
            }

            public N and() {
                return (N) ListenerStatusFluentImpl.this.setToAddresses(index,builder.build());
            }

            public N endAddress() {
                return and();
            }
    }


}
