package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

  
  /**
   * Represents a generic status which can be used across different resources
   */
  public class StatusFluentImpl<A extends io.strimzi.api.kafka.model.status.StatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.status.StatusFluent<A> {

    private java.util.List<io.strimzi.api.kafka.model.status.ConditionBuilder> conditions;
    private long observedGeneration;

    public StatusFluentImpl() {
    }

    public StatusFluentImpl(io.strimzi.api.kafka.model.status.Status instance) {
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public A addToConditions(int index,io.strimzi.api.kafka.model.status.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ConditionBuilder>();}
        io.strimzi.api.kafka.model.status.ConditionBuilder builder = new io.strimzi.api.kafka.model.status.ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.strimzi.api.kafka.model.status.Condition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ConditionBuilder>();}
        io.strimzi.api.kafka.model.status.ConditionBuilder builder = new io.strimzi.api.kafka.model.status.ConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(io.strimzi.api.kafka.model.status.Condition... items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ConditionBuilder>();}
        for (io.strimzi.api.kafka.model.status.Condition item : items) {io.strimzi.api.kafka.model.status.ConditionBuilder builder = new io.strimzi.api.kafka.model.status.ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(java.util.Collection<io.strimzi.api.kafka.model.status.Condition> items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ConditionBuilder>();}
        for (io.strimzi.api.kafka.model.status.Condition item : items) {io.strimzi.api.kafka.model.status.ConditionBuilder builder = new io.strimzi.api.kafka.model.status.ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.strimzi.api.kafka.model.status.Condition... items) {
        for (io.strimzi.api.kafka.model.status.Condition item : items) {io.strimzi.api.kafka.model.status.ConditionBuilder builder = new io.strimzi.api.kafka.model.status.ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(java.util.Collection<io.strimzi.api.kafka.model.status.Condition> items) {
        for (io.strimzi.api.kafka.model.status.Condition item : items) {io.strimzi.api.kafka.model.status.ConditionBuilder builder = new io.strimzi.api.kafka.model.status.ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(java.util.function.Predicate<io.strimzi.api.kafka.model.status.ConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.status.ConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.status.ConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConditions instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.status.Condition> getConditions() {
        return build(conditions);
    }

    public java.util.List<io.strimzi.api.kafka.model.status.Condition> buildConditions() {
        return build(conditions);
    }

    public io.strimzi.api.kafka.model.status.Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public io.strimzi.api.kafka.model.status.Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public io.strimzi.api.kafka.model.status.Condition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.status.Condition buildMatchingCondition(java.util.function.Predicate<io.strimzi.api.kafka.model.status.ConditionBuilder> predicate) {
        for (io.strimzi.api.kafka.model.status.ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.strimzi.api.kafka.model.status.ConditionBuilder> predicate) {
        for (io.strimzi.api.kafka.model.status.ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(java.util.List<io.strimzi.api.kafka.model.status.Condition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new java.util.ArrayList<io.strimzi.api.kafka.model.status.ConditionBuilder>(); for (io.strimzi.api.kafka.model.status.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.strimzi.api.kafka.model.status.Condition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.strimzi.api.kafka.model.status.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public java.lang.Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.strimzi.api.kafka.model.status.StatusFluent.ConditionsNested<A> addNewCondition() {
        return new io.strimzi.api.kafka.model.status.StatusFluentImpl.ConditionsNestedImpl();
    }

    public io.strimzi.api.kafka.model.status.StatusFluent.ConditionsNested<A> addNewConditionLike(io.strimzi.api.kafka.model.status.Condition item) {
        return new io.strimzi.api.kafka.model.status.StatusFluentImpl.ConditionsNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.status.StatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.strimzi.api.kafka.model.status.Condition item) {
        return new io.strimzi.api.kafka.model.status.StatusFluentImpl.ConditionsNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.status.StatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.strimzi.api.kafka.model.status.StatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.strimzi.api.kafka.model.status.StatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.strimzi.api.kafka.model.status.StatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.strimzi.api.kafka.model.status.ConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public java.lang.Boolean hasObservedGeneration() {
        return true;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StatusFluentImpl that = (StatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (observedGeneration != that.observedGeneration) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  observedGeneration,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends io.strimzi.api.kafka.model.status.ConditionFluentImpl<io.strimzi.api.kafka.model.status.StatusFluent.ConditionsNested<N>> implements io.strimzi.api.kafka.model.status.StatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.status.ConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,io.strimzi.api.kafka.model.status.Condition item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.status.ConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.status.ConditionBuilder(this);
                        
            }

            public N and() {
                return (N) StatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


}
