package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a status of the StrimziPodSet resource
   */
  public class StrimziPodSetStatusBuilder extends io.strimzi.api.kafka.model.status.StrimziPodSetStatusFluentImpl<io.strimzi.api.kafka.model.status.StrimziPodSetStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.status.StrimziPodSetStatus,io.strimzi.api.kafka.model.status.StrimziPodSetStatusBuilder> {

    io.strimzi.api.kafka.model.status.StrimziPodSetStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public StrimziPodSetStatusBuilder() {
        this(true);
    }

    public StrimziPodSetStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new StrimziPodSetStatus(), validationEnabled);
    }

    public StrimziPodSetStatusBuilder(io.strimzi.api.kafka.model.status.StrimziPodSetStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public StrimziPodSetStatusBuilder(io.strimzi.api.kafka.model.status.StrimziPodSetStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new StrimziPodSetStatus(), validationEnabled);
    }

    public StrimziPodSetStatusBuilder(io.strimzi.api.kafka.model.status.StrimziPodSetStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.StrimziPodSetStatus instance) {
        this(fluent, instance, true);
    }

    public StrimziPodSetStatusBuilder(io.strimzi.api.kafka.model.status.StrimziPodSetStatusFluent<?> fluent,io.strimzi.api.kafka.model.status.StrimziPodSetStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPods(instance.getPods());
        
        fluent.withReadyPods(instance.getReadyPods());
        
        fluent.withCurrentPods(instance.getCurrentPods());
        
        fluent.withConditions(instance.getConditions());
        
        fluent.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public StrimziPodSetStatusBuilder(io.strimzi.api.kafka.model.status.StrimziPodSetStatus instance) {
        this(instance,true);
    }

    public StrimziPodSetStatusBuilder(io.strimzi.api.kafka.model.status.StrimziPodSetStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withPods(instance.getPods());
        
        this.withReadyPods(instance.getReadyPods());
        
        this.withCurrentPods(instance.getCurrentPods());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.status.StrimziPodSetStatus build() {
        StrimziPodSetStatus buildable = new StrimziPodSetStatus();
        buildable.setConditions(fluent.getConditions());
        buildable.setObservedGeneration(fluent.getObservedGeneration());
        buildable.setPods(fluent.getPods());
        buildable.setReadyPods(fluent.getReadyPods());
        buildable.setCurrentPods(fluent.getCurrentPods());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StrimziPodSetStatusBuilder that = (StrimziPodSetStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
