package io.strimzi.api.kafka.model.status;

import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a status of the StrimziPodSet resource
   */
  public class StrimziPodSetStatusFluentImpl<A extends io.strimzi.api.kafka.model.status.StrimziPodSetStatusFluent<A>> extends io.strimzi.api.kafka.model.status.StatusFluentImpl<A> implements io.strimzi.api.kafka.model.status.StrimziPodSetStatusFluent<A> {

    private int pods;
    private int readyPods;
    private int currentPods;

    public StrimziPodSetStatusFluentImpl() {
    }

    public StrimziPodSetStatusFluentImpl(io.strimzi.api.kafka.model.status.StrimziPodSetStatus instance) {
        this.withPods(instance.getPods());
        
        this.withReadyPods(instance.getReadyPods());
        
        this.withCurrentPods(instance.getCurrentPods());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public int getPods() {
        return this.pods;
    }

    public A withPods(int pods) {
        this.pods=pods; return (A) this;
    }

    public java.lang.Boolean hasPods() {
        return true;
    }

    public int getReadyPods() {
        return this.readyPods;
    }

    public A withReadyPods(int readyPods) {
        this.readyPods=readyPods; return (A) this;
    }

    public java.lang.Boolean hasReadyPods() {
        return true;
    }

    public int getCurrentPods() {
        return this.currentPods;
    }

    public A withCurrentPods(int currentPods) {
        this.currentPods=currentPods; return (A) this;
    }

    public java.lang.Boolean hasCurrentPods() {
        return true;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StrimziPodSetStatusFluentImpl that = (StrimziPodSetStatusFluentImpl) o;
        if (pods != that.pods) return false;
        if (readyPods != that.readyPods) return false;
        if (currentPods != that.currentPods) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(pods,  readyPods,  currentPods,  super.hashCode());
    }

}
