package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation for ephemeral storage.
   */
  public class EphemeralStorageBuilder extends io.strimzi.api.kafka.model.storage.EphemeralStorageFluentImpl<io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.storage.EphemeralStorage,io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder> {

    io.strimzi.api.kafka.model.storage.EphemeralStorageFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public EphemeralStorageBuilder() {
        this(true);
    }

    public EphemeralStorageBuilder(java.lang.Boolean validationEnabled) {
        this(new EphemeralStorage(), validationEnabled);
    }

    public EphemeralStorageBuilder(io.strimzi.api.kafka.model.storage.EphemeralStorageFluent<?> fluent) {
        this(fluent, true);
    }

    public EphemeralStorageBuilder(io.strimzi.api.kafka.model.storage.EphemeralStorageFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new EphemeralStorage(), validationEnabled);
    }

    public EphemeralStorageBuilder(io.strimzi.api.kafka.model.storage.EphemeralStorageFluent<?> fluent,io.strimzi.api.kafka.model.storage.EphemeralStorage instance) {
        this(fluent, instance, true);
    }

    public EphemeralStorageBuilder(io.strimzi.api.kafka.model.storage.EphemeralStorageFluent<?> fluent,io.strimzi.api.kafka.model.storage.EphemeralStorage instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withId(instance.getId());
        
        fluent.withSizeLimit(instance.getSizeLimit());
        
        this.validationEnabled = validationEnabled; 
    }

    public EphemeralStorageBuilder(io.strimzi.api.kafka.model.storage.EphemeralStorage instance) {
        this(instance,true);
    }

    public EphemeralStorageBuilder(io.strimzi.api.kafka.model.storage.EphemeralStorage instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withId(instance.getId());
        
        this.withSizeLimit(instance.getSizeLimit());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.storage.EphemeralStorage build() {
        EphemeralStorage buildable = new EphemeralStorage();
        buildable.setId(fluent.getId());
        buildable.setSizeLimit(fluent.getSizeLimit());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EphemeralStorageBuilder that = (EphemeralStorageBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
